/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.materialproviders;

import Wrappers_Compile.Option;
import dafny.DafnyMap;
import dafny.DafnySequence;
import dafny.TypeDescriptor;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import software.amazon.cryptography.keystore.internaldafny.types.IKeyStoreClient;
import software.amazon.cryptography.materialproviders.BranchKeyIdSupplier;
import software.amazon.cryptography.materialproviders.ClientSupplier;
import software.amazon.cryptography.materialproviders.CryptographicMaterialsCache;
import software.amazon.cryptography.materialproviders.CryptographicMaterialsManager;
import software.amazon.cryptography.materialproviders.IBranchKeyIdSupplier;
import software.amazon.cryptography.materialproviders.ICryptographicMaterialsCache;
import software.amazon.cryptography.materialproviders.IKeyring;
import software.amazon.cryptography.materialproviders.Keyring;
import software.amazon.cryptography.materialproviders.MaterialProviders;
import software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteId;
import software.amazon.cryptography.materialproviders.internaldafny.types.CacheType;
import software.amazon.cryptography.materialproviders.internaldafny.types.CreateAwsKmsDiscoveryKeyringInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.CreateAwsKmsDiscoveryMultiKeyringInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.CreateAwsKmsKeyringInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.CreateAwsKmsMrkDiscoveryKeyringInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.CreateAwsKmsMrkDiscoveryMultiKeyringInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.CreateAwsKmsMrkMultiKeyringInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.CreateAwsKmsMultiKeyringInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.CreateDefaultCryptographicMaterialsManagerInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.CreateMultiKeyringInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.CreateRawAesKeyringInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.CreateRequiredEncryptionContextCMMInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.DBECommitmentPolicy;
import software.amazon.cryptography.materialproviders.internaldafny.types.DIRECT__KEY__WRAPPING;
import software.amazon.cryptography.materialproviders.internaldafny.types.DecryptionMaterials;
import software.amazon.cryptography.materialproviders.internaldafny.types.DefaultCache;
import software.amazon.cryptography.materialproviders.internaldafny.types.DeleteCacheEntryInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.DiscoveryFilter;
import software.amazon.cryptography.materialproviders.internaldafny.types.ECDSA;
import software.amazon.cryptography.materialproviders.internaldafny.types.ESDKAlgorithmSuiteId;
import software.amazon.cryptography.materialproviders.internaldafny.types.ESDKCommitmentPolicy;
import software.amazon.cryptography.materialproviders.internaldafny.types.EdkWrappingAlgorithm;
import software.amazon.cryptography.materialproviders.internaldafny.types.Encrypt;
import software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey;
import software.amazon.cryptography.materialproviders.internaldafny.types.EphemeralPrivateKeyToStaticPublicKeyInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.Error;
import software.amazon.cryptography.materialproviders.internaldafny.types.Error_AwsCryptographicMaterialProvidersException;
import software.amazon.cryptography.materialproviders.internaldafny.types.Error_EntryAlreadyExists;
import software.amazon.cryptography.materialproviders.internaldafny.types.Error_EntryDoesNotExist;
import software.amazon.cryptography.materialproviders.internaldafny.types.Error_InFlightTTLExceeded;
import software.amazon.cryptography.materialproviders.internaldafny.types.Error_InvalidAlgorithmSuiteInfo;
import software.amazon.cryptography.materialproviders.internaldafny.types.Error_InvalidAlgorithmSuiteInfoOnDecrypt;
import software.amazon.cryptography.materialproviders.internaldafny.types.Error_InvalidAlgorithmSuiteInfoOnEncrypt;
import software.amazon.cryptography.materialproviders.internaldafny.types.Error_InvalidDecryptionMaterials;
import software.amazon.cryptography.materialproviders.internaldafny.types.Error_InvalidDecryptionMaterialsTransition;
import software.amazon.cryptography.materialproviders.internaldafny.types.Error_InvalidEncryptionMaterials;
import software.amazon.cryptography.materialproviders.internaldafny.types.Error_InvalidEncryptionMaterialsTransition;
import software.amazon.cryptography.materialproviders.internaldafny.types.GetBranchKeyIdOutput;
import software.amazon.cryptography.materialproviders.internaldafny.types.GetCacheEntryInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.GetCacheEntryOutput;
import software.amazon.cryptography.materialproviders.internaldafny.types.GetClientInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.GetEncryptionMaterialsInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.HKDF;
import software.amazon.cryptography.materialproviders.internaldafny.types.IAwsCryptographicMaterialProvidersClient;
import software.amazon.cryptography.materialproviders.internaldafny.types.IClientSupplier;
import software.amazon.cryptography.materialproviders.internaldafny.types.ICryptographicMaterialsManager;
import software.amazon.cryptography.materialproviders.internaldafny.types.IDENTITY;
import software.amazon.cryptography.materialproviders.internaldafny.types.InitializeDecryptionMaterialsInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.KeyAgreementScheme;
import software.amazon.cryptography.materialproviders.internaldafny.types.KmsEcdhStaticConfigurations;
import software.amazon.cryptography.materialproviders.internaldafny.types.MaterialProvidersConfig;
import software.amazon.cryptography.materialproviders.internaldafny.types.Materials;
import software.amazon.cryptography.materialproviders.internaldafny.types.NoCache;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptOutput;
import software.amazon.cryptography.materialproviders.internaldafny.types.RawEcdhStaticConfigurations;
import software.amazon.cryptography.materialproviders.internaldafny.types.RawPrivateKeyToStaticPublicKeyInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.SignatureAlgorithm;
import software.amazon.cryptography.materialproviders.internaldafny.types.SingleThreadedCache;
import software.amazon.cryptography.materialproviders.internaldafny.types.StormTrackingCache;
import software.amazon.cryptography.materialproviders.internaldafny.types.SymmetricSignatureAlgorithm;
import software.amazon.cryptography.materialproviders.internaldafny.types.TimeUnits;
import software.amazon.cryptography.materialproviders.internaldafny.types.ValidEncryptionMaterialsTransitionInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.ValidateCommitmentPolicyOnDecryptInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.ValidateCommitmentPolicyOnEncryptInput;
import software.amazon.cryptography.materialproviders.model.AesWrappingAlg;
import software.amazon.cryptography.materialproviders.model.AlgorithmSuiteInfo;
import software.amazon.cryptography.materialproviders.model.AwsCryptographicMaterialProvidersException;
import software.amazon.cryptography.materialproviders.model.CollectionOfErrors;
import software.amazon.cryptography.materialproviders.model.CommitmentPolicy;
import software.amazon.cryptography.materialproviders.model.CreateAwsKmsEcdhKeyringInput;
import software.amazon.cryptography.materialproviders.model.CreateAwsKmsHierarchicalKeyringInput;
import software.amazon.cryptography.materialproviders.model.CreateAwsKmsMrkKeyringInput;
import software.amazon.cryptography.materialproviders.model.CreateAwsKmsRsaKeyringInput;
import software.amazon.cryptography.materialproviders.model.CreateCryptographicMaterialsCacheInput;
import software.amazon.cryptography.materialproviders.model.CreateDefaultClientSupplierInput;
import software.amazon.cryptography.materialproviders.model.CreateRawEcdhKeyringInput;
import software.amazon.cryptography.materialproviders.model.CreateRawRsaKeyringInput;
import software.amazon.cryptography.materialproviders.model.DBEAlgorithmSuiteId;
import software.amazon.cryptography.materialproviders.model.DIRECT_KEY_WRAPPING;
import software.amazon.cryptography.materialproviders.model.DecryptMaterialsInput;
import software.amazon.cryptography.materialproviders.model.DecryptMaterialsOutput;
import software.amazon.cryptography.materialproviders.model.DerivationAlgorithm;
import software.amazon.cryptography.materialproviders.model.EncryptionMaterials;
import software.amazon.cryptography.materialproviders.model.EntryAlreadyExists;
import software.amazon.cryptography.materialproviders.model.EntryDoesNotExist;
import software.amazon.cryptography.materialproviders.model.GetBranchKeyIdInput;
import software.amazon.cryptography.materialproviders.model.GetEncryptionMaterialsOutput;
import software.amazon.cryptography.materialproviders.model.InFlightTTLExceeded;
import software.amazon.cryptography.materialproviders.model.InitializeEncryptionMaterialsInput;
import software.amazon.cryptography.materialproviders.model.IntermediateKeyWrapping;
import software.amazon.cryptography.materialproviders.model.InvalidAlgorithmSuiteInfo;
import software.amazon.cryptography.materialproviders.model.InvalidAlgorithmSuiteInfoOnDecrypt;
import software.amazon.cryptography.materialproviders.model.InvalidAlgorithmSuiteInfoOnEncrypt;
import software.amazon.cryptography.materialproviders.model.InvalidDecryptionMaterials;
import software.amazon.cryptography.materialproviders.model.InvalidDecryptionMaterialsTransition;
import software.amazon.cryptography.materialproviders.model.InvalidEncryptionMaterials;
import software.amazon.cryptography.materialproviders.model.InvalidEncryptionMaterialsTransition;
import software.amazon.cryptography.materialproviders.model.KmsPrivateKeyToStaticPublicKeyInput;
import software.amazon.cryptography.materialproviders.model.KmsPublicKeyDiscoveryInput;
import software.amazon.cryptography.materialproviders.model.MultiThreadedCache;
import software.amazon.cryptography.materialproviders.model.None;
import software.amazon.cryptography.materialproviders.model.OnDecryptInput;
import software.amazon.cryptography.materialproviders.model.OnDecryptOutput;
import software.amazon.cryptography.materialproviders.model.OnEncryptInput;
import software.amazon.cryptography.materialproviders.model.OpaqueError;
import software.amazon.cryptography.materialproviders.model.OpaqueWithTextError;
import software.amazon.cryptography.materialproviders.model.PaddingScheme;
import software.amazon.cryptography.materialproviders.model.PublicKeyDiscoveryInput;
import software.amazon.cryptography.materialproviders.model.PutCacheEntryInput;
import software.amazon.cryptography.materialproviders.model.StaticConfigurations;
import software.amazon.cryptography.materialproviders.model.UpdateUsageMetadataInput;
import software.amazon.cryptography.materialproviders.model.ValidDecryptionMaterialsTransitionInput;
import software.amazon.cryptography.primitives.internaldafny.types.DigestAlgorithm;
import software.amazon.cryptography.primitives.internaldafny.types.ECDHCurveSpec;
import software.amazon.cryptography.primitives.internaldafny.types.ECDSASignatureAlgorithm;
import software.amazon.cryptography.services.kms.internaldafny.types.EncryptionAlgorithmSpec;
import software.amazon.cryptography.services.kms.internaldafny.types.IKMSClient;
import software.amazon.smithy.dafny.conversion.ToDafny;

public class ToDafny {
    public static Error Error(RuntimeException nativeValue) {
        if (nativeValue instanceof AwsCryptographicMaterialProvidersException) {
            return ToDafny.Error((AwsCryptographicMaterialProvidersException)nativeValue);
        }
        if (nativeValue instanceof EntryAlreadyExists) {
            return ToDafny.Error((EntryAlreadyExists)nativeValue);
        }
        if (nativeValue instanceof EntryDoesNotExist) {
            return ToDafny.Error((EntryDoesNotExist)nativeValue);
        }
        if (nativeValue instanceof InFlightTTLExceeded) {
            return ToDafny.Error((InFlightTTLExceeded)nativeValue);
        }
        if (nativeValue instanceof InvalidAlgorithmSuiteInfo) {
            return ToDafny.Error((InvalidAlgorithmSuiteInfo)nativeValue);
        }
        if (nativeValue instanceof InvalidAlgorithmSuiteInfoOnDecrypt) {
            return ToDafny.Error((InvalidAlgorithmSuiteInfoOnDecrypt)nativeValue);
        }
        if (nativeValue instanceof InvalidAlgorithmSuiteInfoOnEncrypt) {
            return ToDafny.Error((InvalidAlgorithmSuiteInfoOnEncrypt)nativeValue);
        }
        if (nativeValue instanceof InvalidDecryptionMaterials) {
            return ToDafny.Error((InvalidDecryptionMaterials)nativeValue);
        }
        if (nativeValue instanceof InvalidDecryptionMaterialsTransition) {
            return ToDafny.Error((InvalidDecryptionMaterialsTransition)nativeValue);
        }
        if (nativeValue instanceof InvalidEncryptionMaterials) {
            return ToDafny.Error((InvalidEncryptionMaterials)nativeValue);
        }
        if (nativeValue instanceof InvalidEncryptionMaterialsTransition) {
            return ToDafny.Error((InvalidEncryptionMaterialsTransition)nativeValue);
        }
        if (nativeValue instanceof OpaqueError) {
            return ToDafny.Error((OpaqueError)nativeValue);
        }
        if (nativeValue instanceof OpaqueWithTextError) {
            return ToDafny.Error((OpaqueWithTextError)nativeValue);
        }
        if (nativeValue instanceof CollectionOfErrors) {
            return ToDafny.Error((CollectionOfErrors)nativeValue);
        }
        return Error.create_Opaque(nativeValue);
    }

    public static Error Error(OpaqueError nativeValue) {
        return Error.create_Opaque(nativeValue.obj());
    }

    public static Error Error(OpaqueWithTextError nativeValue) {
        return Error.create_OpaqueWithText(nativeValue.obj(), (DafnySequence<? extends Character>)DafnySequence.asString((String)nativeValue.objMessage()));
    }

    public static Error Error(CollectionOfErrors nativeValue) {
        DafnySequence list = ToDafny.Aggregate.GenericToSequence(nativeValue.list(), ToDafny::Error, Error._typeDescriptor());
        DafnySequence message = ToDafny.Simple.CharacterSequence((String)nativeValue.getMessage());
        return Error.create_CollectionOfErrors((DafnySequence<? extends Error>)list, (DafnySequence<? extends Character>)message);
    }

    public static software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteInfo AlgorithmSuiteInfo(AlgorithmSuiteInfo nativeValue) {
        AlgorithmSuiteId id = ToDafny.AlgorithmSuiteId(nativeValue.id());
        DafnySequence binaryId = ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue.binaryId());
        Integer messageVersion = nativeValue.messageVersion();
        Encrypt encrypt = ToDafny.Encrypt(nativeValue.encrypt());
        software.amazon.cryptography.materialproviders.internaldafny.types.DerivationAlgorithm kdf = ToDafny.DerivationAlgorithm(nativeValue.kdf());
        software.amazon.cryptography.materialproviders.internaldafny.types.DerivationAlgorithm commitment = ToDafny.DerivationAlgorithm(nativeValue.commitment());
        SignatureAlgorithm signature = ToDafny.SignatureAlgorithm(nativeValue.signature());
        SymmetricSignatureAlgorithm symmetricSignature = ToDafny.SymmetricSignatureAlgorithm(nativeValue.symmetricSignature());
        EdkWrappingAlgorithm edkWrapping = ToDafny.EdkWrappingAlgorithm(nativeValue.edkWrapping());
        return new software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteInfo(id, (DafnySequence<? extends Byte>)binaryId, messageVersion, encrypt, kdf, commitment, signature, symmetricSignature, edkWrapping);
    }

    public static CreateAwsKmsDiscoveryKeyringInput CreateAwsKmsDiscoveryKeyringInput(software.amazon.cryptography.materialproviders.model.CreateAwsKmsDiscoveryKeyringInput nativeValue) {
        IKMSClient kmsClient = software.amazon.cryptography.services.kms.internaldafny.ToDafny.TrentService(nativeValue.kmsClient());
        Option<DiscoveryFilter> discoveryFilter = Objects.nonNull(nativeValue.discoveryFilter()) ? Option.create_Some(DiscoveryFilter._typeDescriptor(), ToDafny.DiscoveryFilter(nativeValue.discoveryFilter())) : Option.create_None(DiscoveryFilter._typeDescriptor());
        Option<DafnySequence<? extends DafnySequence<? extends Character>>> grantTokens = Objects.nonNull(nativeValue.grantTokens()) && nativeValue.grantTokens().size() > 0 ? Option.create_Some(DafnySequence._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)), ToDafny.GrantTokenList(nativeValue.grantTokens())) : Option.create_None(DafnySequence._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)));
        return new CreateAwsKmsDiscoveryKeyringInput(kmsClient, discoveryFilter, grantTokens);
    }

    public static CreateAwsKmsDiscoveryMultiKeyringInput CreateAwsKmsDiscoveryMultiKeyringInput(software.amazon.cryptography.materialproviders.model.CreateAwsKmsDiscoveryMultiKeyringInput nativeValue) {
        DafnySequence<? extends DafnySequence<? extends Character>> regions = ToDafny.RegionList(nativeValue.regions());
        Option<DiscoveryFilter> discoveryFilter = Objects.nonNull(nativeValue.discoveryFilter()) ? Option.create_Some(DiscoveryFilter._typeDescriptor(), ToDafny.DiscoveryFilter(nativeValue.discoveryFilter())) : Option.create_None(DiscoveryFilter._typeDescriptor());
        Option<IClientSupplier> clientSupplier = Objects.nonNull(nativeValue.clientSupplier()) ? Option.create_Some(TypeDescriptor.reference(IClientSupplier.class), ToDafny.ClientSupplier(nativeValue.clientSupplier())) : Option.create_None(TypeDescriptor.reference(IClientSupplier.class));
        Option<DafnySequence<? extends DafnySequence<? extends Character>>> grantTokens = Objects.nonNull(nativeValue.grantTokens()) && nativeValue.grantTokens().size() > 0 ? Option.create_Some(DafnySequence._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)), ToDafny.GrantTokenList(nativeValue.grantTokens())) : Option.create_None(DafnySequence._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)));
        return new CreateAwsKmsDiscoveryMultiKeyringInput(regions, discoveryFilter, clientSupplier, grantTokens);
    }

    public static software.amazon.cryptography.materialproviders.internaldafny.types.CreateAwsKmsEcdhKeyringInput CreateAwsKmsEcdhKeyringInput(CreateAwsKmsEcdhKeyringInput nativeValue) {
        KmsEcdhStaticConfigurations keyAgreementScheme = ToDafny.KmsEcdhStaticConfigurations(nativeValue.KeyAgreementScheme());
        ECDHCurveSpec curveSpec = software.amazon.cryptography.primitives.ToDafny.ECDHCurveSpec(nativeValue.curveSpec());
        IKMSClient kmsClient = software.amazon.cryptography.services.kms.internaldafny.ToDafny.TrentService(nativeValue.kmsClient());
        Option<DafnySequence<? extends DafnySequence<? extends Character>>> grantTokens = Objects.nonNull(nativeValue.grantTokens()) && nativeValue.grantTokens().size() > 0 ? Option.create_Some(DafnySequence._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)), ToDafny.GrantTokenList(nativeValue.grantTokens())) : Option.create_None(DafnySequence._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)));
        return new software.amazon.cryptography.materialproviders.internaldafny.types.CreateAwsKmsEcdhKeyringInput(keyAgreementScheme, curveSpec, kmsClient, grantTokens);
    }

    public static software.amazon.cryptography.materialproviders.internaldafny.types.CreateAwsKmsHierarchicalKeyringInput CreateAwsKmsHierarchicalKeyringInput(CreateAwsKmsHierarchicalKeyringInput nativeValue) {
        Option<DafnySequence<? extends Character>> branchKeyId = Objects.nonNull(nativeValue.branchKeyId()) ? Option.create_Some(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), ToDafny.Simple.CharacterSequence((String)nativeValue.branchKeyId())) : Option.create_None(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR));
        Option<software.amazon.cryptography.materialproviders.internaldafny.types.IBranchKeyIdSupplier> branchKeyIdSupplier = Objects.nonNull(nativeValue.branchKeyIdSupplier()) ? Option.create_Some(TypeDescriptor.reference(software.amazon.cryptography.materialproviders.internaldafny.types.IBranchKeyIdSupplier.class), ToDafny.BranchKeyIdSupplier(nativeValue.branchKeyIdSupplier())) : Option.create_None(TypeDescriptor.reference(software.amazon.cryptography.materialproviders.internaldafny.types.IBranchKeyIdSupplier.class));
        IKeyStoreClient keyStore = software.amazon.cryptography.keystore.ToDafny.KeyStore(nativeValue.keyStore());
        Long ttlSeconds = nativeValue.ttlSeconds();
        Option<CacheType> cache = Objects.nonNull(nativeValue.cache()) ? Option.create_Some(CacheType._typeDescriptor(), ToDafny.CacheType(nativeValue.cache())) : Option.create_None(CacheType._typeDescriptor());
        Option<DafnySequence<? extends Character>> partitionId = Objects.nonNull(nativeValue.partitionId()) ? Option.create_Some(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), ToDafny.Simple.CharacterSequence((String)nativeValue.partitionId())) : Option.create_None(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR));
        return new software.amazon.cryptography.materialproviders.internaldafny.types.CreateAwsKmsHierarchicalKeyringInput(branchKeyId, branchKeyIdSupplier, keyStore, ttlSeconds, cache, partitionId);
    }

    public static CreateAwsKmsKeyringInput CreateAwsKmsKeyringInput(software.amazon.cryptography.materialproviders.model.CreateAwsKmsKeyringInput nativeValue) {
        DafnySequence kmsKeyId = ToDafny.Simple.CharacterSequence((String)nativeValue.kmsKeyId());
        IKMSClient kmsClient = software.amazon.cryptography.services.kms.internaldafny.ToDafny.TrentService(nativeValue.kmsClient());
        Option<DafnySequence<? extends DafnySequence<? extends Character>>> grantTokens = Objects.nonNull(nativeValue.grantTokens()) && nativeValue.grantTokens().size() > 0 ? Option.create_Some(DafnySequence._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)), ToDafny.GrantTokenList(nativeValue.grantTokens())) : Option.create_None(DafnySequence._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)));
        return new CreateAwsKmsKeyringInput((DafnySequence<? extends Character>)kmsKeyId, kmsClient, grantTokens);
    }

    public static CreateAwsKmsMrkDiscoveryKeyringInput CreateAwsKmsMrkDiscoveryKeyringInput(software.amazon.cryptography.materialproviders.model.CreateAwsKmsMrkDiscoveryKeyringInput nativeValue) {
        IKMSClient kmsClient = software.amazon.cryptography.services.kms.internaldafny.ToDafny.TrentService(nativeValue.kmsClient());
        Option<DiscoveryFilter> discoveryFilter = Objects.nonNull(nativeValue.discoveryFilter()) ? Option.create_Some(DiscoveryFilter._typeDescriptor(), ToDafny.DiscoveryFilter(nativeValue.discoveryFilter())) : Option.create_None(DiscoveryFilter._typeDescriptor());
        Option<DafnySequence<? extends DafnySequence<? extends Character>>> grantTokens = Objects.nonNull(nativeValue.grantTokens()) && nativeValue.grantTokens().size() > 0 ? Option.create_Some(DafnySequence._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)), ToDafny.GrantTokenList(nativeValue.grantTokens())) : Option.create_None(DafnySequence._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)));
        DafnySequence region = ToDafny.Simple.CharacterSequence((String)nativeValue.region());
        return new CreateAwsKmsMrkDiscoveryKeyringInput(kmsClient, discoveryFilter, grantTokens, (DafnySequence<? extends Character>)region);
    }

    public static CreateAwsKmsMrkDiscoveryMultiKeyringInput CreateAwsKmsMrkDiscoveryMultiKeyringInput(software.amazon.cryptography.materialproviders.model.CreateAwsKmsMrkDiscoveryMultiKeyringInput nativeValue) {
        DafnySequence<? extends DafnySequence<? extends Character>> regions = ToDafny.RegionList(nativeValue.regions());
        Option<DiscoveryFilter> discoveryFilter = Objects.nonNull(nativeValue.discoveryFilter()) ? Option.create_Some(DiscoveryFilter._typeDescriptor(), ToDafny.DiscoveryFilter(nativeValue.discoveryFilter())) : Option.create_None(DiscoveryFilter._typeDescriptor());
        Option<IClientSupplier> clientSupplier = Objects.nonNull(nativeValue.clientSupplier()) ? Option.create_Some(TypeDescriptor.reference(IClientSupplier.class), ToDafny.ClientSupplier(nativeValue.clientSupplier())) : Option.create_None(TypeDescriptor.reference(IClientSupplier.class));
        Option<DafnySequence<? extends DafnySequence<? extends Character>>> grantTokens = Objects.nonNull(nativeValue.grantTokens()) && nativeValue.grantTokens().size() > 0 ? Option.create_Some(DafnySequence._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)), ToDafny.GrantTokenList(nativeValue.grantTokens())) : Option.create_None(DafnySequence._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)));
        return new CreateAwsKmsMrkDiscoveryMultiKeyringInput(regions, discoveryFilter, clientSupplier, grantTokens);
    }

    public static software.amazon.cryptography.materialproviders.internaldafny.types.CreateAwsKmsMrkKeyringInput CreateAwsKmsMrkKeyringInput(CreateAwsKmsMrkKeyringInput nativeValue) {
        DafnySequence kmsKeyId = ToDafny.Simple.CharacterSequence((String)nativeValue.kmsKeyId());
        IKMSClient kmsClient = software.amazon.cryptography.services.kms.internaldafny.ToDafny.TrentService(nativeValue.kmsClient());
        Option<DafnySequence<? extends DafnySequence<? extends Character>>> grantTokens = Objects.nonNull(nativeValue.grantTokens()) && nativeValue.grantTokens().size() > 0 ? Option.create_Some(DafnySequence._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)), ToDafny.GrantTokenList(nativeValue.grantTokens())) : Option.create_None(DafnySequence._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)));
        return new software.amazon.cryptography.materialproviders.internaldafny.types.CreateAwsKmsMrkKeyringInput((DafnySequence<? extends Character>)kmsKeyId, kmsClient, grantTokens);
    }

    public static CreateAwsKmsMrkMultiKeyringInput CreateAwsKmsMrkMultiKeyringInput(software.amazon.cryptography.materialproviders.model.CreateAwsKmsMrkMultiKeyringInput nativeValue) {
        Option<DafnySequence<? extends Character>> generator = Objects.nonNull(nativeValue.generator()) ? Option.create_Some(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), ToDafny.Simple.CharacterSequence((String)nativeValue.generator())) : Option.create_None(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR));
        Option<DafnySequence<? extends DafnySequence<? extends Character>>> kmsKeyIds = Objects.nonNull(nativeValue.kmsKeyIds()) && nativeValue.kmsKeyIds().size() > 0 ? Option.create_Some(DafnySequence._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)), ToDafny.KmsKeyIdList(nativeValue.kmsKeyIds())) : Option.create_None(DafnySequence._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)));
        Option<IClientSupplier> clientSupplier = Objects.nonNull(nativeValue.clientSupplier()) ? Option.create_Some(TypeDescriptor.reference(IClientSupplier.class), ToDafny.ClientSupplier(nativeValue.clientSupplier())) : Option.create_None(TypeDescriptor.reference(IClientSupplier.class));
        Option<DafnySequence<? extends DafnySequence<? extends Character>>> grantTokens = Objects.nonNull(nativeValue.grantTokens()) && nativeValue.grantTokens().size() > 0 ? Option.create_Some(DafnySequence._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)), ToDafny.GrantTokenList(nativeValue.grantTokens())) : Option.create_None(DafnySequence._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)));
        return new CreateAwsKmsMrkMultiKeyringInput(generator, kmsKeyIds, clientSupplier, grantTokens);
    }

    public static CreateAwsKmsMultiKeyringInput CreateAwsKmsMultiKeyringInput(software.amazon.cryptography.materialproviders.model.CreateAwsKmsMultiKeyringInput nativeValue) {
        Option<DafnySequence<? extends Character>> generator = Objects.nonNull(nativeValue.generator()) ? Option.create_Some(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), ToDafny.Simple.CharacterSequence((String)nativeValue.generator())) : Option.create_None(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR));
        Option<DafnySequence<? extends DafnySequence<? extends Character>>> kmsKeyIds = Objects.nonNull(nativeValue.kmsKeyIds()) && nativeValue.kmsKeyIds().size() > 0 ? Option.create_Some(DafnySequence._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)), ToDafny.KmsKeyIdList(nativeValue.kmsKeyIds())) : Option.create_None(DafnySequence._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)));
        Option<IClientSupplier> clientSupplier = Objects.nonNull(nativeValue.clientSupplier()) ? Option.create_Some(TypeDescriptor.reference(IClientSupplier.class), ToDafny.ClientSupplier(nativeValue.clientSupplier())) : Option.create_None(TypeDescriptor.reference(IClientSupplier.class));
        Option<DafnySequence<? extends DafnySequence<? extends Character>>> grantTokens = Objects.nonNull(nativeValue.grantTokens()) && nativeValue.grantTokens().size() > 0 ? Option.create_Some(DafnySequence._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)), ToDafny.GrantTokenList(nativeValue.grantTokens())) : Option.create_None(DafnySequence._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)));
        return new CreateAwsKmsMultiKeyringInput(generator, kmsKeyIds, clientSupplier, grantTokens);
    }

    public static software.amazon.cryptography.materialproviders.internaldafny.types.CreateAwsKmsRsaKeyringInput CreateAwsKmsRsaKeyringInput(CreateAwsKmsRsaKeyringInput nativeValue) {
        Option<DafnySequence<? extends Byte>> publicKey = Objects.nonNull(nativeValue.publicKey()) ? Option.create_Some(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.BYTE), ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue.publicKey())) : Option.create_None(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.BYTE));
        DafnySequence kmsKeyId = ToDafny.Simple.CharacterSequence((String)nativeValue.kmsKeyId());
        EncryptionAlgorithmSpec encryptionAlgorithm = software.amazon.cryptography.services.kms.internaldafny.ToDafny.EncryptionAlgorithmSpec(nativeValue.encryptionAlgorithm());
        Option<IKMSClient> kmsClient = Objects.nonNull(nativeValue.kmsClient()) ? Option.create_Some(TypeDescriptor.reference(IKMSClient.class), software.amazon.cryptography.services.kms.internaldafny.ToDafny.TrentService(nativeValue.kmsClient())) : Option.create_None(TypeDescriptor.reference(IKMSClient.class));
        Option<DafnySequence<? extends DafnySequence<? extends Character>>> grantTokens = Objects.nonNull(nativeValue.grantTokens()) && nativeValue.grantTokens().size() > 0 ? Option.create_Some(DafnySequence._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)), ToDafny.GrantTokenList(nativeValue.grantTokens())) : Option.create_None(DafnySequence._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)));
        return new software.amazon.cryptography.materialproviders.internaldafny.types.CreateAwsKmsRsaKeyringInput(publicKey, (DafnySequence<? extends Character>)kmsKeyId, encryptionAlgorithm, kmsClient, grantTokens);
    }

    public static software.amazon.cryptography.materialproviders.internaldafny.types.CreateCryptographicMaterialsCacheInput CreateCryptographicMaterialsCacheInput(CreateCryptographicMaterialsCacheInput nativeValue) {
        CacheType cache = ToDafny.CacheType(nativeValue.cache());
        return new software.amazon.cryptography.materialproviders.internaldafny.types.CreateCryptographicMaterialsCacheInput(cache);
    }

    public static software.amazon.cryptography.materialproviders.internaldafny.types.CreateDefaultClientSupplierInput CreateDefaultClientSupplierInput(CreateDefaultClientSupplierInput nativeValue) {
        return new software.amazon.cryptography.materialproviders.internaldafny.types.CreateDefaultClientSupplierInput();
    }

    public static CreateDefaultCryptographicMaterialsManagerInput CreateDefaultCryptographicMaterialsManagerInput(software.amazon.cryptography.materialproviders.model.CreateDefaultCryptographicMaterialsManagerInput nativeValue) {
        software.amazon.cryptography.materialproviders.internaldafny.types.IKeyring keyring = ToDafny.Keyring(nativeValue.keyring());
        return new CreateDefaultCryptographicMaterialsManagerInput(keyring);
    }

    public static CreateMultiKeyringInput CreateMultiKeyringInput(software.amazon.cryptography.materialproviders.model.CreateMultiKeyringInput nativeValue) {
        Option<software.amazon.cryptography.materialproviders.internaldafny.types.IKeyring> generator = Objects.nonNull(nativeValue.generator()) ? Option.create_Some(TypeDescriptor.reference(software.amazon.cryptography.materialproviders.internaldafny.types.IKeyring.class), ToDafny.Keyring(nativeValue.generator())) : Option.create_None(TypeDescriptor.reference(software.amazon.cryptography.materialproviders.internaldafny.types.IKeyring.class));
        DafnySequence<? extends software.amazon.cryptography.materialproviders.internaldafny.types.IKeyring> childKeyrings = ToDafny.KeyringList(nativeValue.childKeyrings());
        return new CreateMultiKeyringInput(generator, childKeyrings);
    }

    public static CreateRawAesKeyringInput CreateRawAesKeyringInput(software.amazon.cryptography.materialproviders.model.CreateRawAesKeyringInput nativeValue) {
        DafnySequence keyNamespace = ToDafny.Simple.CharacterSequence((String)nativeValue.keyNamespace());
        DafnySequence keyName = ToDafny.Simple.CharacterSequence((String)nativeValue.keyName());
        DafnySequence wrappingKey = ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue.wrappingKey());
        software.amazon.cryptography.materialproviders.internaldafny.types.AesWrappingAlg wrappingAlg = ToDafny.AesWrappingAlg(nativeValue.wrappingAlg());
        return new CreateRawAesKeyringInput((DafnySequence<? extends Character>)keyNamespace, (DafnySequence<? extends Character>)keyName, (DafnySequence<? extends Byte>)wrappingKey, wrappingAlg);
    }

    public static software.amazon.cryptography.materialproviders.internaldafny.types.CreateRawEcdhKeyringInput CreateRawEcdhKeyringInput(CreateRawEcdhKeyringInput nativeValue) {
        RawEcdhStaticConfigurations keyAgreementScheme = ToDafny.RawEcdhStaticConfigurations(nativeValue.KeyAgreementScheme());
        ECDHCurveSpec curveSpec = software.amazon.cryptography.primitives.ToDafny.ECDHCurveSpec(nativeValue.curveSpec());
        return new software.amazon.cryptography.materialproviders.internaldafny.types.CreateRawEcdhKeyringInput(keyAgreementScheme, curveSpec);
    }

    public static software.amazon.cryptography.materialproviders.internaldafny.types.CreateRawRsaKeyringInput CreateRawRsaKeyringInput(CreateRawRsaKeyringInput nativeValue) {
        DafnySequence keyNamespace = ToDafny.Simple.CharacterSequence((String)nativeValue.keyNamespace());
        DafnySequence keyName = ToDafny.Simple.CharacterSequence((String)nativeValue.keyName());
        software.amazon.cryptography.materialproviders.internaldafny.types.PaddingScheme paddingScheme = ToDafny.PaddingScheme(nativeValue.paddingScheme());
        Option<DafnySequence<? extends Byte>> publicKey = Objects.nonNull(nativeValue.publicKey()) ? Option.create_Some(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.BYTE), ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue.publicKey())) : Option.create_None(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.BYTE));
        Option<DafnySequence<? extends Byte>> privateKey = Objects.nonNull(nativeValue.privateKey()) ? Option.create_Some(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.BYTE), ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue.privateKey())) : Option.create_None(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.BYTE));
        return new software.amazon.cryptography.materialproviders.internaldafny.types.CreateRawRsaKeyringInput((DafnySequence<? extends Character>)keyNamespace, (DafnySequence<? extends Character>)keyName, paddingScheme, publicKey, privateKey);
    }

    public static CreateRequiredEncryptionContextCMMInput CreateRequiredEncryptionContextCMMInput(software.amazon.cryptography.materialproviders.model.CreateRequiredEncryptionContextCMMInput nativeValue) {
        Option<ICryptographicMaterialsManager> underlyingCMM = Objects.nonNull(nativeValue.underlyingCMM()) ? Option.create_Some(TypeDescriptor.reference(ICryptographicMaterialsManager.class), ToDafny.CryptographicMaterialsManager(nativeValue.underlyingCMM())) : Option.create_None(TypeDescriptor.reference(ICryptographicMaterialsManager.class));
        Option<software.amazon.cryptography.materialproviders.internaldafny.types.IKeyring> keyring = Objects.nonNull(nativeValue.keyring()) ? Option.create_Some(TypeDescriptor.reference(software.amazon.cryptography.materialproviders.internaldafny.types.IKeyring.class), ToDafny.Keyring(nativeValue.keyring())) : Option.create_None(TypeDescriptor.reference(software.amazon.cryptography.materialproviders.internaldafny.types.IKeyring.class));
        DafnySequence<? extends DafnySequence<? extends Byte>> requiredEncryptionContextKeys = ToDafny.EncryptionContextKeys(nativeValue.requiredEncryptionContextKeys());
        return new CreateRequiredEncryptionContextCMMInput(underlyingCMM, keyring, requiredEncryptionContextKeys);
    }

    public static DecryptionMaterials DecryptionMaterials(software.amazon.cryptography.materialproviders.model.DecryptionMaterials nativeValue) {
        software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteInfo algorithmSuite = ToDafny.AlgorithmSuiteInfo(nativeValue.algorithmSuite());
        DafnyMap<? extends DafnySequence<? extends Byte>, ? extends DafnySequence<? extends Byte>> encryptionContext = ToDafny.EncryptionContext(nativeValue.encryptionContext());
        DafnySequence<? extends DafnySequence<? extends Byte>> requiredEncryptionContextKeys = ToDafny.EncryptionContextKeys(nativeValue.requiredEncryptionContextKeys());
        Option<DafnySequence<? extends Byte>> plaintextDataKey = Objects.nonNull(nativeValue.plaintextDataKey()) ? Option.create_Some(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.BYTE), ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue.plaintextDataKey())) : Option.create_None(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.BYTE));
        Option<DafnySequence<? extends Byte>> verificationKey = Objects.nonNull(nativeValue.verificationKey()) ? Option.create_Some(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.BYTE), ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue.verificationKey())) : Option.create_None(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.BYTE));
        Option<DafnySequence<? extends Byte>> symmetricSigningKey = Objects.nonNull(nativeValue.symmetricSigningKey()) ? Option.create_Some(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.BYTE), ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue.symmetricSigningKey())) : Option.create_None(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.BYTE));
        return new DecryptionMaterials(algorithmSuite, encryptionContext, requiredEncryptionContextKeys, plaintextDataKey, verificationKey, symmetricSigningKey);
    }

    public static software.amazon.cryptography.materialproviders.internaldafny.types.DecryptMaterialsInput DecryptMaterialsInput(DecryptMaterialsInput nativeValue) {
        AlgorithmSuiteId algorithmSuiteId = ToDafny.AlgorithmSuiteId(nativeValue.algorithmSuiteId());
        software.amazon.cryptography.materialproviders.internaldafny.types.CommitmentPolicy commitmentPolicy = ToDafny.CommitmentPolicy(nativeValue.commitmentPolicy());
        DafnySequence<? extends EncryptedDataKey> encryptedDataKeys = ToDafny.EncryptedDataKeyList(nativeValue.encryptedDataKeys());
        DafnyMap<? extends DafnySequence<? extends Byte>, ? extends DafnySequence<? extends Byte>> encryptionContext = ToDafny.EncryptionContext(nativeValue.encryptionContext());
        Option<DafnyMap<? extends DafnySequence<? extends Byte>, ? extends DafnySequence<? extends Byte>>> reproducedEncryptionContext = Objects.nonNull(nativeValue.reproducedEncryptionContext()) && nativeValue.reproducedEncryptionContext().size() > 0 ? Option.create_Some(DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.BYTE), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.BYTE)), ToDafny.EncryptionContext(nativeValue.reproducedEncryptionContext())) : Option.create_None(DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.BYTE), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.BYTE)));
        return new software.amazon.cryptography.materialproviders.internaldafny.types.DecryptMaterialsInput(algorithmSuiteId, commitmentPolicy, encryptedDataKeys, encryptionContext, reproducedEncryptionContext);
    }

    public static software.amazon.cryptography.materialproviders.internaldafny.types.DecryptMaterialsOutput DecryptMaterialsOutput(DecryptMaterialsOutput nativeValue) {
        DecryptionMaterials decryptionMaterials = ToDafny.DecryptionMaterials(nativeValue.decryptionMaterials());
        return new software.amazon.cryptography.materialproviders.internaldafny.types.DecryptMaterialsOutput(decryptionMaterials);
    }

    public static DefaultCache DefaultCache(software.amazon.cryptography.materialproviders.model.DefaultCache nativeValue) {
        Integer entryCapacity = nativeValue.entryCapacity();
        return new DefaultCache(entryCapacity);
    }

    public static DeleteCacheEntryInput DeleteCacheEntryInput(software.amazon.cryptography.materialproviders.model.DeleteCacheEntryInput nativeValue) {
        DafnySequence identifier = ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue.identifier());
        return new DeleteCacheEntryInput((DafnySequence<? extends Byte>)identifier);
    }

    public static DIRECT__KEY__WRAPPING DIRECT_KEY_WRAPPING(DIRECT_KEY_WRAPPING nativeValue) {
        return new DIRECT__KEY__WRAPPING();
    }

    public static DiscoveryFilter DiscoveryFilter(software.amazon.cryptography.materialproviders.model.DiscoveryFilter nativeValue) {
        DafnySequence<? extends DafnySequence<? extends Character>> accountIds = ToDafny.AccountIdList(nativeValue.accountIds());
        DafnySequence partition = ToDafny.Simple.CharacterSequence((String)nativeValue.partition());
        return new DiscoveryFilter(accountIds, (DafnySequence<? extends Character>)partition);
    }

    public static ECDSA ECDSA(software.amazon.cryptography.materialproviders.model.ECDSA nativeValue) {
        ECDSASignatureAlgorithm curve = software.amazon.cryptography.primitives.ToDafny.ECDSASignatureAlgorithm(nativeValue.curve());
        return new ECDSA(curve);
    }

    public static EncryptedDataKey EncryptedDataKey(software.amazon.cryptography.materialproviders.model.EncryptedDataKey nativeValue) {
        DafnySequence keyProviderId = ToDafny.Simple.DafnyUtf8Bytes((String)nativeValue.keyProviderId());
        DafnySequence keyProviderInfo = ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue.keyProviderInfo());
        DafnySequence ciphertext = ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue.ciphertext());
        return new EncryptedDataKey((DafnySequence<? extends Byte>)keyProviderId, (DafnySequence<? extends Byte>)keyProviderInfo, (DafnySequence<? extends Byte>)ciphertext);
    }

    public static software.amazon.cryptography.materialproviders.internaldafny.types.EncryptionMaterials EncryptionMaterials(EncryptionMaterials nativeValue) {
        software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteInfo algorithmSuite = ToDafny.AlgorithmSuiteInfo(nativeValue.algorithmSuite());
        DafnyMap<? extends DafnySequence<? extends Byte>, ? extends DafnySequence<? extends Byte>> encryptionContext = ToDafny.EncryptionContext(nativeValue.encryptionContext());
        DafnySequence<? extends EncryptedDataKey> encryptedDataKeys = ToDafny.EncryptedDataKeyList(nativeValue.encryptedDataKeys());
        DafnySequence<? extends DafnySequence<? extends Byte>> requiredEncryptionContextKeys = ToDafny.EncryptionContextKeys(nativeValue.requiredEncryptionContextKeys());
        Option<DafnySequence<? extends Byte>> plaintextDataKey = Objects.nonNull(nativeValue.plaintextDataKey()) ? Option.create_Some(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.BYTE), ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue.plaintextDataKey())) : Option.create_None(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.BYTE));
        Option<DafnySequence<? extends Byte>> signingKey = Objects.nonNull(nativeValue.signingKey()) ? Option.create_Some(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.BYTE), ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue.signingKey())) : Option.create_None(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.BYTE));
        Option<DafnySequence<? extends DafnySequence<? extends Byte>>> symmetricSigningKeys = Objects.nonNull(nativeValue.symmetricSigningKeys()) && nativeValue.symmetricSigningKeys().size() > 0 ? Option.create_Some(DafnySequence._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.BYTE)), ToDafny.SymmetricSigningKeyList(nativeValue.symmetricSigningKeys())) : Option.create_None(DafnySequence._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.BYTE)));
        return new software.amazon.cryptography.materialproviders.internaldafny.types.EncryptionMaterials(algorithmSuite, encryptionContext, encryptedDataKeys, requiredEncryptionContextKeys, plaintextDataKey, signingKey, symmetricSigningKeys);
    }

    public static EphemeralPrivateKeyToStaticPublicKeyInput EphemeralPrivateKeyToStaticPublicKeyInput(software.amazon.cryptography.materialproviders.model.EphemeralPrivateKeyToStaticPublicKeyInput nativeValue) {
        DafnySequence recipientPublicKey = ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue.recipientPublicKey());
        return new EphemeralPrivateKeyToStaticPublicKeyInput((DafnySequence<? extends Byte>)recipientPublicKey);
    }

    public static DafnySequence<? extends Byte> GetAlgorithmSuiteInfoInput(ByteBuffer nativeValue) {
        DafnySequence binaryId = ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue);
        return binaryId;
    }

    public static software.amazon.cryptography.materialproviders.internaldafny.types.GetBranchKeyIdInput GetBranchKeyIdInput(GetBranchKeyIdInput nativeValue) {
        DafnyMap<? extends DafnySequence<? extends Byte>, ? extends DafnySequence<? extends Byte>> encryptionContext = ToDafny.EncryptionContext(nativeValue.encryptionContext());
        return new software.amazon.cryptography.materialproviders.internaldafny.types.GetBranchKeyIdInput(encryptionContext);
    }

    public static GetBranchKeyIdOutput GetBranchKeyIdOutput(software.amazon.cryptography.materialproviders.model.GetBranchKeyIdOutput nativeValue) {
        DafnySequence branchKeyId = ToDafny.Simple.CharacterSequence((String)nativeValue.branchKeyId());
        return new GetBranchKeyIdOutput((DafnySequence<? extends Character>)branchKeyId);
    }

    public static GetCacheEntryInput GetCacheEntryInput(software.amazon.cryptography.materialproviders.model.GetCacheEntryInput nativeValue) {
        DafnySequence identifier = ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue.identifier());
        Option<Long> bytesUsed = Objects.nonNull(nativeValue.bytesUsed()) ? Option.create_Some(TypeDescriptor.LONG, nativeValue.bytesUsed()) : Option.create_None(TypeDescriptor.LONG);
        return new GetCacheEntryInput((DafnySequence<? extends Byte>)identifier, bytesUsed);
    }

    public static GetCacheEntryOutput GetCacheEntryOutput(software.amazon.cryptography.materialproviders.model.GetCacheEntryOutput nativeValue) {
        Materials materials = ToDafny.Materials(nativeValue.materials());
        Long creationTime = nativeValue.creationTime();
        Long expiryTime = nativeValue.expiryTime();
        Integer messagesUsed = nativeValue.messagesUsed();
        Integer bytesUsed = nativeValue.bytesUsed();
        return new GetCacheEntryOutput(materials, creationTime, expiryTime, messagesUsed, bytesUsed);
    }

    public static GetClientInput GetClientInput(software.amazon.cryptography.materialproviders.model.GetClientInput nativeValue) {
        DafnySequence region = ToDafny.Simple.CharacterSequence((String)nativeValue.region());
        return new GetClientInput((DafnySequence<? extends Character>)region);
    }

    public static GetEncryptionMaterialsInput GetEncryptionMaterialsInput(software.amazon.cryptography.materialproviders.model.GetEncryptionMaterialsInput nativeValue) {
        DafnyMap<? extends DafnySequence<? extends Byte>, ? extends DafnySequence<? extends Byte>> encryptionContext = ToDafny.EncryptionContext(nativeValue.encryptionContext());
        software.amazon.cryptography.materialproviders.internaldafny.types.CommitmentPolicy commitmentPolicy = ToDafny.CommitmentPolicy(nativeValue.commitmentPolicy());
        Option<AlgorithmSuiteId> algorithmSuiteId = Objects.nonNull(nativeValue.algorithmSuiteId()) ? Option.create_Some(AlgorithmSuiteId._typeDescriptor(), ToDafny.AlgorithmSuiteId(nativeValue.algorithmSuiteId())) : Option.create_None(AlgorithmSuiteId._typeDescriptor());
        Option<Long> maxPlaintextLength = Objects.nonNull(nativeValue.maxPlaintextLength()) ? Option.create_Some(TypeDescriptor.LONG, nativeValue.maxPlaintextLength()) : Option.create_None(TypeDescriptor.LONG);
        Option<DafnySequence<? extends DafnySequence<? extends Byte>>> requiredEncryptionContextKeys = Objects.nonNull(nativeValue.requiredEncryptionContextKeys()) && nativeValue.requiredEncryptionContextKeys().size() > 0 ? Option.create_Some(DafnySequence._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.BYTE)), ToDafny.EncryptionContextKeys(nativeValue.requiredEncryptionContextKeys())) : Option.create_None(DafnySequence._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.BYTE)));
        return new GetEncryptionMaterialsInput(encryptionContext, commitmentPolicy, algorithmSuiteId, maxPlaintextLength, requiredEncryptionContextKeys);
    }

    public static software.amazon.cryptography.materialproviders.internaldafny.types.GetEncryptionMaterialsOutput GetEncryptionMaterialsOutput(GetEncryptionMaterialsOutput nativeValue) {
        software.amazon.cryptography.materialproviders.internaldafny.types.EncryptionMaterials encryptionMaterials = ToDafny.EncryptionMaterials(nativeValue.encryptionMaterials());
        return new software.amazon.cryptography.materialproviders.internaldafny.types.GetEncryptionMaterialsOutput(encryptionMaterials);
    }

    public static HKDF HKDF(software.amazon.cryptography.materialproviders.model.HKDF nativeValue) {
        DigestAlgorithm hmac = software.amazon.cryptography.primitives.ToDafny.DigestAlgorithm(nativeValue.hmac());
        Integer saltLength = nativeValue.saltLength();
        Integer inputKeyLength = nativeValue.inputKeyLength();
        Integer outputKeyLength = nativeValue.outputKeyLength();
        return new HKDF(hmac, saltLength, inputKeyLength, outputKeyLength);
    }

    public static IDENTITY IDENTITY(software.amazon.cryptography.materialproviders.model.IDENTITY nativeValue) {
        return new IDENTITY();
    }

    public static InitializeDecryptionMaterialsInput InitializeDecryptionMaterialsInput(software.amazon.cryptography.materialproviders.model.InitializeDecryptionMaterialsInput nativeValue) {
        AlgorithmSuiteId algorithmSuiteId = ToDafny.AlgorithmSuiteId(nativeValue.algorithmSuiteId());
        DafnyMap<? extends DafnySequence<? extends Byte>, ? extends DafnySequence<? extends Byte>> encryptionContext = ToDafny.EncryptionContext(nativeValue.encryptionContext());
        DafnySequence<? extends DafnySequence<? extends Byte>> requiredEncryptionContextKeys = ToDafny.EncryptionContextKeys(nativeValue.requiredEncryptionContextKeys());
        return new InitializeDecryptionMaterialsInput(algorithmSuiteId, encryptionContext, requiredEncryptionContextKeys);
    }

    public static software.amazon.cryptography.materialproviders.internaldafny.types.InitializeEncryptionMaterialsInput InitializeEncryptionMaterialsInput(InitializeEncryptionMaterialsInput nativeValue) {
        AlgorithmSuiteId algorithmSuiteId = ToDafny.AlgorithmSuiteId(nativeValue.algorithmSuiteId());
        DafnyMap<? extends DafnySequence<? extends Byte>, ? extends DafnySequence<? extends Byte>> encryptionContext = ToDafny.EncryptionContext(nativeValue.encryptionContext());
        DafnySequence<? extends DafnySequence<? extends Byte>> requiredEncryptionContextKeys = ToDafny.EncryptionContextKeys(nativeValue.requiredEncryptionContextKeys());
        Option<DafnySequence<? extends Byte>> signingKey = Objects.nonNull(nativeValue.signingKey()) ? Option.create_Some(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.BYTE), ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue.signingKey())) : Option.create_None(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.BYTE));
        Option<DafnySequence<? extends Byte>> verificationKey = Objects.nonNull(nativeValue.verificationKey()) ? Option.create_Some(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.BYTE), ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue.verificationKey())) : Option.create_None(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.BYTE));
        return new software.amazon.cryptography.materialproviders.internaldafny.types.InitializeEncryptionMaterialsInput(algorithmSuiteId, encryptionContext, requiredEncryptionContextKeys, signingKey, verificationKey);
    }

    public static software.amazon.cryptography.materialproviders.internaldafny.types.IntermediateKeyWrapping IntermediateKeyWrapping(IntermediateKeyWrapping nativeValue) {
        software.amazon.cryptography.materialproviders.internaldafny.types.DerivationAlgorithm keyEncryptionKeyKdf = ToDafny.DerivationAlgorithm(nativeValue.keyEncryptionKeyKdf());
        software.amazon.cryptography.materialproviders.internaldafny.types.DerivationAlgorithm macKeyKdf = ToDafny.DerivationAlgorithm(nativeValue.macKeyKdf());
        Encrypt pdkEncryptAlgorithm = ToDafny.Encrypt(nativeValue.pdkEncryptAlgorithm());
        return new software.amazon.cryptography.materialproviders.internaldafny.types.IntermediateKeyWrapping(keyEncryptionKeyKdf, macKeyKdf, pdkEncryptAlgorithm);
    }

    public static software.amazon.cryptography.materialproviders.internaldafny.types.KmsPrivateKeyToStaticPublicKeyInput KmsPrivateKeyToStaticPublicKeyInput(KmsPrivateKeyToStaticPublicKeyInput nativeValue) {
        DafnySequence senderKmsIdentifier = ToDafny.Simple.CharacterSequence((String)nativeValue.senderKmsIdentifier());
        Option<DafnySequence<? extends Byte>> senderPublicKey = Objects.nonNull(nativeValue.senderPublicKey()) ? Option.create_Some(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.BYTE), ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue.senderPublicKey())) : Option.create_None(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.BYTE));
        DafnySequence recipientPublicKey = ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue.recipientPublicKey());
        return new software.amazon.cryptography.materialproviders.internaldafny.types.KmsPrivateKeyToStaticPublicKeyInput((DafnySequence<? extends Character>)senderKmsIdentifier, senderPublicKey, (DafnySequence<? extends Byte>)recipientPublicKey);
    }

    public static software.amazon.cryptography.materialproviders.internaldafny.types.KmsPublicKeyDiscoveryInput KmsPublicKeyDiscoveryInput(KmsPublicKeyDiscoveryInput nativeValue) {
        DafnySequence recipientKmsIdentifier = ToDafny.Simple.CharacterSequence((String)nativeValue.recipientKmsIdentifier());
        return new software.amazon.cryptography.materialproviders.internaldafny.types.KmsPublicKeyDiscoveryInput((DafnySequence<? extends Character>)recipientKmsIdentifier);
    }

    public static MaterialProvidersConfig MaterialProvidersConfig(software.amazon.cryptography.materialproviders.model.MaterialProvidersConfig nativeValue) {
        return new MaterialProvidersConfig();
    }

    public static software.amazon.cryptography.materialproviders.internaldafny.types.MultiThreadedCache MultiThreadedCache(MultiThreadedCache nativeValue) {
        Integer entryCapacity = nativeValue.entryCapacity();
        Option<Integer> entryPruningTailSize = Objects.nonNull(nativeValue.entryPruningTailSize()) ? Option.create_Some(TypeDescriptor.INT, nativeValue.entryPruningTailSize()) : Option.create_None(TypeDescriptor.INT);
        return new software.amazon.cryptography.materialproviders.internaldafny.types.MultiThreadedCache(entryCapacity, entryPruningTailSize);
    }

    public static NoCache NoCache(software.amazon.cryptography.materialproviders.model.NoCache nativeValue) {
        return new NoCache();
    }

    public static software.amazon.cryptography.materialproviders.internaldafny.types.None None(None nativeValue) {
        return new software.amazon.cryptography.materialproviders.internaldafny.types.None();
    }

    public static software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptInput OnDecryptInput(OnDecryptInput nativeValue) {
        DecryptionMaterials materials = ToDafny.DecryptionMaterials(nativeValue.materials());
        DafnySequence<? extends EncryptedDataKey> encryptedDataKeys = ToDafny.EncryptedDataKeyList(nativeValue.encryptedDataKeys());
        return new software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptInput(materials, encryptedDataKeys);
    }

    public static software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptOutput OnDecryptOutput(OnDecryptOutput nativeValue) {
        DecryptionMaterials materials = ToDafny.DecryptionMaterials(nativeValue.materials());
        return new software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptOutput(materials);
    }

    public static software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptInput OnEncryptInput(OnEncryptInput nativeValue) {
        software.amazon.cryptography.materialproviders.internaldafny.types.EncryptionMaterials materials = ToDafny.EncryptionMaterials(nativeValue.materials());
        return new software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptInput(materials);
    }

    public static OnEncryptOutput OnEncryptOutput(software.amazon.cryptography.materialproviders.model.OnEncryptOutput nativeValue) {
        software.amazon.cryptography.materialproviders.internaldafny.types.EncryptionMaterials materials = ToDafny.EncryptionMaterials(nativeValue.materials());
        return new OnEncryptOutput(materials);
    }

    public static software.amazon.cryptography.materialproviders.internaldafny.types.PublicKeyDiscoveryInput PublicKeyDiscoveryInput(PublicKeyDiscoveryInput nativeValue) {
        DafnySequence recipientStaticPrivateKey = ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue.recipientStaticPrivateKey());
        return new software.amazon.cryptography.materialproviders.internaldafny.types.PublicKeyDiscoveryInput((DafnySequence<? extends Byte>)recipientStaticPrivateKey);
    }

    public static software.amazon.cryptography.materialproviders.internaldafny.types.PutCacheEntryInput PutCacheEntryInput(PutCacheEntryInput nativeValue) {
        DafnySequence identifier = ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue.identifier());
        Materials materials = ToDafny.Materials(nativeValue.materials());
        Long creationTime = nativeValue.creationTime();
        Long expiryTime = nativeValue.expiryTime();
        Option<Integer> messagesUsed = Objects.nonNull(nativeValue.messagesUsed()) ? Option.create_Some(TypeDescriptor.INT, nativeValue.messagesUsed()) : Option.create_None(TypeDescriptor.INT);
        Option<Integer> bytesUsed = Objects.nonNull(nativeValue.bytesUsed()) ? Option.create_Some(TypeDescriptor.INT, nativeValue.bytesUsed()) : Option.create_None(TypeDescriptor.INT);
        return new software.amazon.cryptography.materialproviders.internaldafny.types.PutCacheEntryInput((DafnySequence<? extends Byte>)identifier, materials, creationTime, expiryTime, messagesUsed, bytesUsed);
    }

    public static RawPrivateKeyToStaticPublicKeyInput RawPrivateKeyToStaticPublicKeyInput(software.amazon.cryptography.materialproviders.model.RawPrivateKeyToStaticPublicKeyInput nativeValue) {
        DafnySequence senderStaticPrivateKey = ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue.senderStaticPrivateKey());
        DafnySequence recipientPublicKey = ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue.recipientPublicKey());
        return new RawPrivateKeyToStaticPublicKeyInput((DafnySequence<? extends Byte>)senderStaticPrivateKey, (DafnySequence<? extends Byte>)recipientPublicKey);
    }

    public static SingleThreadedCache SingleThreadedCache(software.amazon.cryptography.materialproviders.model.SingleThreadedCache nativeValue) {
        Integer entryCapacity = nativeValue.entryCapacity();
        Option<Integer> entryPruningTailSize = Objects.nonNull(nativeValue.entryPruningTailSize()) ? Option.create_Some(TypeDescriptor.INT, nativeValue.entryPruningTailSize()) : Option.create_None(TypeDescriptor.INT);
        return new SingleThreadedCache(entryCapacity, entryPruningTailSize);
    }

    public static StormTrackingCache StormTrackingCache(software.amazon.cryptography.materialproviders.model.StormTrackingCache nativeValue) {
        Integer entryCapacity = nativeValue.entryCapacity();
        Option<Integer> entryPruningTailSize = Objects.nonNull(nativeValue.entryPruningTailSize()) ? Option.create_Some(TypeDescriptor.INT, nativeValue.entryPruningTailSize()) : Option.create_None(TypeDescriptor.INT);
        Integer gracePeriod = nativeValue.gracePeriod();
        Integer graceInterval = nativeValue.graceInterval();
        Integer fanOut = nativeValue.fanOut();
        Integer inFlightTTL = nativeValue.inFlightTTL();
        Integer sleepMilli = nativeValue.sleepMilli();
        Option<TimeUnits> timeUnits = Objects.nonNull((Object)nativeValue.timeUnits()) ? Option.create_Some(TimeUnits._typeDescriptor(), ToDafny.TimeUnits(nativeValue.timeUnits())) : Option.create_None(TimeUnits._typeDescriptor());
        return new StormTrackingCache(entryCapacity, entryPruningTailSize, gracePeriod, graceInterval, fanOut, inFlightTTL, sleepMilli, timeUnits);
    }

    public static software.amazon.cryptography.materialproviders.internaldafny.types.UpdateUsageMetadataInput UpdateUsageMetadataInput(UpdateUsageMetadataInput nativeValue) {
        DafnySequence identifier = ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue.identifier());
        Integer bytesUsed = nativeValue.bytesUsed();
        return new software.amazon.cryptography.materialproviders.internaldafny.types.UpdateUsageMetadataInput((DafnySequence<? extends Byte>)identifier, bytesUsed);
    }

    public static ValidateCommitmentPolicyOnDecryptInput ValidateCommitmentPolicyOnDecryptInput(software.amazon.cryptography.materialproviders.model.ValidateCommitmentPolicyOnDecryptInput nativeValue) {
        AlgorithmSuiteId algorithm = ToDafny.AlgorithmSuiteId(nativeValue.algorithm());
        software.amazon.cryptography.materialproviders.internaldafny.types.CommitmentPolicy commitmentPolicy = ToDafny.CommitmentPolicy(nativeValue.commitmentPolicy());
        return new ValidateCommitmentPolicyOnDecryptInput(algorithm, commitmentPolicy);
    }

    public static ValidateCommitmentPolicyOnEncryptInput ValidateCommitmentPolicyOnEncryptInput(software.amazon.cryptography.materialproviders.model.ValidateCommitmentPolicyOnEncryptInput nativeValue) {
        AlgorithmSuiteId algorithm = ToDafny.AlgorithmSuiteId(nativeValue.algorithm());
        software.amazon.cryptography.materialproviders.internaldafny.types.CommitmentPolicy commitmentPolicy = ToDafny.CommitmentPolicy(nativeValue.commitmentPolicy());
        return new ValidateCommitmentPolicyOnEncryptInput(algorithm, commitmentPolicy);
    }

    public static software.amazon.cryptography.materialproviders.internaldafny.types.ValidDecryptionMaterialsTransitionInput ValidDecryptionMaterialsTransitionInput(ValidDecryptionMaterialsTransitionInput nativeValue) {
        DecryptionMaterials start = ToDafny.DecryptionMaterials(nativeValue.start());
        DecryptionMaterials stop = ToDafny.DecryptionMaterials(nativeValue.stop());
        return new software.amazon.cryptography.materialproviders.internaldafny.types.ValidDecryptionMaterialsTransitionInput(start, stop);
    }

    public static ValidEncryptionMaterialsTransitionInput ValidEncryptionMaterialsTransitionInput(software.amazon.cryptography.materialproviders.model.ValidEncryptionMaterialsTransitionInput nativeValue) {
        software.amazon.cryptography.materialproviders.internaldafny.types.EncryptionMaterials start = ToDafny.EncryptionMaterials(nativeValue.start());
        software.amazon.cryptography.materialproviders.internaldafny.types.EncryptionMaterials stop = ToDafny.EncryptionMaterials(nativeValue.stop());
        return new ValidEncryptionMaterialsTransitionInput(start, stop);
    }

    public static Error Error(AwsCryptographicMaterialProvidersException nativeValue) {
        DafnySequence message = ToDafny.Simple.CharacterSequence((String)nativeValue.message());
        return new Error_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)message);
    }

    public static Error Error(EntryAlreadyExists nativeValue) {
        DafnySequence message = ToDafny.Simple.CharacterSequence((String)nativeValue.message());
        return new Error_EntryAlreadyExists((DafnySequence<? extends Character>)message);
    }

    public static Error Error(EntryDoesNotExist nativeValue) {
        DafnySequence message = ToDafny.Simple.CharacterSequence((String)nativeValue.message());
        return new Error_EntryDoesNotExist((DafnySequence<? extends Character>)message);
    }

    public static Error Error(InFlightTTLExceeded nativeValue) {
        DafnySequence message = ToDafny.Simple.CharacterSequence((String)nativeValue.message());
        return new Error_InFlightTTLExceeded((DafnySequence<? extends Character>)message);
    }

    public static Error Error(InvalidAlgorithmSuiteInfo nativeValue) {
        DafnySequence message = ToDafny.Simple.CharacterSequence((String)nativeValue.message());
        return new Error_InvalidAlgorithmSuiteInfo((DafnySequence<? extends Character>)message);
    }

    public static Error Error(InvalidAlgorithmSuiteInfoOnDecrypt nativeValue) {
        DafnySequence message = ToDafny.Simple.CharacterSequence((String)nativeValue.message());
        return new Error_InvalidAlgorithmSuiteInfoOnDecrypt((DafnySequence<? extends Character>)message);
    }

    public static Error Error(InvalidAlgorithmSuiteInfoOnEncrypt nativeValue) {
        DafnySequence message = ToDafny.Simple.CharacterSequence((String)nativeValue.message());
        return new Error_InvalidAlgorithmSuiteInfoOnEncrypt((DafnySequence<? extends Character>)message);
    }

    public static Error Error(InvalidDecryptionMaterials nativeValue) {
        DafnySequence message = ToDafny.Simple.CharacterSequence((String)nativeValue.message());
        return new Error_InvalidDecryptionMaterials((DafnySequence<? extends Character>)message);
    }

    public static Error Error(InvalidDecryptionMaterialsTransition nativeValue) {
        DafnySequence message = ToDafny.Simple.CharacterSequence((String)nativeValue.message());
        return new Error_InvalidDecryptionMaterialsTransition((DafnySequence<? extends Character>)message);
    }

    public static Error Error(InvalidEncryptionMaterials nativeValue) {
        DafnySequence message = ToDafny.Simple.CharacterSequence((String)nativeValue.message());
        return new Error_InvalidEncryptionMaterials((DafnySequence<? extends Character>)message);
    }

    public static Error Error(InvalidEncryptionMaterialsTransition nativeValue) {
        DafnySequence message = ToDafny.Simple.CharacterSequence((String)nativeValue.message());
        return new Error_InvalidEncryptionMaterialsTransition((DafnySequence<? extends Character>)message);
    }

    public static software.amazon.cryptography.materialproviders.internaldafny.types.AesWrappingAlg AesWrappingAlg(AesWrappingAlg nativeValue) {
        switch (nativeValue) {
            case ALG_AES128_GCM_IV12_TAG16: {
                return software.amazon.cryptography.materialproviders.internaldafny.types.AesWrappingAlg.create_ALG__AES128__GCM__IV12__TAG16();
            }
            case ALG_AES192_GCM_IV12_TAG16: {
                return software.amazon.cryptography.materialproviders.internaldafny.types.AesWrappingAlg.create_ALG__AES192__GCM__IV12__TAG16();
            }
            case ALG_AES256_GCM_IV12_TAG16: {
                return software.amazon.cryptography.materialproviders.internaldafny.types.AesWrappingAlg.create_ALG__AES256__GCM__IV12__TAG16();
            }
        }
        throw new RuntimeException("Cannot convert " + (Object)((Object)nativeValue) + " to software.amazon.cryptography.materialproviders.internaldafny.types.AesWrappingAlg.");
    }

    public static software.amazon.cryptography.materialproviders.internaldafny.types.DBEAlgorithmSuiteId DBEAlgorithmSuiteId(DBEAlgorithmSuiteId nativeValue) {
        switch (nativeValue) {
            case ALG_AES_256_GCM_HKDF_SHA512_COMMIT_KEY_SYMSIG_HMAC_SHA384: {
                return software.amazon.cryptography.materialproviders.internaldafny.types.DBEAlgorithmSuiteId.create_ALG__AES__256__GCM__HKDF__SHA512__COMMIT__KEY__SYMSIG__HMAC__SHA384();
            }
            case ALG_AES_256_GCM_HKDF_SHA512_COMMIT_KEY_ECDSA_P384_SYMSIG_HMAC_SHA384: {
                return software.amazon.cryptography.materialproviders.internaldafny.types.DBEAlgorithmSuiteId.create_ALG__AES__256__GCM__HKDF__SHA512__COMMIT__KEY__ECDSA__P384__SYMSIG__HMAC__SHA384();
            }
        }
        throw new RuntimeException("Cannot convert " + (Object)((Object)nativeValue) + " to software.amazon.cryptography.materialproviders.internaldafny.types.DBEAlgorithmSuiteId.");
    }

    public static DBECommitmentPolicy DBECommitmentPolicy(software.amazon.cryptography.materialproviders.model.DBECommitmentPolicy nativeValue) {
        switch (nativeValue) {
            case REQUIRE_ENCRYPT_REQUIRE_DECRYPT: {
                return DBECommitmentPolicy.create();
            }
        }
        throw new RuntimeException("Cannot convert " + (Object)((Object)nativeValue) + " to software.amazon.cryptography.materialproviders.internaldafny.types.DBECommitmentPolicy.");
    }

    public static ESDKAlgorithmSuiteId ESDKAlgorithmSuiteId(software.amazon.cryptography.materialproviders.model.ESDKAlgorithmSuiteId nativeValue) {
        switch (nativeValue) {
            case ALG_AES_128_GCM_IV12_TAG16_NO_KDF: {
                return ESDKAlgorithmSuiteId.create_ALG__AES__128__GCM__IV12__TAG16__NO__KDF();
            }
            case ALG_AES_192_GCM_IV12_TAG16_NO_KDF: {
                return ESDKAlgorithmSuiteId.create_ALG__AES__192__GCM__IV12__TAG16__NO__KDF();
            }
            case ALG_AES_256_GCM_IV12_TAG16_NO_KDF: {
                return ESDKAlgorithmSuiteId.create_ALG__AES__256__GCM__IV12__TAG16__NO__KDF();
            }
            case ALG_AES_128_GCM_IV12_TAG16_HKDF_SHA256: {
                return ESDKAlgorithmSuiteId.create_ALG__AES__128__GCM__IV12__TAG16__HKDF__SHA256();
            }
            case ALG_AES_192_GCM_IV12_TAG16_HKDF_SHA256: {
                return ESDKAlgorithmSuiteId.create_ALG__AES__192__GCM__IV12__TAG16__HKDF__SHA256();
            }
            case ALG_AES_256_GCM_IV12_TAG16_HKDF_SHA256: {
                return ESDKAlgorithmSuiteId.create_ALG__AES__256__GCM__IV12__TAG16__HKDF__SHA256();
            }
            case ALG_AES_128_GCM_IV12_TAG16_HKDF_SHA256_ECDSA_P256: {
                return ESDKAlgorithmSuiteId.create_ALG__AES__128__GCM__IV12__TAG16__HKDF__SHA256__ECDSA__P256();
            }
            case ALG_AES_192_GCM_IV12_TAG16_HKDF_SHA384_ECDSA_P384: {
                return ESDKAlgorithmSuiteId.create_ALG__AES__192__GCM__IV12__TAG16__HKDF__SHA384__ECDSA__P384();
            }
            case ALG_AES_256_GCM_IV12_TAG16_HKDF_SHA384_ECDSA_P384: {
                return ESDKAlgorithmSuiteId.create_ALG__AES__256__GCM__IV12__TAG16__HKDF__SHA384__ECDSA__P384();
            }
            case ALG_AES_256_GCM_HKDF_SHA512_COMMIT_KEY: {
                return ESDKAlgorithmSuiteId.create_ALG__AES__256__GCM__HKDF__SHA512__COMMIT__KEY();
            }
            case ALG_AES_256_GCM_HKDF_SHA512_COMMIT_KEY_ECDSA_P384: {
                return ESDKAlgorithmSuiteId.create_ALG__AES__256__GCM__HKDF__SHA512__COMMIT__KEY__ECDSA__P384();
            }
        }
        throw new RuntimeException("Cannot convert " + (Object)((Object)nativeValue) + " to software.amazon.cryptography.materialproviders.internaldafny.types.ESDKAlgorithmSuiteId.");
    }

    public static ESDKCommitmentPolicy ESDKCommitmentPolicy(software.amazon.cryptography.materialproviders.model.ESDKCommitmentPolicy nativeValue) {
        switch (nativeValue) {
            case FORBID_ENCRYPT_ALLOW_DECRYPT: {
                return ESDKCommitmentPolicy.create_FORBID__ENCRYPT__ALLOW__DECRYPT();
            }
            case REQUIRE_ENCRYPT_ALLOW_DECRYPT: {
                return ESDKCommitmentPolicy.create_REQUIRE__ENCRYPT__ALLOW__DECRYPT();
            }
            case REQUIRE_ENCRYPT_REQUIRE_DECRYPT: {
                return ESDKCommitmentPolicy.create_REQUIRE__ENCRYPT__REQUIRE__DECRYPT();
            }
        }
        throw new RuntimeException("Cannot convert " + (Object)((Object)nativeValue) + " to software.amazon.cryptography.materialproviders.internaldafny.types.ESDKCommitmentPolicy.");
    }

    public static software.amazon.cryptography.materialproviders.internaldafny.types.PaddingScheme PaddingScheme(PaddingScheme nativeValue) {
        switch (nativeValue) {
            case PKCS1: {
                return software.amazon.cryptography.materialproviders.internaldafny.types.PaddingScheme.create_PKCS1();
            }
            case OAEP_SHA1_MGF1: {
                return software.amazon.cryptography.materialproviders.internaldafny.types.PaddingScheme.create_OAEP__SHA1__MGF1();
            }
            case OAEP_SHA256_MGF1: {
                return software.amazon.cryptography.materialproviders.internaldafny.types.PaddingScheme.create_OAEP__SHA256__MGF1();
            }
            case OAEP_SHA384_MGF1: {
                return software.amazon.cryptography.materialproviders.internaldafny.types.PaddingScheme.create_OAEP__SHA384__MGF1();
            }
            case OAEP_SHA512_MGF1: {
                return software.amazon.cryptography.materialproviders.internaldafny.types.PaddingScheme.create_OAEP__SHA512__MGF1();
            }
        }
        throw new RuntimeException("Cannot convert " + (Object)((Object)nativeValue) + " to software.amazon.cryptography.materialproviders.internaldafny.types.PaddingScheme.");
    }

    public static TimeUnits TimeUnits(software.amazon.cryptography.materialproviders.model.TimeUnits nativeValue) {
        switch (nativeValue) {
            case Seconds: {
                return TimeUnits.create_Seconds();
            }
            case Milliseconds: {
                return TimeUnits.create_Milliseconds();
            }
        }
        throw new RuntimeException("Cannot convert " + (Object)((Object)nativeValue) + " to software.amazon.cryptography.materialproviders.internaldafny.types.TimeUnits.");
    }

    public static AlgorithmSuiteId AlgorithmSuiteId(software.amazon.cryptography.materialproviders.model.AlgorithmSuiteId nativeValue) {
        if (Objects.nonNull((Object)nativeValue.ESDK())) {
            return AlgorithmSuiteId.create_ESDK(ToDafny.ESDKAlgorithmSuiteId(nativeValue.ESDK()));
        }
        if (Objects.nonNull((Object)nativeValue.DBE())) {
            return AlgorithmSuiteId.create_DBE(ToDafny.DBEAlgorithmSuiteId(nativeValue.DBE()));
        }
        throw new IllegalArgumentException("Cannot convert " + nativeValue + " to software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteId.");
    }

    public static CacheType CacheType(software.amazon.cryptography.materialproviders.model.CacheType nativeValue) {
        if (Objects.nonNull(nativeValue.Default())) {
            return CacheType.create_Default(ToDafny.DefaultCache(nativeValue.Default()));
        }
        if (Objects.nonNull(nativeValue.No())) {
            return CacheType.create_No(ToDafny.NoCache(nativeValue.No()));
        }
        if (Objects.nonNull(nativeValue.SingleThreaded())) {
            return CacheType.create_SingleThreaded(ToDafny.SingleThreadedCache(nativeValue.SingleThreaded()));
        }
        if (Objects.nonNull(nativeValue.MultiThreaded())) {
            return CacheType.create_MultiThreaded(ToDafny.MultiThreadedCache(nativeValue.MultiThreaded()));
        }
        if (Objects.nonNull(nativeValue.StormTracking())) {
            return CacheType.create_StormTracking(ToDafny.StormTrackingCache(nativeValue.StormTracking()));
        }
        if (Objects.nonNull(nativeValue.Shared())) {
            return CacheType.create_Shared(ToDafny.CryptographicMaterialsCache(nativeValue.Shared()));
        }
        throw new IllegalArgumentException("Cannot convert " + nativeValue + " to software.amazon.cryptography.materialproviders.internaldafny.types.CacheType.");
    }

    public static software.amazon.cryptography.materialproviders.internaldafny.types.CommitmentPolicy CommitmentPolicy(CommitmentPolicy nativeValue) {
        if (Objects.nonNull((Object)nativeValue.ESDK())) {
            return software.amazon.cryptography.materialproviders.internaldafny.types.CommitmentPolicy.create_ESDK(ToDafny.ESDKCommitmentPolicy(nativeValue.ESDK()));
        }
        if (Objects.nonNull((Object)nativeValue.DBE())) {
            return software.amazon.cryptography.materialproviders.internaldafny.types.CommitmentPolicy.create_DBE(ToDafny.DBECommitmentPolicy(nativeValue.DBE()));
        }
        throw new IllegalArgumentException("Cannot convert " + nativeValue + " to software.amazon.cryptography.materialproviders.internaldafny.types.CommitmentPolicy.");
    }

    public static software.amazon.cryptography.materialproviders.internaldafny.types.DerivationAlgorithm DerivationAlgorithm(DerivationAlgorithm nativeValue) {
        if (Objects.nonNull(nativeValue.HKDF())) {
            return software.amazon.cryptography.materialproviders.internaldafny.types.DerivationAlgorithm.create_HKDF(ToDafny.HKDF(nativeValue.HKDF()));
        }
        if (Objects.nonNull(nativeValue.IDENTITY())) {
            return software.amazon.cryptography.materialproviders.internaldafny.types.DerivationAlgorithm.create_IDENTITY(ToDafny.IDENTITY(nativeValue.IDENTITY()));
        }
        if (Objects.nonNull(nativeValue.None())) {
            return software.amazon.cryptography.materialproviders.internaldafny.types.DerivationAlgorithm.create_None(ToDafny.None(nativeValue.None()));
        }
        throw new IllegalArgumentException("Cannot convert " + nativeValue + " to software.amazon.cryptography.materialproviders.internaldafny.types.DerivationAlgorithm.");
    }

    public static EdkWrappingAlgorithm EdkWrappingAlgorithm(software.amazon.cryptography.materialproviders.model.EdkWrappingAlgorithm nativeValue) {
        if (Objects.nonNull(nativeValue.DIRECT_KEY_WRAPPING())) {
            return EdkWrappingAlgorithm.create_DIRECT__KEY__WRAPPING(ToDafny.DIRECT_KEY_WRAPPING(nativeValue.DIRECT_KEY_WRAPPING()));
        }
        if (Objects.nonNull(nativeValue.IntermediateKeyWrapping())) {
            return EdkWrappingAlgorithm.create_IntermediateKeyWrapping(ToDafny.IntermediateKeyWrapping(nativeValue.IntermediateKeyWrapping()));
        }
        throw new IllegalArgumentException("Cannot convert " + nativeValue + " to software.amazon.cryptography.materialproviders.internaldafny.types.EdkWrappingAlgorithm.");
    }

    public static Encrypt Encrypt(software.amazon.cryptography.materialproviders.model.Encrypt nativeValue) {
        if (Objects.nonNull(nativeValue.AES_GCM())) {
            return Encrypt.create(software.amazon.cryptography.primitives.ToDafny.AES_GCM(nativeValue.AES_GCM()));
        }
        throw new IllegalArgumentException("Cannot convert " + nativeValue + " to software.amazon.cryptography.materialproviders.internaldafny.types.Encrypt.");
    }

    public static KeyAgreementScheme KeyAgreementScheme(software.amazon.cryptography.materialproviders.model.KeyAgreementScheme nativeValue) {
        if (Objects.nonNull(nativeValue.StaticConfiguration())) {
            return KeyAgreementScheme.create(ToDafny.StaticConfigurations(nativeValue.StaticConfiguration()));
        }
        throw new IllegalArgumentException("Cannot convert " + nativeValue + " to software.amazon.cryptography.materialproviders.internaldafny.types.KeyAgreementScheme.");
    }

    public static KmsEcdhStaticConfigurations KmsEcdhStaticConfigurations(software.amazon.cryptography.materialproviders.model.KmsEcdhStaticConfigurations nativeValue) {
        if (Objects.nonNull(nativeValue.KmsPublicKeyDiscovery())) {
            return KmsEcdhStaticConfigurations.create_KmsPublicKeyDiscovery(ToDafny.KmsPublicKeyDiscoveryInput(nativeValue.KmsPublicKeyDiscovery()));
        }
        if (Objects.nonNull(nativeValue.KmsPrivateKeyToStaticPublicKey())) {
            return KmsEcdhStaticConfigurations.create_KmsPrivateKeyToStaticPublicKey(ToDafny.KmsPrivateKeyToStaticPublicKeyInput(nativeValue.KmsPrivateKeyToStaticPublicKey()));
        }
        throw new IllegalArgumentException("Cannot convert " + nativeValue + " to software.amazon.cryptography.materialproviders.internaldafny.types.KmsEcdhStaticConfigurations.");
    }

    public static Materials Materials(software.amazon.cryptography.materialproviders.model.Materials nativeValue) {
        if (Objects.nonNull(nativeValue.Encryption())) {
            return Materials.create_Encryption(ToDafny.EncryptionMaterials(nativeValue.Encryption()));
        }
        if (Objects.nonNull(nativeValue.Decryption())) {
            return Materials.create_Decryption(ToDafny.DecryptionMaterials(nativeValue.Decryption()));
        }
        if (Objects.nonNull(nativeValue.BranchKey())) {
            return Materials.create_BranchKey(software.amazon.cryptography.keystore.ToDafny.BranchKeyMaterials(nativeValue.BranchKey()));
        }
        if (Objects.nonNull(nativeValue.BeaconKey())) {
            return Materials.create_BeaconKey(software.amazon.cryptography.keystore.ToDafny.BeaconKeyMaterials(nativeValue.BeaconKey()));
        }
        throw new IllegalArgumentException("Cannot convert " + nativeValue + " to software.amazon.cryptography.materialproviders.internaldafny.types.Materials.");
    }

    public static RawEcdhStaticConfigurations RawEcdhStaticConfigurations(software.amazon.cryptography.materialproviders.model.RawEcdhStaticConfigurations nativeValue) {
        if (Objects.nonNull(nativeValue.PublicKeyDiscovery())) {
            return RawEcdhStaticConfigurations.create_PublicKeyDiscovery(ToDafny.PublicKeyDiscoveryInput(nativeValue.PublicKeyDiscovery()));
        }
        if (Objects.nonNull(nativeValue.RawPrivateKeyToStaticPublicKey())) {
            return RawEcdhStaticConfigurations.create_RawPrivateKeyToStaticPublicKey(ToDafny.RawPrivateKeyToStaticPublicKeyInput(nativeValue.RawPrivateKeyToStaticPublicKey()));
        }
        if (Objects.nonNull(nativeValue.EphemeralPrivateKeyToStaticPublicKey())) {
            return RawEcdhStaticConfigurations.create_EphemeralPrivateKeyToStaticPublicKey(ToDafny.EphemeralPrivateKeyToStaticPublicKeyInput(nativeValue.EphemeralPrivateKeyToStaticPublicKey()));
        }
        throw new IllegalArgumentException("Cannot convert " + nativeValue + " to software.amazon.cryptography.materialproviders.internaldafny.types.RawEcdhStaticConfigurations.");
    }

    public static SignatureAlgorithm SignatureAlgorithm(software.amazon.cryptography.materialproviders.model.SignatureAlgorithm nativeValue) {
        if (Objects.nonNull(nativeValue.ECDSA())) {
            return SignatureAlgorithm.create_ECDSA(ToDafny.ECDSA(nativeValue.ECDSA()));
        }
        if (Objects.nonNull(nativeValue.None())) {
            return SignatureAlgorithm.create_None(ToDafny.None(nativeValue.None()));
        }
        throw new IllegalArgumentException("Cannot convert " + nativeValue + " to software.amazon.cryptography.materialproviders.internaldafny.types.SignatureAlgorithm.");
    }

    public static software.amazon.cryptography.materialproviders.internaldafny.types.StaticConfigurations StaticConfigurations(StaticConfigurations nativeValue) {
        if (Objects.nonNull(nativeValue.AWS_KMS_ECDH())) {
            return software.amazon.cryptography.materialproviders.internaldafny.types.StaticConfigurations.create_AWS__KMS__ECDH(ToDafny.KmsEcdhStaticConfigurations(nativeValue.AWS_KMS_ECDH()));
        }
        if (Objects.nonNull(nativeValue.RAW_ECDH())) {
            return software.amazon.cryptography.materialproviders.internaldafny.types.StaticConfigurations.create_RAW__ECDH(ToDafny.RawEcdhStaticConfigurations(nativeValue.RAW_ECDH()));
        }
        throw new IllegalArgumentException("Cannot convert " + nativeValue + " to software.amazon.cryptography.materialproviders.internaldafny.types.StaticConfigurations.");
    }

    public static SymmetricSignatureAlgorithm SymmetricSignatureAlgorithm(software.amazon.cryptography.materialproviders.model.SymmetricSignatureAlgorithm nativeValue) {
        if (Objects.nonNull((Object)nativeValue.HMAC())) {
            return SymmetricSignatureAlgorithm.create_HMAC(software.amazon.cryptography.primitives.ToDafny.DigestAlgorithm(nativeValue.HMAC()));
        }
        if (Objects.nonNull(nativeValue.None())) {
            return SymmetricSignatureAlgorithm.create_None(ToDafny.None(nativeValue.None()));
        }
        throw new IllegalArgumentException("Cannot convert " + nativeValue + " to software.amazon.cryptography.materialproviders.internaldafny.types.SymmetricSignatureAlgorithm.");
    }

    public static DafnySequence<? extends DafnySequence<? extends Character>> AccountIdList(List<String> nativeValue) {
        return ToDafny.Aggregate.GenericToSequence(nativeValue, ToDafny.Simple::CharacterSequence, (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR));
    }

    public static DafnySequence<? extends EncryptedDataKey> EncryptedDataKeyList(List<software.amazon.cryptography.materialproviders.model.EncryptedDataKey> nativeValue) {
        return ToDafny.Aggregate.GenericToSequence(nativeValue, ToDafny::EncryptedDataKey, EncryptedDataKey._typeDescriptor());
    }

    public static DafnySequence<? extends DafnySequence<? extends Byte>> EncryptionContextKeys(List<String> nativeValue) {
        return ToDafny.Aggregate.GenericToSequence(nativeValue, ToDafny.Simple::DafnyUtf8Bytes, (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.BYTE));
    }

    public static DafnySequence<? extends DafnySequence<? extends Character>> GrantTokenList(List<String> nativeValue) {
        return ToDafny.Aggregate.GenericToSequence(nativeValue, ToDafny.Simple::CharacterSequence, (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR));
    }

    public static DafnySequence<? extends software.amazon.cryptography.materialproviders.internaldafny.types.IKeyring> KeyringList(List<IKeyring> nativeValue) {
        return ToDafny.Aggregate.GenericToSequence(nativeValue, ToDafny::Keyring, (TypeDescriptor)TypeDescriptor.reference(software.amazon.cryptography.materialproviders.internaldafny.types.IKeyring.class));
    }

    public static DafnySequence<? extends DafnySequence<? extends Character>> KmsKeyIdList(List<String> nativeValue) {
        return ToDafny.Aggregate.GenericToSequence(nativeValue, ToDafny.Simple::CharacterSequence, (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR));
    }

    public static DafnySequence<? extends DafnySequence<? extends Character>> RegionList(List<String> nativeValue) {
        return ToDafny.Aggregate.GenericToSequence(nativeValue, ToDafny.Simple::CharacterSequence, (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR));
    }

    public static DafnySequence<? extends DafnySequence<? extends Byte>> SymmetricSigningKeyList(List<ByteBuffer> nativeValue) {
        return ToDafny.Aggregate.GenericToSequence(nativeValue, ToDafny.Simple::ByteSequence, (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.BYTE));
    }

    public static DafnyMap<? extends DafnySequence<? extends Byte>, ? extends DafnySequence<? extends Byte>> EncryptionContext(Map<String, String> nativeValue) {
        return ToDafny.Aggregate.GenericToMap(nativeValue, ToDafny.Simple::DafnyUtf8Bytes, ToDafny.Simple::DafnyUtf8Bytes);
    }

    public static software.amazon.cryptography.materialproviders.internaldafny.types.IBranchKeyIdSupplier BranchKeyIdSupplier(IBranchKeyIdSupplier nativeValue) {
        return BranchKeyIdSupplier.wrap(nativeValue).impl();
    }

    public static IClientSupplier ClientSupplier(software.amazon.cryptography.materialproviders.IClientSupplier nativeValue) {
        return ClientSupplier.wrap(nativeValue).impl();
    }

    public static software.amazon.cryptography.materialproviders.internaldafny.types.ICryptographicMaterialsCache CryptographicMaterialsCache(ICryptographicMaterialsCache nativeValue) {
        return CryptographicMaterialsCache.wrap(nativeValue).impl();
    }

    public static ICryptographicMaterialsManager CryptographicMaterialsManager(software.amazon.cryptography.materialproviders.ICryptographicMaterialsManager nativeValue) {
        return CryptographicMaterialsManager.wrap(nativeValue).impl();
    }

    public static software.amazon.cryptography.materialproviders.internaldafny.types.IKeyring Keyring(IKeyring nativeValue) {
        return Keyring.wrap(nativeValue).impl();
    }

    public static IAwsCryptographicMaterialProvidersClient AwsCryptographicMaterialProviders(MaterialProviders nativeValue) {
        return nativeValue.impl();
    }
}

