/*
 * Decompiled with CFR 0.152.
 */
package AwsKmsEcdhKeyring_Compile;

import AwsArnParsing_Compile.AwsKmsIdentifierString;
import AwsKmsEcdhKeyring_Compile.DecryptSingleEncryptedDataKey;
import AwsKmsEcdhKeyring_Compile.OnDecryptEcdhDataKeyFilter;
import AwsKmsEcdhKeyring_Compile.__default;
import BoundedInts_Compile.uint8;
import EcdhEdkWrapping_Compile.EcdhGenerateAndWrapKeyMaterial;
import EcdhEdkWrapping_Compile.EcdhWrapInfo;
import EcdhEdkWrapping_Compile.EcdhWrapKeyMaterial;
import EdkWrapping_Compile.WrapEdkMaterialOutput;
import Keyring_Compile.VerifiableInterface;
import Materials_Compile.SealedDecryptionMaterials;
import UTF8.ValidUTF8Bytes;
import Wrappers_Compile.Option;
import Wrappers_Compile.Outcome;
import Wrappers_Compile.Result;
import dafny.DafnyMap;
import dafny.DafnySequence;
import dafny.TypeDescriptor;
import software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteInfo;
import software.amazon.cryptography.materialproviders.internaldafny.types.DecryptionMaterials;
import software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey;
import software.amazon.cryptography.materialproviders.internaldafny.types.EncryptionMaterials;
import software.amazon.cryptography.materialproviders.internaldafny.types.Error;
import software.amazon.cryptography.materialproviders.internaldafny.types.IKeyring;
import software.amazon.cryptography.materialproviders.internaldafny.types.KmsEcdhStaticConfigurations;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptOutput;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptOutput;
import software.amazon.cryptography.materialproviders.internaldafny.types._Companion_IKeyring;
import software.amazon.cryptography.primitives.internaldafny.AtomicPrimitivesClient;
import software.amazon.cryptography.primitives.internaldafny.types.ECDHCurveSpec;
import software.amazon.cryptography.services.kms.internaldafny.types.GrantTokenType;
import software.amazon.cryptography.services.kms.internaldafny.types.IKMSClient;
import software.amazon.cryptography.services.kms.internaldafny.types.PublicKeyType;

public class AwsKmsEcdhKeyring
implements VerifiableInterface,
IKeyring {
    public IKMSClient _client = null;
    public AtomicPrimitivesClient _cryptoPrimitives = null;
    public KmsEcdhStaticConfigurations _keyAgreementScheme = KmsEcdhStaticConfigurations.Default();
    public ECDHCurveSpec _curveSpec = ECDHCurveSpec.Default();
    public DafnySequence<? extends DafnySequence<? extends Character>> _grantTokens = DafnySequence.empty(GrantTokenType._typeDescriptor());
    public DafnySequence<? extends Byte> _recipientPublicKey = DafnySequence.empty(uint8._typeDescriptor());
    public Option<DafnySequence<? extends Byte>> _senderPublicKey = Option.Default(PublicKeyType._typeDescriptor());
    public Option<DafnySequence<? extends Byte>> _compressedSenderPublicKey = Option.Default(DafnySequence._typeDescriptor(uint8._typeDescriptor()));
    public DafnySequence<? extends Byte> _compressedRecipientPublicKey = DafnySequence.empty(uint8._typeDescriptor());
    public Option<DafnySequence<? extends Character>> _senderKmsKeyId = Option.Default(AwsKmsIdentifierString._typeDescriptor());
    private static final TypeDescriptor<AwsKmsEcdhKeyring> _TYPE = TypeDescriptor.referenceWithInitializer(AwsKmsEcdhKeyring.class, () -> null);

    @Override
    public Result<OnDecryptOutput, Error> OnDecrypt(OnDecryptInput input) {
        Result<OnDecryptOutput, Error> _out6 = _Companion_IKeyring.OnDecrypt(this, input);
        return _out6;
    }

    @Override
    public Result<OnEncryptOutput, Error> OnEncrypt(OnEncryptInput input) {
        Result<OnEncryptOutput, Error> _out6 = _Companion_IKeyring.OnEncrypt(this, input);
        return _out6;
    }

    public void __ctor(KmsEcdhStaticConfigurations KeyAgreementScheme2, ECDHCurveSpec curveSpec, IKMSClient client, DafnySequence<? extends DafnySequence<? extends Character>> grantTokens, Option<DafnySequence<? extends Character>> senderKmsKeyId, Option<DafnySequence<? extends Byte>> senderPublicKey, DafnySequence<? extends Byte> recipientPublicKey, Option<DafnySequence<? extends Byte>> compressedSenderPublicKey, DafnySequence<? extends Byte> compressedRecipientPublicKey, AtomicPrimitivesClient cryptoPrimitives) {
        this._keyAgreementScheme = KeyAgreementScheme2;
        this._curveSpec = curveSpec;
        this._client = client;
        this._grantTokens = grantTokens;
        this._recipientPublicKey = recipientPublicKey;
        this._senderPublicKey = senderPublicKey;
        this._compressedSenderPublicKey = compressedSenderPublicKey;
        this._compressedRecipientPublicKey = compressedRecipientPublicKey;
        this._senderKmsKeyId = senderKmsKeyId;
        this._cryptoPrimitives = cryptoPrimitives;
    }

    @Override
    public Result<OnEncryptOutput, Error> OnEncrypt_k(OnEncryptInput input) {
        Result<OnEncryptOutput, Error> res = null;
        Outcome<Error> _0_valueOrError0 = Outcome.Default(Error._typeDescriptor());
        _0_valueOrError0 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), !this.keyAgreementScheme().is_KmsPublicKeyDiscovery(), __default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"KmsPublicKeyDiscovery Key Agreement Scheme is forbidden on encrypt.")));
        if (_0_valueOrError0.IsFailure(Error._typeDescriptor())) {
            res = _0_valueOrError0.PropagateFailure(Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
            return res;
        }
        Outcome<Error> _1_valueOrError1 = Outcome.Default(Error._typeDescriptor());
        _1_valueOrError1 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), this.senderKmsKeyId().is_Some(), __default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Keyring MUST be configured with a sender KMS Key ID")));
        if (_1_valueOrError1.IsFailure(Error._typeDescriptor())) {
            res = _1_valueOrError1.PropagateFailure(Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
            return res;
        }
        Outcome<Error> _2_valueOrError2 = Outcome.Default(Error._typeDescriptor());
        _2_valueOrError2 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), this.senderPublicKey().is_Some(), __default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Keyring MUST be configured with a senderPublicKey")));
        if (_2_valueOrError2.IsFailure(Error._typeDescriptor())) {
            res = _2_valueOrError2.PropagateFailure(Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
            return res;
        }
        DafnySequence<? extends Character> _3_senderKmsKeyId = this.senderKmsKeyId().dtor_value();
        EncryptionMaterials _4_materials = input.dtor_materials();
        AlgorithmSuiteInfo _5_suite = input.dtor_materials().dtor_algorithmSuite();
        Result<DafnyMap, Error> _6_valueOrError3 = Result.Default(DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)), Error._typeDescriptor(), DafnyMap.empty());
        _6_valueOrError3 = AwsKmsUtils_Compile.__default.StringifyEncryptionContext(input.dtor_materials().dtor_encryptionContext());
        if (_6_valueOrError3.IsFailure((TypeDescriptor<DafnyMap>)DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)), Error._typeDescriptor())) {
            res = _6_valueOrError3.PropagateFailure((TypeDescriptor<DafnyMap>)DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)), Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
            return res;
        }
        DafnyMap _7_stringifiedEncCtx = _6_valueOrError3.Extract((TypeDescriptor<DafnyMap>)DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)), Error._typeDescriptor());
        Result<DafnySequence, Error> _8_valueOrError4 = Result.Default(DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor(), DafnySequence.empty(uint8._typeDescriptor()));
        Result<DafnySequence<? extends Byte>, Error> _out0 = __default.DeriveSharedSecret(this.client(), _3_senderKmsKeyId, this.recipientPublicKey(), this.grantTokens());
        _8_valueOrError4 = _out0;
        if (_8_valueOrError4.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor())) {
            res = _8_valueOrError4.PropagateFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
            return res;
        }
        DafnySequence _9_sharedSecret = _8_valueOrError4.Extract((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor());
        DafnySequence<? extends Byte> _10_operationCompressedSenderPublicKey = this.compressedSenderPublicKey().is_None() ? DafnySequence.empty(uint8._typeDescriptor()) : this.compressedSenderPublicKey().dtor_value();
        Result<DafnySequence<? extends Byte>, Error> _11_valueOrError5 = Result.Default(ValidUTF8Bytes._typeDescriptor(), Error._typeDescriptor(), ValidUTF8Bytes.defaultValue());
        _11_valueOrError5 = UTF8.__default.Encode(RawECDHKeyring_Compile.__default.CurveSpecTypeToString(this.curveSpec())).MapFailure(ValidUTF8Bytes._typeDescriptor(), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor(), AwsKmsUtils_Compile.__default::WrapStringToError);
        if (_11_valueOrError5.IsFailure(ValidUTF8Bytes._typeDescriptor(), Error._typeDescriptor())) {
            res = _11_valueOrError5.PropagateFailure(ValidUTF8Bytes._typeDescriptor(), Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
            return res;
        }
        DafnySequence<? extends Byte> _12_curveSpecUtf8 = _11_valueOrError5.Extract(ValidUTF8Bytes._typeDescriptor(), Error._typeDescriptor());
        Result<DafnySequence, Error> _13_valueOrError6 = Result.Default(DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor(), DafnySequence.empty(uint8._typeDescriptor()));
        _13_valueOrError6 = CanonicalEncryptionContext_Compile.__default.EncryptionContextToAAD(input.dtor_materials().dtor_encryptionContext());
        if (_13_valueOrError6.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor())) {
            res = _13_valueOrError6.PropagateFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
            return res;
        }
        DafnySequence _14_canonicalizedEC = _13_valueOrError6.Extract((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor());
        DafnySequence<? extends Byte> _15_fixedInfo = EcdhEdkWrapping_Compile.__default.SerializeFixedInfo(Constants_Compile.__default.ECDH__KDF__UTF8(), _12_curveSpecUtf8, _10_operationCompressedSenderPublicKey, this.compressedRecipientPublicKey(), (DafnySequence<? extends Byte>)_14_canonicalizedEC, __default.AWS__KMS__ECDH__KEYRING__VERSION());
        EcdhGenerateAndWrapKeyMaterial _nw0 = new EcdhGenerateAndWrapKeyMaterial();
        _nw0.__ctor((DafnySequence<? extends Byte>)_9_sharedSecret, _15_fixedInfo, this.cryptoPrimitives());
        EcdhGenerateAndWrapKeyMaterial _16_ecdhGenerateAndWrap = _nw0;
        EcdhWrapKeyMaterial _nw1 = new EcdhWrapKeyMaterial();
        _nw1.__ctor((DafnySequence<? extends Byte>)_9_sharedSecret, _15_fixedInfo, this.cryptoPrimitives());
        EcdhWrapKeyMaterial _17_ecdhWrap = _nw1;
        Result<WrapEdkMaterialOutput<EcdhWrapInfo>, Error> _18_valueOrError7 = Result.Default(WrapEdkMaterialOutput._typeDescriptor(EcdhWrapInfo._typeDescriptor()), Error._typeDescriptor(), WrapEdkMaterialOutput.Default(EcdhWrapInfo._typeDescriptor(), EcdhWrapInfo.Default()));
        Result<WrapEdkMaterialOutput<EcdhWrapInfo>, Error> _out1 = EdkWrapping_Compile.__default.WrapEdkMaterial(EcdhWrapInfo._typeDescriptor(), _4_materials, _17_ecdhWrap, _16_ecdhGenerateAndWrap);
        _18_valueOrError7 = _out1;
        if (_18_valueOrError7.IsFailure(WrapEdkMaterialOutput._typeDescriptor(EcdhWrapInfo._typeDescriptor()), Error._typeDescriptor())) {
            res = _18_valueOrError7.PropagateFailure(WrapEdkMaterialOutput._typeDescriptor(EcdhWrapInfo._typeDescriptor()), Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
            return res;
        }
        WrapEdkMaterialOutput<EcdhWrapInfo> _19_wrapOutput = _18_valueOrError7.Extract(WrapEdkMaterialOutput._typeDescriptor(EcdhWrapInfo._typeDescriptor()), Error._typeDescriptor());
        Option<Object> _20_symmetricSigningKeyList = _19_wrapOutput.dtor_symmetricSigningKey().is_Some() ? Option.create_Some(DafnySequence._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor(uint8._typeDescriptor())), DafnySequence.of((TypeDescriptor)DafnySequence._typeDescriptor(uint8._typeDescriptor()), (Object[])new DafnySequence[]{_19_wrapOutput.dtor_symmetricSigningKey().dtor_value()})) : Option.create_None(DafnySequence._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor(uint8._typeDescriptor())));
        Outcome<Error> _21_valueOrError8 = Outcome.Default(Error._typeDescriptor());
        _21_valueOrError8 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), RawECDHKeyring_Compile.__default.ValidCompressedPublicKeyLength(_10_operationCompressedSenderPublicKey) && RawECDHKeyring_Compile.__default.ValidCompressedPublicKeyLength(this.compressedRecipientPublicKey()), __default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Invalid compressed public key length.")));
        if (_21_valueOrError8.IsFailure(Error._typeDescriptor())) {
            res = _21_valueOrError8.PropagateFailure(Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
            return res;
        }
        EncryptedDataKey _22_edk = EncryptedDataKey.create(Constants_Compile.__default.KMS__ECDH__PROVIDER__ID(), RawECDHKeyring_Compile.__default.SerializeProviderInfo(_10_operationCompressedSenderPublicKey, this.compressedRecipientPublicKey()), _19_wrapOutput.dtor_wrappedMaterial());
        if (_19_wrapOutput.is_GenerateAndWrapEdkMaterialOutput()) {
            Result<EncryptionMaterials, Error> _23_valueOrError9 = null;
            _23_valueOrError9 = Materials_Compile.__default.EncryptionMaterialAddDataKey(_4_materials, _19_wrapOutput.dtor_plaintextDataKey(), (DafnySequence<? extends EncryptedDataKey>)DafnySequence.of(EncryptedDataKey._typeDescriptor(), (Object[])new EncryptedDataKey[]{_22_edk}), _20_symmetricSigningKeyList);
            if (_23_valueOrError9.IsFailure(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor())) {
                res = _23_valueOrError9.PropagateFailure(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
                return res;
            }
            EncryptionMaterials _24_result = _23_valueOrError9.Extract(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor());
            res = Result.create_Success(OnEncryptOutput._typeDescriptor(), Error._typeDescriptor(), OnEncryptOutput.create(_24_result));
            return res;
        }
        if (_19_wrapOutput.is_WrapOnlyEdkMaterialOutput()) {
            Result<EncryptionMaterials, Error> _25_valueOrError10 = null;
            _25_valueOrError10 = Materials_Compile.__default.EncryptionMaterialAddEncryptedDataKeys(_4_materials, (DafnySequence<? extends EncryptedDataKey>)DafnySequence.of(EncryptedDataKey._typeDescriptor(), (Object[])new EncryptedDataKey[]{_22_edk}), _20_symmetricSigningKeyList);
            if (_25_valueOrError10.IsFailure(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor())) {
                res = _25_valueOrError10.PropagateFailure(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
                return res;
            }
            EncryptionMaterials _26_result = _25_valueOrError10.Extract(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor());
            res = Result.create_Success(OnEncryptOutput._typeDescriptor(), Error._typeDescriptor(), OnEncryptOutput.create(_26_result));
            return res;
        }
        return res;
    }

    @Override
    public Result<OnDecryptOutput, Error> OnDecrypt_k(OnDecryptInput input) {
        Result<DecryptionMaterials, DafnySequence<Error>> _out1;
        Result<OnDecryptOutput, Error> res = null;
        DecryptionMaterials _0_materials = input.dtor_materials();
        AlgorithmSuiteInfo _1_suite = input.dtor_materials().dtor_algorithmSuite();
        Outcome<Error> _2_valueOrError0 = Outcome.Default(Error._typeDescriptor());
        _2_valueOrError0 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), Materials_Compile.__default.DecryptionMaterialsWithoutPlaintextDataKey(_0_materials), __default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Keyring received decryption materials that already contain a plaintext data key.")));
        if (_2_valueOrError0.IsFailure(Error._typeDescriptor())) {
            res = _2_valueOrError0.PropagateFailure(Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
            return res;
        }
        OnDecryptEcdhDataKeyFilter _nw0 = new OnDecryptEcdhDataKeyFilter();
        _nw0.__ctor(this.keyAgreementScheme(), this.compressedRecipientPublicKey(), this.compressedSenderPublicKey());
        OnDecryptEcdhDataKeyFilter _3_filter = _nw0;
        Result<DafnySequence, Error> _4_valueOrError1 = Result.Default(DafnySequence._typeDescriptor(EncryptedDataKey._typeDescriptor()), Error._typeDescriptor(), DafnySequence.empty(EncryptedDataKey._typeDescriptor()));
        Result<DafnySequence<? extends EncryptedDataKey>, Error> _out0 = Actions_Compile.__default.FilterWithResult(EncryptedDataKey._typeDescriptor(), Error._typeDescriptor(), _3_filter, input.dtor_encryptedDataKeys());
        _4_valueOrError1 = _out0;
        if (_4_valueOrError1.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(EncryptedDataKey._typeDescriptor()), Error._typeDescriptor())) {
            res = _4_valueOrError1.PropagateFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(EncryptedDataKey._typeDescriptor()), Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
            return res;
        }
        DafnySequence _5_edksToAttempt = _4_valueOrError1.Extract((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(EncryptedDataKey._typeDescriptor()), Error._typeDescriptor());
        if (!((long)_5_edksToAttempt.cardinalityInt() != 0L)) {
            Result<DafnySequence, Error> _6_valueOrError2 = Result.Default(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor(), DafnySequence.empty((TypeDescriptor)TypeDescriptor.CHAR));
            _6_valueOrError2 = ErrorMessages_Compile.__default.IncorrectDataKeys(input.dtor_encryptedDataKeys(), input.dtor_materials().dtor_algorithmSuite(), (DafnySequence<? extends Character>)DafnySequence.asString((String)""));
            if (_6_valueOrError2.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor())) {
                res = _6_valueOrError2.PropagateFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
                return res;
            }
            DafnySequence _7_errorMessage = _6_valueOrError2.Extract((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor());
            res = Result.create_Failure(OnDecryptOutput._typeDescriptor(), Error._typeDescriptor(), __default.E((DafnySequence<? extends Character>)_7_errorMessage));
            return res;
        }
        DecryptSingleEncryptedDataKey _nw1 = new DecryptSingleEncryptedDataKey();
        _nw1.__ctor(_0_materials, this.cryptoPrimitives(), this.compressedRecipientPublicKey(), this.client(), this.grantTokens(), this.keyAgreementScheme(), this.curveSpec());
        DecryptSingleEncryptedDataKey _8_decryptClosure = _nw1;
        Result<DecryptionMaterials, DafnySequence<Error>> _9_outcome = _out1 = Actions_Compile.__default.ReduceToSuccess(EncryptedDataKey._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor(), Error._typeDescriptor(), _8_decryptClosure, _5_edksToAttempt);
        Result<DecryptionMaterials, Error> _10_valueOrError3 = null;
        _10_valueOrError3 = _9_outcome.MapFailure(SealedDecryptionMaterials._typeDescriptor(), (TypeDescriptor<DafnySequence<Error>>)DafnySequence._typeDescriptor(Error._typeDescriptor()), Error._typeDescriptor(), _11_errors_boxed0 -> {
            DafnySequence _11_errors = _11_errors_boxed0;
            return Error.create_CollectionOfErrors((DafnySequence<? extends Error>)_11_errors, (DafnySequence<? extends Character>)DafnySequence.asString((String)"No Configured KMS Key was able to decrypt the Data Key. The list of encountered Exceptions is available via `list`."));
        });
        if (_10_valueOrError3.IsFailure(SealedDecryptionMaterials._typeDescriptor(), Error._typeDescriptor())) {
            res = _10_valueOrError3.PropagateFailure(SealedDecryptionMaterials._typeDescriptor(), Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
            return res;
        }
        DecryptionMaterials _12_SealedDecryptionMaterials = _10_valueOrError3.Extract(SealedDecryptionMaterials._typeDescriptor(), Error._typeDescriptor());
        res = Result.create_Success(OnDecryptOutput._typeDescriptor(), Error._typeDescriptor(), OnDecryptOutput.create(_12_SealedDecryptionMaterials));
        return res;
    }

    public IKMSClient client() {
        return this._client;
    }

    public AtomicPrimitivesClient cryptoPrimitives() {
        return this._cryptoPrimitives;
    }

    public KmsEcdhStaticConfigurations keyAgreementScheme() {
        return this._keyAgreementScheme;
    }

    public ECDHCurveSpec curveSpec() {
        return this._curveSpec;
    }

    public DafnySequence<? extends DafnySequence<? extends Character>> grantTokens() {
        return this._grantTokens;
    }

    public DafnySequence<? extends Byte> recipientPublicKey() {
        return this._recipientPublicKey;
    }

    public Option<DafnySequence<? extends Byte>> senderPublicKey() {
        return this._senderPublicKey;
    }

    public Option<DafnySequence<? extends Byte>> compressedSenderPublicKey() {
        return this._compressedSenderPublicKey;
    }

    public DafnySequence<? extends Byte> compressedRecipientPublicKey() {
        return this._compressedRecipientPublicKey;
    }

    public Option<DafnySequence<? extends Character>> senderKmsKeyId() {
        return this._senderKmsKeyId;
    }

    public static TypeDescriptor<AwsKmsEcdhKeyring> _typeDescriptor() {
        return _TYPE;
    }

    public String toString() {
        return "AwsKmsEcdhKeyring.AwsKmsEcdhKeyring";
    }
}

