/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.tools.cli.fips.truststore;

import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Scanner;
import org.opensearch.common.Randomness;
import org.opensearch.tools.cli.fips.truststore.CommonOptions;
import picocli.CommandLine;

public abstract class UserInteractionService {
    private static final Scanner CONSOLE_SCANNER = new Scanner(System.in, StandardCharsets.UTF_8);
    private static final String ALPHA_NUMERIC = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789!@#$%^&*";

    protected abstract Scanner getScanner();

    public static UserInteractionService getInstance() {
        return new UserInteractionService(){

            @Override
            protected Scanner getScanner() {
                return CONSOLE_SCANNER;
            }
        };
    }

    public boolean confirmAction(CommandLine.Model.CommandSpec spec, CommonOptions options, String message) {
        String response;
        PrintWriter out = spec.commandLine().getOut();
        if (options.nonInteractive) {
            out.println(message + " - Auto-confirmed (non-interactive mode)");
            return true;
        }
        out.print(message + " [y/N] ");
        out.flush();
        if (!this.getScanner().hasNextLine()) {
            UserInteractionService.throwNoInputException();
        }
        return (response = this.getScanner().nextLine().trim()).equalsIgnoreCase("yes") || response.equalsIgnoreCase("y");
    }

    public String promptForPasswordWithConfirmation(CommandLine.Model.CommandSpec spec, CommonOptions options, String message) {
        String confirmPassword;
        String password = this.promptForPassword(spec, message);
        if (!password.equals(confirmPassword = this.promptForPassword(spec, "Confirm " + message.toLowerCase(Locale.ROOT)))) {
            throw new RuntimeException("Passwords do not match. Operation cancelled.");
        }
        return password;
    }

    protected String promptForPassword(CommandLine.Model.CommandSpec spec, String message) {
        String password;
        PrintWriter out = spec.commandLine().getOut();
        CommandLine.Help.Ansi ansi = spec.commandLine().getColorScheme().ansi();
        out.print(ansi.string("@|yellow " + message + " (WARNING: will be visible): |@"));
        out.flush();
        if (!this.getScanner().hasNextLine()) {
            UserInteractionService.throwNoInputException();
        }
        if ((password = this.getScanner().nextLine().trim()).isEmpty()) {
            throw new RuntimeException("Password cannot be empty.");
        }
        return password;
    }

    public int promptForChoice(CommandLine.Model.CommandSpec spec, int choiceCount, int defaultChoice) {
        assert (choiceCount > 0) : "Choice count must be greater than 0.";
        assert (defaultChoice >= 1 && defaultChoice <= choiceCount) : "Default choice must be between 1 and " + choiceCount;
        PrintWriter out = spec.commandLine().getOut();
        Scanner scanner = this.getScanner();
        while (true) {
            String input;
            out.printf(Locale.ROOT, "Enter choice (1-%s) [%s]:  ", choiceCount, defaultChoice);
            out.flush();
            if (!scanner.hasNextLine()) {
                UserInteractionService.throwNoInputException();
            }
            if ((input = scanner.nextLine().trim()).isEmpty()) {
                return defaultChoice;
            }
            try {
                int choice = Integer.parseInt(input);
                if (choice >= 1 && choice <= choiceCount) {
                    return choice;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            out.println("Invalid choice.");
        }
    }

    public String generateSecurePassword() {
        StringBuilder password = new StringBuilder();
        for (int i = 0; i < 24; ++i) {
            password.append(ALPHA_NUMERIC.charAt(Randomness.createSecure().nextInt(ALPHA_NUMERIC.length())));
        }
        return password.toString();
    }

    private static void throwNoInputException() {
        throw new IllegalStateException("\nNo input available. Use the '--non-interactive option' to skip confirmations.");
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(CONSOLE_SCANNER::close));
    }
}

