/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.tools.cli.fips.truststore;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import org.opensearch.tools.cli.fips.truststore.CommonOptions;
import org.opensearch.tools.cli.fips.truststore.ConfigurationProperties;
import picocli.CommandLine;

public class CreateFipsTrustStore {
    private static final String JAVAX_NET_SSL_TRUST_STORE_PASSWORD = "javax.net.ssl.trustStorePassword";
    private static final String TRUST_STORE_PASSWORD = Security.getProperty("javax.net.ssl.trustStorePassword");
    private static final String JVM_DEFAULT_PASSWORD = Objects.requireNonNullElse(TRUST_STORE_PASSWORD, "changeit");
    private static final String BCFKS = "BCFKS";
    private static final String BCFIPS = "BCFIPS";
    private static final List<String> KNOWN_JDK_TRUSTSTORE_TYPES = List.of("PKCS12", "JKS");

    public static KeyStore loadJvmDefaultTrustStore(CommandLine.Model.CommandSpec spec, Path javaHome) {
        Path cacertsPath = javaHome.resolve("lib").resolve("security").resolve("cacerts");
        if (!Files.exists(cacertsPath, new LinkOption[0]) || !Files.isReadable(cacertsPath)) {
            throw new IllegalStateException("System cacerts not found at: " + String.valueOf(cacertsPath));
        }
        spec.commandLine().getOut().println("Loading system truststore from: " + String.valueOf(cacertsPath));
        KeyStore jvmKeyStore = null;
        for (String type : KNOWN_JDK_TRUSTSTORE_TYPES) {
            try {
                jvmKeyStore = KeyStore.getInstance(type);
                try (InputStream is = Files.newInputStream(cacertsPath, new OpenOption[0]);){
                    jvmKeyStore.load(is, JVM_DEFAULT_PASSWORD.toCharArray());
                }
                int certCount = jvmKeyStore.size();
                spec.commandLine().getOut().println("Loaded " + certCount + " certificates from system truststore");
                spec.commandLine().getOut().println("Successfully loaded cacerts as " + type + " format");
                break;
            }
            catch (Exception e) {
                jvmKeyStore = null;
            }
        }
        if (jvmKeyStore == null) {
            throw new IllegalStateException("Could not load system cacerts in any known format " + KNOWN_JDK_TRUSTSTORE_TYPES.stream().collect(Collectors.joining(", ", "[", "]")));
        }
        return jvmKeyStore;
    }

    static ConfigurationProperties configureBCFKSTrustStore(Path bcfksPath, String password) {
        return new ConfigurationProperties(bcfksPath.toAbsolutePath().toString(), BCFKS, password, BCFIPS);
    }

    public static Path convertToBCFKS(CommandLine.Model.CommandSpec spec, KeyStore sourceKeyStore, CommonOptions options, String password, Path confPath) {
        Path trustStorePath = confPath.resolve("opensearch-fips-truststore.bcfks");
        if (Files.exists(trustStorePath, new LinkOption[0])) {
            if (options.force) {
                try {
                    Files.delete(trustStorePath);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            } else {
                throw new RuntimeException("Operation cancelled. Trust store file already exists.");
            }
        }
        spec.commandLine().getOut().println("Converting to BCFKS format: " + String.valueOf(trustStorePath.toAbsolutePath()));
        int copiedCount = 0;
        try {
            KeyStore bcfksKeyStore = KeyStore.getInstance(BCFKS, BCFIPS);
            bcfksKeyStore.load(null, password.toCharArray());
            CreateFipsTrustStore.copyCerts(spec, sourceKeyStore, bcfksKeyStore, copiedCount);
            CreateFipsTrustStore.writeBCFKSKeyStoreToFile(bcfksKeyStore, trustStorePath, password);
            spec.commandLine().getOut().printf(Locale.ROOT, "Successfully converted %s/%s certificates to BCFKS format.%n", bcfksKeyStore.size(), sourceKeyStore.size());
            if (sourceKeyStore.size() > bcfksKeyStore.size()) {
                spec.commandLine().getOut().printf(Locale.ROOT, "%s certificates could not be converted to BCFKS format.%n", sourceKeyStore.size() - bcfksKeyStore.size());
            }
        }
        catch (IOException | GeneralSecurityException e) {
            throw new SecurityException(e);
        }
        return trustStorePath;
    }

    private static void copyCerts(CommandLine.Model.CommandSpec spec, KeyStore source, KeyStore target, int copiedCount) throws KeyStoreException {
        Enumeration<String> aliases = source.aliases();
        while (aliases.hasMoreElements()) {
            Certificate cert;
            String alias = aliases.nextElement();
            if (!source.isCertificateEntry(alias) || (cert = source.getCertificate(alias)) == null) continue;
            try {
                target.setCertificateEntry(alias, cert);
                ++copiedCount;
            }
            catch (Exception e) {
                spec.commandLine().getOut().printf(Locale.ROOT, "Failed to copy certificate '%s': %s%n", alias, e.getMessage());
            }
        }
    }

    private static void writeBCFKSKeyStoreToFile(KeyStore bcfksKeyStore, Path tempBcfksFile, String password) {
        try (OutputStream outputStream = Files.newOutputStream(tempBcfksFile, new OpenOption[0]);){
            bcfksKeyStore.store(outputStream, password.toCharArray());
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new IllegalStateException("Failed to write BCFKS keystore to [" + String.valueOf(tempBcfksFile) + "]: " + e.getMessage(), e);
        }
    }
}

