/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.auth.http.saml;

import java.io.File;
import java.nio.file.Path;
import net.shibboleth.shared.resolver.ResolverException;
import org.opensaml.saml.metadata.resolver.impl.FilesystemMetadataResolver;
import org.opensearch.common.settings.Settings;
import org.opensearch.env.Environment;
import org.opensearch.secure_sm.AccessController;

public class SamlFilesystemMetadataResolver
extends FilesystemMetadataResolver {
    SamlFilesystemMetadataResolver(String filePath, Settings opensearchSettings, Path configPath) throws Exception {
        super(SamlFilesystemMetadataResolver.getMetadataFile(filePath, opensearchSettings, configPath));
    }

    protected byte[] fetchMetadata() throws ResolverException {
        return (byte[])AccessController.doPrivilegedChecked(() -> SamlFilesystemMetadataResolver.super.fetchMetadata());
    }

    private static File getMetadataFile(String filePath, Settings settings, Path configPath) {
        Environment env = new Environment(settings, configPath);
        return env.configDir().resolve(filePath).toAbsolutePath().toFile();
    }
}

