/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.bcpg;

import org.bouncycastle.bcpg.AEADAlgorithmTags;
import org.bouncycastle.bcpg.SymmetricKeyUtils;

public class AEADUtils
implements AEADAlgorithmTags {
    private AEADUtils() {
    }

    public static int getIVLength(int aeadAlgorithmTag) {
        switch (aeadAlgorithmTag) {
            case 1: {
                return 16;
            }
            case 2: {
                return 15;
            }
            case 3: {
                return 12;
            }
        }
        throw new IllegalArgumentException("Invalid AEAD algorithm tag: " + aeadAlgorithmTag);
    }

    public static int getAuthTagLength(int aeadAlgorithmTag) {
        switch (aeadAlgorithmTag) {
            case 1: 
            case 2: 
            case 3: {
                return 16;
            }
        }
        throw new IllegalArgumentException("Invalid AEAD algorithm tag: " + aeadAlgorithmTag);
    }

    public static byte[][] splitMessageKeyAndIv(byte[] messageKeyAndIv, int cipherAlgo, int aeadAlgo) {
        int keyLen = SymmetricKeyUtils.getKeyLengthInOctets(cipherAlgo);
        int ivLen = AEADUtils.getIVLength(aeadAlgo);
        byte[] messageKey = new byte[keyLen];
        byte[] iv = new byte[ivLen];
        System.arraycopy(messageKeyAndIv, 0, messageKey, 0, messageKey.length);
        System.arraycopy(messageKeyAndIv, messageKey.length, iv, 0, ivLen - 8);
        return new byte[][]{messageKey, iv};
    }
}

