/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.primitives.model;

import java.util.Objects;
import software.amazon.cryptography.primitives.model.ECCPrivateKey;
import software.amazon.cryptography.primitives.model.ECDHCurveSpec;

public class GetPublicKeyFromPrivateKeyInput {
    private final ECDHCurveSpec eccCurve;
    private final ECCPrivateKey privateKey;

    protected GetPublicKeyFromPrivateKeyInput(BuilderImpl builder) {
        this.eccCurve = builder.eccCurve();
        this.privateKey = builder.privateKey();
    }

    public ECDHCurveSpec eccCurve() {
        return this.eccCurve;
    }

    public ECCPrivateKey privateKey() {
        return this.privateKey;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected ECDHCurveSpec eccCurve;
        protected ECCPrivateKey privateKey;

        protected BuilderImpl() {
        }

        protected BuilderImpl(GetPublicKeyFromPrivateKeyInput model) {
            this.eccCurve = model.eccCurve();
            this.privateKey = model.privateKey();
        }

        @Override
        public Builder eccCurve(ECDHCurveSpec eccCurve) {
            this.eccCurve = eccCurve;
            return this;
        }

        @Override
        public ECDHCurveSpec eccCurve() {
            return this.eccCurve;
        }

        @Override
        public Builder privateKey(ECCPrivateKey privateKey) {
            this.privateKey = privateKey;
            return this;
        }

        @Override
        public ECCPrivateKey privateKey() {
            return this.privateKey;
        }

        @Override
        public GetPublicKeyFromPrivateKeyInput build() {
            if (Objects.isNull((Object)this.eccCurve())) {
                throw new IllegalArgumentException("Missing value for required field `eccCurve`");
            }
            if (Objects.isNull(this.privateKey())) {
                throw new IllegalArgumentException("Missing value for required field `privateKey`");
            }
            return new GetPublicKeyFromPrivateKeyInput(this);
        }
    }

    public static interface Builder {
        public Builder eccCurve(ECDHCurveSpec var1);

        public ECDHCurveSpec eccCurve();

        public Builder privateKey(ECCPrivateKey var1);

        public ECCPrivateKey privateKey();

        public GetPublicKeyFromPrivateKeyInput build();
    }
}

