/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.dbencryptionsdk.structuredencryption.model;

import java.util.List;
import java.util.Objects;
import software.amazon.cryptography.dbencryptionsdk.structuredencryption.model.AuthenticateAction;
import software.amazon.cryptography.dbencryptionsdk.structuredencryption.model.PathSegment;
import software.amazon.cryptography.dbencryptionsdk.structuredencryption.model.StructuredDataTerminal;

public class AuthItem {
    private final List<PathSegment> key;
    private final StructuredDataTerminal data;
    private final AuthenticateAction action;

    protected AuthItem(BuilderImpl builder) {
        this.key = builder.key();
        this.data = builder.data();
        this.action = builder.action();
    }

    public List<PathSegment> key() {
        return this.key;
    }

    public StructuredDataTerminal data() {
        return this.data;
    }

    public AuthenticateAction action() {
        return this.action;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected List<PathSegment> key;
        protected StructuredDataTerminal data;
        protected AuthenticateAction action;

        protected BuilderImpl() {
        }

        protected BuilderImpl(AuthItem model) {
            this.key = model.key();
            this.data = model.data();
            this.action = model.action();
        }

        @Override
        public Builder key(List<PathSegment> key) {
            this.key = key;
            return this;
        }

        @Override
        public List<PathSegment> key() {
            return this.key;
        }

        @Override
        public Builder data(StructuredDataTerminal data) {
            this.data = data;
            return this;
        }

        @Override
        public StructuredDataTerminal data() {
            return this.data;
        }

        @Override
        public Builder action(AuthenticateAction action) {
            this.action = action;
            return this;
        }

        @Override
        public AuthenticateAction action() {
            return this.action;
        }

        @Override
        public AuthItem build() {
            if (Objects.isNull(this.key())) {
                throw new IllegalArgumentException("Missing value for required field `key`");
            }
            if (Objects.isNull(this.data())) {
                throw new IllegalArgumentException("Missing value for required field `data`");
            }
            if (Objects.isNull((Object)this.action())) {
                throw new IllegalArgumentException("Missing value for required field `action`");
            }
            return new AuthItem(this);
        }
    }

    public static interface Builder {
        public Builder key(List<PathSegment> var1);

        public List<PathSegment> key();

        public Builder data(StructuredDataTerminal var1);

        public StructuredDataTerminal data();

        public Builder action(AuthenticateAction var1);

        public AuthenticateAction action();

        public AuthItem build();
    }
}

