/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types;

import UTF8.ValidUTF8Bytes;
import Wrappers_Compile.Option;
import dafny.DafnyMap;
import dafny.DafnySequence;
import dafny.Helpers;
import dafny.TypeDescriptor;
import java.util.Objects;
import software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.CryptoItem;
import software.amazon.cryptography.materialproviders.internaldafny.types.DBEAlgorithmSuiteId;
import software.amazon.cryptography.materialproviders.internaldafny.types.ICryptographicMaterialsManager;

public class EncryptPathStructureInput {
    public DafnySequence<? extends Character> _tableName;
    public DafnySequence<? extends CryptoItem> _plaintextStructure;
    public ICryptographicMaterialsManager _cmm;
    public Option<DBEAlgorithmSuiteId> _algorithmSuiteId;
    public Option<DafnyMap<? extends DafnySequence<? extends Byte>, ? extends DafnySequence<? extends Byte>>> _encryptionContext;
    private static final TypeDescriptor<EncryptPathStructureInput> _TYPE = TypeDescriptor.referenceWithInitializer(EncryptPathStructureInput.class, () -> EncryptPathStructureInput.Default());
    private static final EncryptPathStructureInput theDefault = EncryptPathStructureInput.create((DafnySequence<? extends Character>)DafnySequence.empty((TypeDescriptor)TypeDescriptor.CHAR), (DafnySequence<? extends CryptoItem>)DafnySequence.empty(CryptoItem._typeDescriptor()), null, (Option<DBEAlgorithmSuiteId>)Option.Default((TypeDescriptor)DBEAlgorithmSuiteId._typeDescriptor()), (Option<DafnyMap<? extends DafnySequence<? extends Byte>, ? extends DafnySequence<? extends Byte>>>)Option.Default((TypeDescriptor)DafnyMap._typeDescriptor((TypeDescriptor)ValidUTF8Bytes._typeDescriptor(), (TypeDescriptor)ValidUTF8Bytes._typeDescriptor())));

    public EncryptPathStructureInput(DafnySequence<? extends Character> tableName, DafnySequence<? extends CryptoItem> plaintextStructure, ICryptographicMaterialsManager cmm, Option<DBEAlgorithmSuiteId> algorithmSuiteId, Option<DafnyMap<? extends DafnySequence<? extends Byte>, ? extends DafnySequence<? extends Byte>>> encryptionContext) {
        this._tableName = tableName;
        this._plaintextStructure = plaintextStructure;
        this._cmm = cmm;
        this._algorithmSuiteId = algorithmSuiteId;
        this._encryptionContext = encryptionContext;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        EncryptPathStructureInput o = (EncryptPathStructureInput)other;
        return Objects.equals(this._tableName, o._tableName) && Objects.equals(this._plaintextStructure, o._plaintextStructure) && this._cmm == o._cmm && Objects.equals(this._algorithmSuiteId, o._algorithmSuiteId) && Objects.equals(this._encryptionContext, o._encryptionContext);
    }

    public int hashCode() {
        long hash = 5381L;
        hash = (hash << 5) + hash + 0L;
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._tableName);
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._plaintextStructure);
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._cmm);
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._algorithmSuiteId);
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._encryptionContext);
        return (int)hash;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("AwsCryptographyDbEncryptionSdkStructuredEncryptionTypes.EncryptPathStructureInput.EncryptPathStructureInput");
        s.append("(");
        s.append(Helpers.toString(this._tableName));
        s.append(", ");
        s.append(Helpers.toString(this._plaintextStructure));
        s.append(", ");
        s.append(Helpers.toString((Object)this._cmm));
        s.append(", ");
        s.append(Helpers.toString(this._algorithmSuiteId));
        s.append(", ");
        s.append(Helpers.toString(this._encryptionContext));
        s.append(")");
        return s.toString();
    }

    public static TypeDescriptor<EncryptPathStructureInput> _typeDescriptor() {
        return _TYPE;
    }

    public static EncryptPathStructureInput Default() {
        return theDefault;
    }

    public static EncryptPathStructureInput create(DafnySequence<? extends Character> tableName, DafnySequence<? extends CryptoItem> plaintextStructure, ICryptographicMaterialsManager cmm, Option<DBEAlgorithmSuiteId> algorithmSuiteId, Option<DafnyMap<? extends DafnySequence<? extends Byte>, ? extends DafnySequence<? extends Byte>>> encryptionContext) {
        return new EncryptPathStructureInput(tableName, plaintextStructure, cmm, algorithmSuiteId, encryptionContext);
    }

    public static EncryptPathStructureInput create_EncryptPathStructureInput(DafnySequence<? extends Character> tableName, DafnySequence<? extends CryptoItem> plaintextStructure, ICryptographicMaterialsManager cmm, Option<DBEAlgorithmSuiteId> algorithmSuiteId, Option<DafnyMap<? extends DafnySequence<? extends Byte>, ? extends DafnySequence<? extends Byte>>> encryptionContext) {
        return EncryptPathStructureInput.create(tableName, plaintextStructure, cmm, algorithmSuiteId, encryptionContext);
    }

    public boolean is_EncryptPathStructureInput() {
        return true;
    }

    public DafnySequence<? extends Character> dtor_tableName() {
        return this._tableName;
    }

    public DafnySequence<? extends CryptoItem> dtor_plaintextStructure() {
        return this._plaintextStructure;
    }

    public ICryptographicMaterialsManager dtor_cmm() {
        return this._cmm;
    }

    public Option<DBEAlgorithmSuiteId> dtor_algorithmSuiteId() {
        return this._algorithmSuiteId;
    }

    public Option<DafnyMap<? extends DafnySequence<? extends Byte>, ? extends DafnySequence<? extends Byte>>> dtor_encryptionContext() {
        return this._encryptionContext;
    }
}

