/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.indices;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.ShardStatistics;
import org.opensearch.client.opensearch.indices.DataStreamStats;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class DataStreamsStatsResponse
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, DataStreamsStatsResponse> {
    private final int backingIndices;
    private final int dataStreamCount;
    @Nonnull
    private final List<DataStreamStats> dataStreams;
    @Nonnull
    private final ShardStatistics shards;
    @Nullable
    private final String totalStoreSize;
    private final long totalStoreSizeBytes;
    public static final JsonpDeserializer<DataStreamsStatsResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DataStreamsStatsResponse::setupDataStreamsStatsResponseDeserializer);

    private DataStreamsStatsResponse(Builder builder) {
        this.backingIndices = ApiTypeHelper.requireNonNull(builder.backingIndices, this, "backingIndices");
        this.dataStreamCount = ApiTypeHelper.requireNonNull(builder.dataStreamCount, this, "dataStreamCount");
        this.dataStreams = ApiTypeHelper.unmodifiableRequired(builder.dataStreams, (Object)this, "dataStreams");
        this.shards = ApiTypeHelper.requireNonNull(builder.shards, this, "shards");
        this.totalStoreSize = builder.totalStoreSize;
        this.totalStoreSizeBytes = ApiTypeHelper.requireNonNull(builder.totalStoreSizeBytes, this, "totalStoreSizeBytes");
    }

    public static DataStreamsStatsResponse of(Function<Builder, ObjectBuilder<DataStreamsStatsResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final int backingIndices() {
        return this.backingIndices;
    }

    public final int dataStreamCount() {
        return this.dataStreamCount;
    }

    @Nonnull
    public final List<DataStreamStats> dataStreams() {
        return this.dataStreams;
    }

    @Nonnull
    public final ShardStatistics shards() {
        return this.shards;
    }

    @Nullable
    public final String totalStoreSize() {
        return this.totalStoreSize;
    }

    public final long totalStoreSizeBytes() {
        return this.totalStoreSizeBytes;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("backing_indices");
        generator.write(this.backingIndices);
        generator.writeKey("data_stream_count");
        generator.write(this.dataStreamCount);
        generator.writeKey("data_streams");
        generator.writeStartArray();
        for (DataStreamStats item0 : this.dataStreams) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
        generator.writeKey("_shards");
        this.shards.serialize(generator, mapper);
        if (this.totalStoreSize != null) {
            generator.writeKey("total_store_size");
            generator.write(this.totalStoreSize);
        }
        generator.writeKey("total_store_size_bytes");
        generator.write(this.totalStoreSizeBytes);
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupDataStreamsStatsResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::backingIndices, JsonpDeserializer.integerDeserializer(), "backing_indices");
        op.add(Builder::dataStreamCount, JsonpDeserializer.integerDeserializer(), "data_stream_count");
        op.add(Builder::dataStreams, JsonpDeserializer.arrayDeserializer(DataStreamStats._DESERIALIZER), "data_streams");
        op.add(Builder::shards, ShardStatistics._DESERIALIZER, "_shards");
        op.add(Builder::totalStoreSize, JsonpDeserializer.stringDeserializer(), "total_store_size");
        op.add(Builder::totalStoreSizeBytes, JsonpDeserializer.longDeserializer(), "total_store_size_bytes");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Integer.hashCode(this.backingIndices);
        result = 31 * result + Integer.hashCode(this.dataStreamCount);
        result = 31 * result + this.dataStreams.hashCode();
        result = 31 * result + this.shards.hashCode();
        result = 31 * result + Objects.hashCode(this.totalStoreSize);
        result = 31 * result + Long.hashCode(this.totalStoreSizeBytes);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataStreamsStatsResponse other = (DataStreamsStatsResponse)o;
        return this.backingIndices == other.backingIndices && this.dataStreamCount == other.dataStreamCount && this.dataStreams.equals(other.dataStreams) && this.shards.equals(other.shards) && Objects.equals(this.totalStoreSize, other.totalStoreSize) && this.totalStoreSizeBytes == other.totalStoreSizeBytes;
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, DataStreamsStatsResponse> {
        private Integer backingIndices;
        private Integer dataStreamCount;
        private List<DataStreamStats> dataStreams;
        private ShardStatistics shards;
        @Nullable
        private String totalStoreSize;
        private Long totalStoreSizeBytes;

        public Builder() {
        }

        private Builder(DataStreamsStatsResponse o) {
            this.backingIndices = o.backingIndices;
            this.dataStreamCount = o.dataStreamCount;
            this.dataStreams = Builder._listCopy(o.dataStreams);
            this.shards = o.shards;
            this.totalStoreSize = o.totalStoreSize;
            this.totalStoreSizeBytes = o.totalStoreSizeBytes;
        }

        private Builder(Builder o) {
            this.backingIndices = o.backingIndices;
            this.dataStreamCount = o.dataStreamCount;
            this.dataStreams = Builder._listCopy(o.dataStreams);
            this.shards = o.shards;
            this.totalStoreSize = o.totalStoreSize;
            this.totalStoreSizeBytes = o.totalStoreSizeBytes;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder backingIndices(int value) {
            this.backingIndices = value;
            return this;
        }

        @Nonnull
        public final Builder dataStreamCount(int value) {
            this.dataStreamCount = value;
            return this;
        }

        @Nonnull
        public final Builder dataStreams(List<DataStreamStats> list) {
            this.dataStreams = Builder._listAddAll(this.dataStreams, list);
            return this;
        }

        @Nonnull
        public final Builder dataStreams(DataStreamStats value, DataStreamStats ... values) {
            this.dataStreams = Builder._listAdd(this.dataStreams, value, values);
            return this;
        }

        @Nonnull
        public final Builder dataStreams(Function<DataStreamStats.Builder, ObjectBuilder<DataStreamStats>> fn) {
            return this.dataStreams(fn.apply(new DataStreamStats.Builder()).build(), new DataStreamStats[0]);
        }

        @Nonnull
        public final Builder shards(ShardStatistics value) {
            this.shards = value;
            return this;
        }

        @Nonnull
        public final Builder shards(Function<ShardStatistics.Builder, ObjectBuilder<ShardStatistics>> fn) {
            return this.shards(fn.apply(new ShardStatistics.Builder()).build());
        }

        @Nonnull
        public final Builder totalStoreSize(@Nullable String value) {
            this.totalStoreSize = value;
            return this;
        }

        @Nonnull
        public final Builder totalStoreSizeBytes(long value) {
            this.totalStoreSizeBytes = value;
            return this;
        }

        @Override
        @Nonnull
        public DataStreamsStatsResponse build() {
            this._checkSingleUse();
            return new DataStreamsStatsResponse(this);
        }
    }
}

