/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.cat;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.opensearch._types.ErrorResponse;
import org.opensearch.client.opensearch._types.TimeUnit;
import org.opensearch.client.opensearch.cat.CatRequestBase;
import org.opensearch.client.opensearch.cat.TasksResponse;
import org.opensearch.client.transport.Endpoint;
import org.opensearch.client.transport.endpoints.SimpleEndpoint;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

public final class TasksRequest
extends CatRequestBase
implements ToCopyableBuilder<Builder, TasksRequest> {
    @Nonnull
    private final List<String> actions;
    @Nullable
    private final Boolean detailed;
    @Nonnull
    private final List<String> nodes;
    @Nullable
    private final String parentTaskId;
    @Nullable
    private final TimeUnit time;
    public static final Endpoint<TasksRequest, TasksResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<TasksRequest, TasksResponse>(request -> "GET", request -> "/_cat/tasks", request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        request.applyQueryParameters(params);
        return params;
    }, SimpleEndpoint.emptyMap(), false, TasksResponse._DESERIALIZER);

    private TasksRequest(Builder builder) {
        super(builder);
        this.actions = ApiTypeHelper.unmodifiable(builder.actions);
        this.detailed = builder.detailed;
        this.nodes = ApiTypeHelper.unmodifiable(builder.nodes);
        this.parentTaskId = builder.parentTaskId;
        this.time = builder.time;
    }

    public static TasksRequest of(Function<Builder, ObjectBuilder<TasksRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final List<String> actions() {
        return this.actions;
    }

    @Nullable
    public final Boolean detailed() {
        return this.detailed;
    }

    @Nonnull
    public final List<String> nodes() {
        return this.nodes;
    }

    @Nullable
    public final String parentTaskId() {
        return this.parentTaskId;
    }

    @Nullable
    public final TimeUnit time() {
        return this.time;
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    @Override
    protected void applyQueryParameters(@Nonnull Map<String, String> params) {
        super.applyQueryParameters(params);
        if (ApiTypeHelper.isDefined(this.actions)) {
            params.put("actions", String.join((CharSequence)",", this.actions));
        }
        if (this.detailed != null) {
            params.put("detailed", String.valueOf(this.detailed));
        }
        if (ApiTypeHelper.isDefined(this.nodes)) {
            params.put("nodes", String.join((CharSequence)",", this.nodes));
        }
        if (this.parentTaskId != null) {
            params.put("parent_task_id", this.parentTaskId);
        }
        if (this.time != null) {
            params.put("time", this.time.jsonValue());
        }
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.actions);
        result = 31 * result + Objects.hashCode(this.detailed);
        result = 31 * result + Objects.hashCode(this.nodes);
        result = 31 * result + Objects.hashCode(this.parentTaskId);
        result = 31 * result + Objects.hashCode(this.time);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TasksRequest other = (TasksRequest)o;
        return Objects.equals(this.actions, other.actions) && Objects.equals(this.detailed, other.detailed) && Objects.equals(this.nodes, other.nodes) && Objects.equals(this.parentTaskId, other.parentTaskId) && Objects.equals(this.time, other.time);
    }

    public static class Builder
    extends CatRequestBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, TasksRequest> {
        @Nullable
        private List<String> actions;
        @Nullable
        private Boolean detailed;
        @Nullable
        private List<String> nodes;
        @Nullable
        private String parentTaskId;
        @Nullable
        private TimeUnit time;

        public Builder() {
        }

        private Builder(TasksRequest o) {
            super(o);
            this.actions = Builder._listCopy(o.actions);
            this.detailed = o.detailed;
            this.nodes = Builder._listCopy(o.nodes);
            this.parentTaskId = o.parentTaskId;
            this.time = o.time;
        }

        private Builder(Builder o) {
            super(o);
            this.actions = Builder._listCopy(o.actions);
            this.detailed = o.detailed;
            this.nodes = Builder._listCopy(o.nodes);
            this.parentTaskId = o.parentTaskId;
            this.time = o.time;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder actions(List<String> list) {
            this.actions = Builder._listAddAll(this.actions, list);
            return this;
        }

        @Nonnull
        public final Builder actions(String value, String ... values) {
            this.actions = Builder._listAdd(this.actions, value, values);
            return this;
        }

        @Nonnull
        public final Builder detailed(@Nullable Boolean value) {
            this.detailed = value;
            return this;
        }

        @Nonnull
        public final Builder nodes(List<String> list) {
            this.nodes = Builder._listAddAll(this.nodes, list);
            return this;
        }

        @Nonnull
        public final Builder nodes(String value, String ... values) {
            this.nodes = Builder._listAdd(this.nodes, value, values);
            return this;
        }

        @Nonnull
        public final Builder parentTaskId(@Nullable String value) {
            this.parentTaskId = value;
            return this;
        }

        @Nonnull
        public final Builder time(@Nullable TimeUnit value) {
            this.time = value;
            return this;
        }

        @Override
        @Nonnull
        public TasksRequest build() {
            this._checkSingleUse();
            return new TasksRequest(this);
        }
    }
}

