/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.RemoteStoreUploadDownloadStats;
import org.opensearch.client.opensearch._types.RemoteStoreUploadPressureStats;
import org.opensearch.client.opensearch._types.RemoteStoreUploadRefreshSizeLagStats;
import org.opensearch.client.opensearch._types.Time;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class RemoteStoreUploadStats
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, RemoteStoreUploadStats> {
    @Nullable
    private final Time maxRefreshTimeLag;
    private final long maxRefreshTimeLagInMillis;
    @Nullable
    private final RemoteStoreUploadPressureStats pressure;
    @Nonnull
    private final RemoteStoreUploadRefreshSizeLagStats refreshSizeLag;
    @Nullable
    private final Time totalTimeSpent;
    private final long totalTimeSpentInMillis;
    @Nonnull
    private final RemoteStoreUploadDownloadStats totalUploadSize;
    public static final JsonpDeserializer<RemoteStoreUploadStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RemoteStoreUploadStats::setupRemoteStoreUploadStatsDeserializer);

    private RemoteStoreUploadStats(Builder builder) {
        this.maxRefreshTimeLag = builder.maxRefreshTimeLag;
        this.maxRefreshTimeLagInMillis = ApiTypeHelper.requireNonNull(builder.maxRefreshTimeLagInMillis, this, "maxRefreshTimeLagInMillis");
        this.pressure = builder.pressure;
        this.refreshSizeLag = ApiTypeHelper.requireNonNull(builder.refreshSizeLag, this, "refreshSizeLag");
        this.totalTimeSpent = builder.totalTimeSpent;
        this.totalTimeSpentInMillis = ApiTypeHelper.requireNonNull(builder.totalTimeSpentInMillis, this, "totalTimeSpentInMillis");
        this.totalUploadSize = ApiTypeHelper.requireNonNull(builder.totalUploadSize, this, "totalUploadSize");
    }

    public static RemoteStoreUploadStats of(Function<Builder, ObjectBuilder<RemoteStoreUploadStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Time maxRefreshTimeLag() {
        return this.maxRefreshTimeLag;
    }

    public final long maxRefreshTimeLagInMillis() {
        return this.maxRefreshTimeLagInMillis;
    }

    @Nullable
    public final RemoteStoreUploadPressureStats pressure() {
        return this.pressure;
    }

    @Nonnull
    public final RemoteStoreUploadRefreshSizeLagStats refreshSizeLag() {
        return this.refreshSizeLag;
    }

    @Nullable
    public final Time totalTimeSpent() {
        return this.totalTimeSpent;
    }

    public final long totalTimeSpentInMillis() {
        return this.totalTimeSpentInMillis;
    }

    @Nonnull
    public final RemoteStoreUploadDownloadStats totalUploadSize() {
        return this.totalUploadSize;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.maxRefreshTimeLag != null) {
            generator.writeKey("max_refresh_time_lag");
            this.maxRefreshTimeLag.serialize(generator, mapper);
        }
        generator.writeKey("max_refresh_time_lag_in_millis");
        generator.write(this.maxRefreshTimeLagInMillis);
        if (this.pressure != null) {
            generator.writeKey("pressure");
            this.pressure.serialize(generator, mapper);
        }
        generator.writeKey("refresh_size_lag");
        this.refreshSizeLag.serialize(generator, mapper);
        if (this.totalTimeSpent != null) {
            generator.writeKey("total_time_spent");
            this.totalTimeSpent.serialize(generator, mapper);
        }
        generator.writeKey("total_time_spent_in_millis");
        generator.write(this.totalTimeSpentInMillis);
        generator.writeKey("total_upload_size");
        this.totalUploadSize.serialize(generator, mapper);
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupRemoteStoreUploadStatsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::maxRefreshTimeLag, Time._DESERIALIZER, "max_refresh_time_lag");
        op.add(Builder::maxRefreshTimeLagInMillis, JsonpDeserializer.longDeserializer(), "max_refresh_time_lag_in_millis");
        op.add(Builder::pressure, RemoteStoreUploadPressureStats._DESERIALIZER, "pressure");
        op.add(Builder::refreshSizeLag, RemoteStoreUploadRefreshSizeLagStats._DESERIALIZER, "refresh_size_lag");
        op.add(Builder::totalTimeSpent, Time._DESERIALIZER, "total_time_spent");
        op.add(Builder::totalTimeSpentInMillis, JsonpDeserializer.longDeserializer(), "total_time_spent_in_millis");
        op.add(Builder::totalUploadSize, RemoteStoreUploadDownloadStats._DESERIALIZER, "total_upload_size");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.maxRefreshTimeLag);
        result = 31 * result + Long.hashCode(this.maxRefreshTimeLagInMillis);
        result = 31 * result + Objects.hashCode(this.pressure);
        result = 31 * result + this.refreshSizeLag.hashCode();
        result = 31 * result + Objects.hashCode(this.totalTimeSpent);
        result = 31 * result + Long.hashCode(this.totalTimeSpentInMillis);
        result = 31 * result + this.totalUploadSize.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RemoteStoreUploadStats other = (RemoteStoreUploadStats)o;
        return Objects.equals(this.maxRefreshTimeLag, other.maxRefreshTimeLag) && this.maxRefreshTimeLagInMillis == other.maxRefreshTimeLagInMillis && Objects.equals(this.pressure, other.pressure) && this.refreshSizeLag.equals(other.refreshSizeLag) && Objects.equals(this.totalTimeSpent, other.totalTimeSpent) && this.totalTimeSpentInMillis == other.totalTimeSpentInMillis && this.totalUploadSize.equals(other.totalUploadSize);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, RemoteStoreUploadStats> {
        @Nullable
        private Time maxRefreshTimeLag;
        private Long maxRefreshTimeLagInMillis;
        @Nullable
        private RemoteStoreUploadPressureStats pressure;
        private RemoteStoreUploadRefreshSizeLagStats refreshSizeLag;
        @Nullable
        private Time totalTimeSpent;
        private Long totalTimeSpentInMillis;
        private RemoteStoreUploadDownloadStats totalUploadSize;

        public Builder() {
        }

        private Builder(RemoteStoreUploadStats o) {
            this.maxRefreshTimeLag = o.maxRefreshTimeLag;
            this.maxRefreshTimeLagInMillis = o.maxRefreshTimeLagInMillis;
            this.pressure = o.pressure;
            this.refreshSizeLag = o.refreshSizeLag;
            this.totalTimeSpent = o.totalTimeSpent;
            this.totalTimeSpentInMillis = o.totalTimeSpentInMillis;
            this.totalUploadSize = o.totalUploadSize;
        }

        private Builder(Builder o) {
            this.maxRefreshTimeLag = o.maxRefreshTimeLag;
            this.maxRefreshTimeLagInMillis = o.maxRefreshTimeLagInMillis;
            this.pressure = o.pressure;
            this.refreshSizeLag = o.refreshSizeLag;
            this.totalTimeSpent = o.totalTimeSpent;
            this.totalTimeSpentInMillis = o.totalTimeSpentInMillis;
            this.totalUploadSize = o.totalUploadSize;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder maxRefreshTimeLag(@Nullable Time value) {
            this.maxRefreshTimeLag = value;
            return this;
        }

        @Nonnull
        public final Builder maxRefreshTimeLag(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.maxRefreshTimeLag(fn.apply(new Time.Builder()).build());
        }

        @Nonnull
        public final Builder maxRefreshTimeLagInMillis(long value) {
            this.maxRefreshTimeLagInMillis = value;
            return this;
        }

        @Nonnull
        public final Builder pressure(@Nullable RemoteStoreUploadPressureStats value) {
            this.pressure = value;
            return this;
        }

        @Nonnull
        public final Builder pressure(Function<RemoteStoreUploadPressureStats.Builder, ObjectBuilder<RemoteStoreUploadPressureStats>> fn) {
            return this.pressure(fn.apply(new RemoteStoreUploadPressureStats.Builder()).build());
        }

        @Nonnull
        public final Builder refreshSizeLag(RemoteStoreUploadRefreshSizeLagStats value) {
            this.refreshSizeLag = value;
            return this;
        }

        @Nonnull
        public final Builder refreshSizeLag(Function<RemoteStoreUploadRefreshSizeLagStats.Builder, ObjectBuilder<RemoteStoreUploadRefreshSizeLagStats>> fn) {
            return this.refreshSizeLag(fn.apply(new RemoteStoreUploadRefreshSizeLagStats.Builder()).build());
        }

        @Nonnull
        public final Builder totalTimeSpent(@Nullable Time value) {
            this.totalTimeSpent = value;
            return this;
        }

        @Nonnull
        public final Builder totalTimeSpent(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.totalTimeSpent(fn.apply(new Time.Builder()).build());
        }

        @Nonnull
        public final Builder totalTimeSpentInMillis(long value) {
            this.totalTimeSpentInMillis = value;
            return this;
        }

        @Nonnull
        public final Builder totalUploadSize(RemoteStoreUploadDownloadStats value) {
            this.totalUploadSize = value;
            return this;
        }

        @Nonnull
        public final Builder totalUploadSize(Function<RemoteStoreUploadDownloadStats.Builder, ObjectBuilder<RemoteStoreUploadDownloadStats>> fn) {
            return this.totalUploadSize(fn.apply(new RemoteStoreUploadDownloadStats.Builder()).build());
        }

        @Override
        @Nonnull
        public RemoteStoreUploadStats build() {
            this._checkSingleUse();
            return new RemoteStoreUploadStats(this);
        }
    }
}

