/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.internal;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.codecs.StoredFieldsReader;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TotalHits;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.common.lease.Releasable;
import org.opensearch.search.Scroll;

@PublicApi(since="1.0.0")
public final class ScrollContext
implements Releasable {
    public TotalHits totalHits = null;
    public float maxScore = Float.NaN;
    public ScoreDoc lastEmittedDoc;
    public Scroll scroll;
    private Map<Object, StoredFieldsReader> sequentialReaderCache;

    public StoredFieldsReader getCachedSequentialReader(Object segmentKey) {
        return this.sequentialReaderCache != null ? this.sequentialReaderCache.get(segmentKey) : null;
    }

    public void cacheSequentialReader(Object segmentKey, StoredFieldsReader reader) {
        if (this.sequentialReaderCache == null) {
            this.sequentialReaderCache = new HashMap<Object, StoredFieldsReader>();
        }
        this.sequentialReaderCache.put(segmentKey, reader);
    }

    public void close() {
        if (this.sequentialReaderCache != null) {
            for (StoredFieldsReader reader : this.sequentialReaderCache.values()) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
            this.sequentialReaderCache = null;
        }
    }
}

