/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.cluster.filecache;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.opensearch.action.FailedNodeException;
import org.opensearch.action.admin.cluster.filecache.NodePruneFileCacheResponse;
import org.opensearch.action.support.nodes.BaseNodesResponse;
import org.opensearch.cluster.ClusterName;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;

public class PruneFileCacheResponse
extends BaseNodesResponse<NodePruneFileCacheResponse>
implements ToXContentObject {
    public PruneFileCacheResponse(StreamInput in) throws IOException {
        super(in);
    }

    public PruneFileCacheResponse(ClusterName clusterName, List<NodePruneFileCacheResponse> nodes, List<FailedNodeException> failures) {
        super(clusterName, nodes, failures);
    }

    @Override
    protected List<NodePruneFileCacheResponse> readNodesFrom(StreamInput in) throws IOException {
        return in.readList(NodePruneFileCacheResponse::new);
    }

    @Override
    protected void writeNodesTo(StreamOutput out, List<NodePruneFileCacheResponse> nodes) throws IOException {
        out.writeList(nodes);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("acknowledged", true);
        long totalPrunedBytes = this.getTotalPrunedBytes();
        builder.field("total_pruned_bytes", totalPrunedBytes);
        long totalCacheCapacity = 0L;
        builder.startObject("summary");
        builder.field("total_nodes_targeted", this.getNodes().size() + this.failures().size());
        builder.field("successful_nodes", this.getNodes().size());
        builder.field("failed_nodes", this.failures().size());
        for (NodePruneFileCacheResponse nodeResponse : this.getNodes()) {
            if (nodeResponse == null) continue;
            totalCacheCapacity += nodeResponse.getCacheCapacity();
        }
        builder.field("total_cache_capacity", totalCacheCapacity);
        builder.endObject();
        builder.startObject("nodes");
        for (NodePruneFileCacheResponse nodeResponse : this.getNodes()) {
            if (nodeResponse == null || nodeResponse.getNode() == null) continue;
            builder.startObject(nodeResponse.getNode().getId());
            nodeResponse.toXContent(builder, params);
            builder.endObject();
        }
        builder.endObject();
        if (!this.failures().isEmpty()) {
            builder.startArray("failures");
            for (FailedNodeException failure : this.failures()) {
                builder.startObject();
                builder.field("node_id", failure.nodeId());
                builder.field("reason", failure.getDetailedMessage());
                builder.field("caused_by", failure.getCause() != null ? failure.getCause().getClass().getSimpleName() : null);
                builder.endObject();
            }
            builder.endArray();
        }
        builder.endObject();
        return builder;
    }

    public long getTotalPrunedBytes() {
        return this.getNodes().stream().filter(Objects::nonNull).mapToLong(NodePruneFileCacheResponse::getPrunedBytes).sum();
    }

    public boolean isPartiallySuccessful() {
        return !this.getNodes().isEmpty() && !this.failures().isEmpty();
    }

    public boolean isCompletelySuccessful() {
        return !this.getNodes().isEmpty() && this.failures().isEmpty();
    }

    public boolean isAcknowledged() {
        return true;
    }

    public long getPrunedBytes() {
        return this.getTotalPrunedBytes();
    }
}

