/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.correlation.alert;

import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import org.opensearch.commons.alerting.model.ActionExecutionResult;
import org.opensearch.commons.alerting.model.Alert;
import org.opensearch.commons.alerting.model.CorrelationAlert;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;

public class CorrelationAlertsList {
    private final List<CorrelationAlert> correlationAlertList;
    private final Integer totalAlerts;

    public CorrelationAlertsList(List<CorrelationAlert> correlationAlertList, Integer totalAlerts) {
        this.correlationAlertList = correlationAlertList;
        this.totalAlerts = totalAlerts;
    }

    public static CorrelationAlert parse(XContentParser xcp, String id, long version) throws IOException {
        ArrayList<String> correlatedFindingIds = new ArrayList<String>();
        String correlationRuleId = null;
        String correlationRuleName = null;
        User user = null;
        int schemaVersion = 0;
        String triggerName = null;
        Alert.State state = null;
        String errorMessage = null;
        String severity = null;
        ArrayList<ActionExecutionResult> actionExecutionResults = new ArrayList<ActionExecutionResult>();
        Instant startTime = null;
        Instant endTime = null;
        Instant acknowledgedTime = null;
        while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = xcp.currentName();
            xcp.nextToken();
            switch (fieldName) {
                case "correlated_finding_ids": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
                    while (xcp.nextToken() != XContentParser.Token.END_ARRAY) {
                        correlatedFindingIds.add(xcp.text());
                    }
                    break;
                }
                case "correlation_rule_id": {
                    correlationRuleId = xcp.text();
                    break;
                }
                case "correlation_rule_name": {
                    correlationRuleName = xcp.text();
                    break;
                }
                case "user": {
                    user = xcp.currentToken() == XContentParser.Token.VALUE_NULL ? null : User.parse((XContentParser)xcp);
                    break;
                }
                case "id": {
                    id = xcp.text();
                    break;
                }
                case "version": {
                    version = xcp.longValue();
                    break;
                }
                case "schema_version": {
                    schemaVersion = xcp.intValue();
                    break;
                }
                case "trigger_name": {
                    triggerName = xcp.text();
                    break;
                }
                case "state": {
                    state = Alert.State.valueOf((String)xcp.text());
                    break;
                }
                case "error_message": {
                    errorMessage = xcp.textOrNull();
                    break;
                }
                case "severity": {
                    severity = xcp.text();
                    break;
                }
                case "action_execution_results": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
                    while (xcp.nextToken() != XContentParser.Token.END_ARRAY) {
                        actionExecutionResults.add(ActionExecutionResult.parse((XContentParser)xcp));
                    }
                    break;
                }
                case "start_time": {
                    startTime = Instant.parse(xcp.text());
                    break;
                }
                case "end_time": {
                    endTime = Instant.parse(xcp.text());
                    break;
                }
                case "acknowledged_time": {
                    acknowledgedTime = xcp.currentToken() == XContentParser.Token.VALUE_NULL ? null : Instant.parse(xcp.text());
                }
            }
        }
        return new CorrelationAlert(correlatedFindingIds, correlationRuleId, correlationRuleName, id, version, schemaVersion, user, triggerName, state, startTime, endTime, acknowledgedTime, errorMessage, severity, actionExecutionResults);
    }

    public List<CorrelationAlert> getCorrelationAlertList() {
        return this.correlationAlertList;
    }

    public Integer getTotalAlerts() {
        return this.totalAlerts;
    }
}

