/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.nodes;

import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch.nodes.NodesResponseBase;
import org.opensearch.client.opensearch.nodes.usage.NodeUsage;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class NodesUsageResponse
extends NodesResponseBase
implements ToCopyableBuilder<Builder, NodesUsageResponse> {
    @Nonnull
    private final String clusterName;
    @Nonnull
    private final Map<String, NodeUsage> nodes;
    public static final JsonpDeserializer<NodesUsageResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, NodesUsageResponse::setupNodesUsageResponseDeserializer);

    private NodesUsageResponse(Builder builder) {
        super(builder);
        this.clusterName = ApiTypeHelper.requireNonNull(builder.clusterName, this, "clusterName");
        this.nodes = ApiTypeHelper.unmodifiableRequired(builder.nodes, (Object)this, "nodes");
    }

    public static NodesUsageResponse of(Function<Builder, ObjectBuilder<NodesUsageResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final String clusterName() {
        return this.clusterName;
    }

    @Nonnull
    public final Map<String, NodeUsage> nodes() {
        return this.nodes;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("cluster_name");
        generator.write(this.clusterName);
        generator.writeKey("nodes");
        generator.writeStartObject();
        for (Map.Entry<String, NodeUsage> item0 : this.nodes.entrySet()) {
            generator.writeKey(item0.getKey());
            item0.getValue().serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupNodesUsageResponseDeserializer(ObjectDeserializer<Builder> op) {
        NodesUsageResponse.setupNodesResponseBaseDeserializer(op);
        op.add(Builder::clusterName, JsonpDeserializer.stringDeserializer(), "cluster_name");
        op.add(Builder::nodes, JsonpDeserializer.stringMapDeserializer(NodeUsage._DESERIALIZER), "nodes");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.clusterName.hashCode();
        result = 31 * result + this.nodes.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodesUsageResponse other = (NodesUsageResponse)o;
        return this.clusterName.equals(other.clusterName) && this.nodes.equals(other.nodes);
    }

    public static class Builder
    extends NodesResponseBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, NodesUsageResponse> {
        private String clusterName;
        private Map<String, NodeUsage> nodes;

        public Builder() {
        }

        private Builder(NodesUsageResponse o) {
            super(o);
            this.clusterName = o.clusterName;
            this.nodes = Builder._mapCopy(o.nodes);
        }

        private Builder(Builder o) {
            super(o);
            this.clusterName = o.clusterName;
            this.nodes = Builder._mapCopy(o.nodes);
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder clusterName(String value) {
            this.clusterName = value;
            return this;
        }

        @Nonnull
        public final Builder nodes(Map<String, NodeUsage> map) {
            this.nodes = Builder._mapPutAll(this.nodes, map);
            return this;
        }

        @Nonnull
        public final Builder nodes(String key, NodeUsage value) {
            this.nodes = Builder._mapPut(this.nodes, key, value);
            return this;
        }

        @Nonnull
        public final Builder nodes(String key, Function<NodeUsage.Builder, ObjectBuilder<NodeUsage>> fn) {
            return this.nodes(key, fn.apply(new NodeUsage.Builder()).build());
        }

        @Override
        @Nonnull
        public NodesUsageResponse build() {
            this._checkSingleUse();
            return new NodesUsageResponse(this);
        }
    }
}

