/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.storage.scan.context;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.commons.lang3.tuple.Pair;
import org.opensearch.search.aggregations.AggregationBuilder;
import org.opensearch.search.aggregations.AggregationBuilders;
import org.opensearch.search.aggregations.AggregatorFactories;
import org.opensearch.search.aggregations.BucketOrder;
import org.opensearch.search.aggregations.bucket.composite.CompositeAggregationBuilder;
import org.opensearch.search.aggregations.bucket.composite.CompositeValuesSourceBuilder;
import org.opensearch.search.aggregations.bucket.composite.DateHistogramValuesSourceBuilder;
import org.opensearch.search.aggregations.bucket.composite.HistogramValuesSourceBuilder;
import org.opensearch.search.aggregations.bucket.composite.TermsValuesSourceBuilder;
import org.opensearch.search.aggregations.bucket.histogram.DateHistogramAggregationBuilder;
import org.opensearch.search.aggregations.bucket.histogram.HistogramAggregationBuilder;
import org.opensearch.search.aggregations.bucket.missing.MissingOrder;
import org.opensearch.search.aggregations.bucket.terms.MultiTermsAggregationBuilder;
import org.opensearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.opensearch.search.aggregations.support.MultiTermsValuesSourceConfig;
import org.opensearch.search.aggregations.support.ValuesSourceAggregationBuilder;
import org.opensearch.search.sort.SortOrder;
import org.opensearch.sql.opensearch.data.type.OpenSearchDataType;
import org.opensearch.sql.opensearch.request.OpenSearchRequestBuilder;
import org.opensearch.sql.opensearch.response.agg.BucketAggregationParser;
import org.opensearch.sql.opensearch.response.agg.CompositeAggregationParser;
import org.opensearch.sql.opensearch.response.agg.MetricParserHelper;
import org.opensearch.sql.opensearch.response.agg.OpenSearchAggregationResponseParser;
import org.opensearch.sql.opensearch.storage.scan.context.OSRequestBuilderAction;
import org.opensearch.sql.opensearch.storage.scan.context.RareTopDigest;

public class AggPushDownAction
implements OSRequestBuilderAction {
    private static final int MAX_BUCKET_SIZE = 65535;
    private Pair<List<AggregationBuilder>, OpenSearchAggregationResponseParser> builderAndParser;
    private final Map<String, OpenSearchDataType> extendedTypeMapping;
    private final long scriptCount;
    private List<String> bucketNames;

    public AggPushDownAction(Pair<List<AggregationBuilder>, OpenSearchAggregationResponseParser> builderAndParser, Map<String, OpenSearchDataType> extendedTypeMapping, List<String> bucketNames) {
        this.builderAndParser = builderAndParser;
        this.extendedTypeMapping = extendedTypeMapping;
        this.scriptCount = ((List)builderAndParser.getLeft()).stream().mapToInt(AggPushDownAction::getScriptCount).sum();
        this.bucketNames = bucketNames;
    }

    private static int getScriptCount(AggregationBuilder aggBuilder) {
        if (aggBuilder instanceof ValuesSourceAggregationBuilder && ((ValuesSourceAggregationBuilder)aggBuilder).script() != null) {
            return 1;
        }
        if (aggBuilder instanceof CompositeAggregationBuilder) {
            CompositeAggregationBuilder compositeAggBuilder = (CompositeAggregationBuilder)aggBuilder;
            int sourceScriptCount = compositeAggBuilder.sources().stream().mapToInt(source -> source.script() != null ? 1 : 0).sum();
            int subAggScriptCount = compositeAggBuilder.getSubAggregations().stream().mapToInt(AggPushDownAction::getScriptCount).sum();
            return sourceScriptCount + subAggScriptCount;
        }
        return 0;
    }

    @Override
    public void apply(OpenSearchRequestBuilder requestBuilder) {
        requestBuilder.pushDownAggregation(this.builderAndParser);
        requestBuilder.pushTypeMapping(this.extendedTypeMapping);
    }

    private BucketAggregationParser convertTo(OpenSearchAggregationResponseParser parser) {
        if (parser instanceof BucketAggregationParser) {
            return (BucketAggregationParser)parser;
        }
        if (parser instanceof CompositeAggregationParser) {
            MetricParserHelper helper = ((CompositeAggregationParser)parser).getMetricsParser();
            return new BucketAggregationParser(helper.getMetricParserMap().values().stream().toList(), helper.getCountAggNameList());
        }
        throw new IllegalStateException("Unexpected parser type: " + String.valueOf(parser.getClass()));
    }

    private String multiTermsBucketNameAsString(CompositeAggregationBuilder composite) {
        return composite.sources().stream().map(TermsValuesSourceBuilder.class::cast).map(CompositeValuesSourceBuilder::name).collect(Collectors.joining("|"));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void rePushDownSortAggMeasure(List<RelFieldCollation> collations, List<String> fieldNames) {
        if (((List)this.builderAndParser.getLeft()).isEmpty()) {
            return;
        }
        Object e = ((List)this.builderAndParser.getLeft()).getFirst();
        if (!(e instanceof CompositeAggregationBuilder)) return;
        CompositeAggregationBuilder composite = (CompositeAggregationBuilder)e;
        boolean asc = collations.get(0).getDirection() == RelFieldCollation.Direction.ASCENDING;
        String path = this.getAggregationPath(collations, fieldNames, composite);
        BucketOrder bucketOrder = composite.getSubAggregations().isEmpty() ? BucketOrder.count((boolean)asc) : BucketOrder.aggregation((String)path, (boolean)asc);
        MultiTermsAggregationBuilder aggregationBuilder = null;
        if (composite.sources().size() == 1) {
            TermsValuesSourceBuilder terms;
            Object e2 = composite.sources().get(0);
            if (e2 instanceof TermsValuesSourceBuilder && !(terms = (TermsValuesSourceBuilder)e2).missingBucket()) {
                aggregationBuilder = this.buildTermsAggregationBuilder(terms, bucketOrder, composite.size());
                this.attachSubAggregations(composite.getSubAggregations(), path, (AggregationBuilder)aggregationBuilder);
            } else {
                e2 = composite.sources().get(0);
                if (e2 instanceof DateHistogramValuesSourceBuilder) {
                    DateHistogramValuesSourceBuilder dateHisto = (DateHistogramValuesSourceBuilder)e2;
                    aggregationBuilder = this.buildDateHistogramAggregationBuilder(dateHisto, bucketOrder);
                    this.attachSubAggregations(composite.getSubAggregations(), path, (AggregationBuilder)aggregationBuilder);
                } else {
                    HistogramValuesSourceBuilder histo;
                    e2 = composite.sources().get(0);
                    if (!(e2 instanceof HistogramValuesSourceBuilder) || (histo = (HistogramValuesSourceBuilder)e2).missingBucket()) throw new OpenSearchRequestBuilder.PushDownUnSupportedException("Cannot pushdown sort aggregate measure");
                    aggregationBuilder = this.buildHistogramAggregationBuilder(histo, bucketOrder);
                    this.attachSubAggregations(composite.getSubAggregations(), path, (AggregationBuilder)aggregationBuilder);
                }
            }
        } else {
            if (!composite.sources().stream().allMatch(src -> {
                TermsValuesSourceBuilder terms;
                return src instanceof TermsValuesSourceBuilder && !(terms = (TermsValuesSourceBuilder)src).missingBucket();
            })) throw new OpenSearchRequestBuilder.PushDownUnSupportedException("Cannot pushdown sort aggregate measure");
            aggregationBuilder = this.buildMultiTermsAggregationBuilder(composite, bucketOrder);
            this.attachSubAggregations(composite.getSubAggregations(), path, (AggregationBuilder)aggregationBuilder);
        }
        this.builderAndParser = Pair.of(Collections.singletonList(aggregationBuilder), (Object)this.convertTo((OpenSearchAggregationResponseParser)this.builderAndParser.getRight()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void rePushDownRareTop(RareTopDigest digest) {
        if (((List)this.builderAndParser.getLeft()).isEmpty()) {
            return;
        }
        Object e = ((List)this.builderAndParser.getLeft()).getFirst();
        if (!(e instanceof CompositeAggregationBuilder)) return;
        CompositeAggregationBuilder composite = (CompositeAggregationBuilder)e;
        BucketOrder bucketOrder = digest.direction() == RelFieldCollation.Direction.ASCENDING ? BucketOrder.count((boolean)true) : BucketOrder.count((boolean)false);
        TermsAggregationBuilder aggregationBuilder = null;
        if (composite.sources().size() == 1) {
            TermsValuesSourceBuilder terms;
            Object e2 = composite.sources().get(0);
            if (e2 instanceof TermsValuesSourceBuilder && !(terms = (TermsValuesSourceBuilder)e2).missingBucket()) {
                aggregationBuilder = this.buildTermsAggregationBuilder(terms, bucketOrder, digest.number());
            } else {
                e2 = composite.sources().get(0);
                if (e2 instanceof DateHistogramValuesSourceBuilder) {
                    DateHistogramValuesSourceBuilder dateHisto = (DateHistogramValuesSourceBuilder)e2;
                    aggregationBuilder = this.buildDateHistogramAggregationBuilder(dateHisto, bucketOrder);
                } else {
                    HistogramValuesSourceBuilder histo;
                    e2 = composite.sources().get(0);
                    if (!(e2 instanceof HistogramValuesSourceBuilder) || (histo = (HistogramValuesSourceBuilder)e2).missingBucket()) throw new OpenSearchRequestBuilder.PushDownUnSupportedException("Cannot pushdown " + String.valueOf(digest));
                    aggregationBuilder = this.buildHistogramAggregationBuilder(histo, bucketOrder);
                }
            }
        } else {
            if (!composite.sources().stream().allMatch(src -> {
                TermsValuesSourceBuilder terms;
                return src instanceof TermsValuesSourceBuilder && !(terms = (TermsValuesSourceBuilder)src).missingBucket();
            })) throw new OpenSearchRequestBuilder.PushDownUnSupportedException("Cannot pushdown " + String.valueOf(digest));
            for (int i = 0; i < composite.sources().size(); ++i) {
                TermsValuesSourceBuilder terms = (TermsValuesSourceBuilder)composite.sources().get(i);
                if (i == 0) {
                    aggregationBuilder = this.buildTermsAggregationBuilder(terms, null, 65535);
                    continue;
                }
                if (i == composite.sources().size() - 1) {
                    aggregationBuilder.subAggregation((AggregationBuilder)this.buildTermsAggregationBuilder(terms, bucketOrder, digest.number()));
                    continue;
                }
                aggregationBuilder.subAggregation((AggregationBuilder)this.buildTermsAggregationBuilder(terms, null, 65535));
            }
        }
        this.builderAndParser = Pair.of(Collections.singletonList(aggregationBuilder), (Object)this.convertTo((OpenSearchAggregationResponseParser)this.builderAndParser.getRight()));
    }

    private TermsAggregationBuilder buildTermsAggregationBuilder(TermsValuesSourceBuilder terms, BucketOrder bucketOrder, int newSize) {
        TermsAggregationBuilder termsBuilder = new TermsAggregationBuilder(terms.name());
        termsBuilder.size(newSize);
        if (terms.field() != null) {
            termsBuilder.field(terms.field());
        }
        if (terms.script() != null) {
            termsBuilder.script(terms.script());
        }
        if (terms.userValuetypeHint() != null) {
            termsBuilder.userValueTypeHint(terms.userValuetypeHint());
        }
        if (bucketOrder != null) {
            termsBuilder.order(bucketOrder);
        }
        return termsBuilder;
    }

    private DateHistogramAggregationBuilder buildDateHistogramAggregationBuilder(DateHistogramValuesSourceBuilder dateHisto, BucketOrder bucketOrder) {
        DateHistogramAggregationBuilder dateHistoBuilder = new DateHistogramAggregationBuilder(dateHisto.name());
        if (dateHisto.field() != null) {
            dateHistoBuilder.field(dateHisto.field());
        }
        if (dateHisto.script() != null) {
            dateHistoBuilder.script(dateHisto.script());
        }
        try {
            dateHistoBuilder.fixedInterval(dateHisto.getIntervalAsFixed());
        }
        catch (IllegalArgumentException e) {
            dateHistoBuilder.calendarInterval(dateHisto.getIntervalAsCalendar());
        }
        if (dateHisto.userValuetypeHint() != null) {
            dateHistoBuilder.userValueTypeHint(dateHisto.userValuetypeHint());
        }
        dateHistoBuilder.order(bucketOrder);
        return dateHistoBuilder;
    }

    private HistogramAggregationBuilder buildHistogramAggregationBuilder(HistogramValuesSourceBuilder histo, BucketOrder bucketOrder) {
        HistogramAggregationBuilder histoBuilder = new HistogramAggregationBuilder(histo.name());
        if (histo.field() != null) {
            histoBuilder.field(histo.field());
        }
        if (histo.script() != null) {
            histoBuilder.script(histo.script());
        }
        histoBuilder.interval(histo.interval());
        if (histo.userValuetypeHint() != null) {
            histoBuilder.userValueTypeHint(histo.userValuetypeHint());
        }
        histoBuilder.order(bucketOrder);
        return histoBuilder;
    }

    private MultiTermsAggregationBuilder buildMultiTermsAggregationBuilder(CompositeAggregationBuilder composite, BucketOrder bucketOrder) {
        MultiTermsAggregationBuilder multiTermsBuilder = new MultiTermsAggregationBuilder(this.multiTermsBucketNameAsString(composite));
        multiTermsBuilder.size(composite.size());
        multiTermsBuilder.terms(composite.sources().stream().map(TermsValuesSourceBuilder.class::cast).map(termValue -> {
            MultiTermsValuesSourceConfig.Builder config = new MultiTermsValuesSourceConfig.Builder();
            config.setFieldName(termValue.field());
            if (termValue.script() != null) {
                config.setScript(termValue.script());
            }
            config.setUserValueTypeHint(termValue.userValuetypeHint());
            return config.build();
        }).toList());
        multiTermsBuilder.order(bucketOrder);
        return multiTermsBuilder;
    }

    private String getAggregationPath(List<RelFieldCollation> collations, List<String> fieldNames, CompositeAggregationBuilder composite) {
        AggregationBuilder metric = composite.getSubAggregations().stream().findFirst().orElse(null);
        if (metric != null && !(metric instanceof ValuesSourceAggregationBuilder.LeafOnly)) {
            throw new OpenSearchRequestBuilder.PushDownUnSupportedException("Cannot pushdown sort aggregate measure, composite.getSubAggregations() is not a LeafOnly");
        }
        return fieldNames.get(collations.get(0).getFieldIndex());
    }

    private AggregationBuilder attachSubAggregations(Collection<AggregationBuilder> subAggregations, String path, AggregationBuilder aggregationBuilder) {
        if (!subAggregations.isEmpty()) {
            AggregatorFactories.Builder metricBuilder = new AggregatorFactories.Builder();
            subAggregations.forEach(arg_0 -> ((AggregatorFactories.Builder)metricBuilder).addAggregator(arg_0));
            if (subAggregations.stream().noneMatch(sub -> sub.getName().equals(path))) {
                metricBuilder.addAggregator((AggregationBuilder)AggregationBuilders.count((String)path).field("_index"));
            }
            aggregationBuilder.subAggregations(metricBuilder);
        }
        return aggregationBuilder;
    }

    public void pushDownSortIntoAggBucket(List<RelFieldCollation> collations, List<String> fieldNames) {
        if (((List)this.builderAndParser.getLeft()).isEmpty()) {
            return;
        }
        AggregationBuilder builder = (AggregationBuilder)((List)this.builderAndParser.getLeft()).getFirst();
        ArrayList selected = new ArrayList(collations.size());
        if (builder instanceof CompositeAggregationBuilder) {
            CompositeAggregationBuilder compositeAggBuilder = (CompositeAggregationBuilder)builder;
            List buckets = compositeAggBuilder.sources();
            ArrayList newBuckets = new ArrayList(buckets.size());
            ArrayList<String> newBucketNames = new ArrayList<String>(buckets.size());
            collations.forEach(collation -> {
                SortOrder order;
                String bucketName = (String)fieldNames.get(collation.getFieldIndex());
                CompositeValuesSourceBuilder bucket = (CompositeValuesSourceBuilder)buckets.get(this.bucketNames.indexOf(bucketName));
                RelFieldCollation.Direction direction = collation.getDirection();
                RelFieldCollation.NullDirection nullDirection = collation.nullDirection;
                SortOrder sortOrder = order = RelFieldCollation.Direction.DESCENDING.equals((Object)direction) ? SortOrder.DESC : SortOrder.ASC;
                if (bucket.missingBucket()) {
                    MissingOrder missingOrder = switch (nullDirection) {
                        case RelFieldCollation.NullDirection.FIRST -> MissingOrder.FIRST;
                        case RelFieldCollation.NullDirection.LAST -> MissingOrder.LAST;
                        default -> MissingOrder.DEFAULT;
                    };
                    bucket.missingOrder(missingOrder);
                }
                newBuckets.add(bucket.order(order));
                newBucketNames.add(bucketName);
                selected.add(bucketName);
            });
            buckets.stream().map(CompositeValuesSourceBuilder::name).filter(name -> !selected.contains(name)).forEach(name -> {
                newBuckets.add((CompositeValuesSourceBuilder)buckets.get(this.bucketNames.indexOf(name)));
                newBucketNames.add((String)name);
            });
            AggregatorFactories.Builder newAggBuilder = new AggregatorFactories.Builder();
            compositeAggBuilder.getSubAggregations().forEach(arg_0 -> ((AggregatorFactories.Builder)newAggBuilder).addAggregator(arg_0));
            this.builderAndParser = Pair.of(Collections.singletonList(((CompositeAggregationBuilder)AggregationBuilders.composite((String)"composite_buckets", newBuckets).subAggregations(newAggBuilder)).size(compositeAggBuilder.size())), (Object)((OpenSearchAggregationResponseParser)this.builderAndParser.getRight()));
            this.bucketNames = newBucketNames;
        }
        if (builder instanceof TermsAggregationBuilder) {
            TermsAggregationBuilder termsAggBuilder = (TermsAggregationBuilder)builder;
            termsAggBuilder.order(BucketOrder.key((!collations.getFirst().getDirection().isDescending() ? 1 : 0) != 0));
        }
    }

    public boolean pushDownLimitIntoBucketSize(Integer size) {
        if (((List)this.builderAndParser.getLeft()).isEmpty()) {
            return false;
        }
        AggregationBuilder builder = (AggregationBuilder)((List)this.builderAndParser.getLeft()).getFirst();
        if (builder instanceof CompositeAggregationBuilder) {
            CompositeAggregationBuilder compositeAggBuilder = (CompositeAggregationBuilder)builder;
            if (size < compositeAggBuilder.size()) {
                compositeAggBuilder.size(size.intValue());
                return true;
            }
            return false;
        }
        if (builder instanceof TermsAggregationBuilder) {
            TermsAggregationBuilder termsAggBuilder = (TermsAggregationBuilder)builder;
            if (size < termsAggBuilder.size()) {
                termsAggBuilder.size(size.intValue());
                return true;
            }
            return false;
        }
        if (builder instanceof MultiTermsAggregationBuilder) {
            MultiTermsAggregationBuilder multiTermsAggBuilder = (MultiTermsAggregationBuilder)builder;
            if (size < multiTermsAggBuilder.size()) {
                multiTermsAggBuilder.size(size.intValue());
                return true;
            }
            return false;
        }
        if (builder instanceof ValuesSourceAggregationBuilder.LeafOnly) {
            return true;
        }
        throw new OpenSearchRequestBuilder.PushDownUnSupportedException("Unknown aggregation builder " + builder.getClass().getSimpleName());
    }

    @Generated
    public Pair<List<AggregationBuilder>, OpenSearchAggregationResponseParser> getBuilderAndParser() {
        return this.builderAndParser;
    }

    @Generated
    public Map<String, OpenSearchDataType> getExtendedTypeMapping() {
        return this.extendedTypeMapping;
    }

    @Generated
    public long getScriptCount() {
        return this.scriptCount;
    }

    @Generated
    public List<String> getBucketNames() {
        return this.bucketNames;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AggPushDownAction)) {
            return false;
        }
        AggPushDownAction other = (AggPushDownAction)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getScriptCount() != other.getScriptCount()) {
            return false;
        }
        Pair<List<AggregationBuilder>, OpenSearchAggregationResponseParser> this$builderAndParser = this.getBuilderAndParser();
        Pair<List<AggregationBuilder>, OpenSearchAggregationResponseParser> other$builderAndParser = other.getBuilderAndParser();
        if (this$builderAndParser == null ? other$builderAndParser != null : !this$builderAndParser.equals(other$builderAndParser)) {
            return false;
        }
        Map<String, OpenSearchDataType> this$extendedTypeMapping = this.getExtendedTypeMapping();
        Map<String, OpenSearchDataType> other$extendedTypeMapping = other.getExtendedTypeMapping();
        if (this$extendedTypeMapping == null ? other$extendedTypeMapping != null : !((Object)this$extendedTypeMapping).equals(other$extendedTypeMapping)) {
            return false;
        }
        List<String> this$bucketNames = this.getBucketNames();
        List<String> other$bucketNames = other.getBucketNames();
        return !(this$bucketNames == null ? other$bucketNames != null : !((Object)this$bucketNames).equals(other$bucketNames));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AggPushDownAction;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $scriptCount = this.getScriptCount();
        result = result * 59 + (int)($scriptCount >>> 32 ^ $scriptCount);
        Pair<List<AggregationBuilder>, OpenSearchAggregationResponseParser> $builderAndParser = this.getBuilderAndParser();
        result = result * 59 + ($builderAndParser == null ? 43 : $builderAndParser.hashCode());
        Map<String, OpenSearchDataType> $extendedTypeMapping = this.getExtendedTypeMapping();
        result = result * 59 + ($extendedTypeMapping == null ? 43 : ((Object)$extendedTypeMapping).hashCode());
        List<String> $bucketNames = this.getBucketNames();
        result = result * 59 + ($bucketNames == null ? 43 : ((Object)$bucketNames).hashCode());
        return result;
    }
}

