/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.data.model;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Objects;
import lombok.Generated;
import org.opensearch.sql.data.model.AbstractExprValue;
import org.opensearch.sql.data.model.ExprDateValue;
import org.opensearch.sql.data.model.ExprTimeValue;
import org.opensearch.sql.data.model.ExprTimestampValue;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.data.type.ExprType;
import org.opensearch.sql.exception.ExpressionEvaluationException;

public class ExprStringValue
extends AbstractExprValue {
    private final String value;

    @Override
    public Object value() {
        return this.value;
    }

    @Override
    public ExprType type() {
        return ExprCoreType.STRING;
    }

    @Override
    public String stringValue() {
        return this.value;
    }

    @Override
    public Instant timestampValue() {
        try {
            return new ExprTimestampValue(this.value).timestampValue();
        }
        catch (ExpressionEvaluationException e) {
            return new ExprTimestampValue(LocalDateTime.of(new ExprDateValue(this.value).dateValue(), LocalTime.of(0, 0, 0))).timestampValue();
        }
    }

    @Override
    public LocalDate dateValue() {
        try {
            return new ExprTimestampValue(this.value).dateValue();
        }
        catch (ExpressionEvaluationException e) {
            return new ExprDateValue(this.value).dateValue();
        }
    }

    @Override
    public LocalTime timeValue() {
        try {
            return new ExprTimestampValue(this.value).timeValue();
        }
        catch (ExpressionEvaluationException e) {
            return new ExprTimeValue(this.value).timeValue();
        }
    }

    public String toString() {
        return String.format("\"%s\"", this.value);
    }

    @Override
    public int compare(ExprValue other) {
        return this.value.compareTo(other.stringValue());
    }

    @Override
    public boolean equal(ExprValue other) {
        return this.value.equals(other.stringValue());
    }

    public int hashCode() {
        return Objects.hashCode(this.value);
    }

    @Generated
    public ExprStringValue(String value) {
        this.value = value;
    }
}

