/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.calcite.utils;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.opensearch.sql.common.setting.Settings;

public final class CalciteUtils {
    public static UnsupportedOperationException getOnlyForCalciteException(String feature) {
        return new UnsupportedOperationException(feature + " is supported only when " + Settings.Key.CALCITE_ENGINE_ENABLED.getKeyValue() + "=true");
    }

    public static <T> Pair<List<T>, List<T>> partition(Collection<T> collection, Predicate<T> predicate) {
        Map<Boolean, List<T>> map = collection.stream().collect(Collectors.partitioningBy(predicate));
        return new ImmutablePair(map.get(true), map.get(false));
    }

    @Generated
    private CalciteUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

