/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.flowframework.transport;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.DocRequest;
import org.opensearch.common.Nullable;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.flowframework.common.CommonValue;
import org.opensearch.flowframework.model.Template;

public class WorkflowRequest
extends ActionRequest
implements DocRequest {
    @Nullable
    private String workflowId;
    @Nullable
    private Template template;
    private String[] validation;
    private boolean provision;
    private boolean reprovision;
    private boolean updateFields;
    private Map<String, String> params;
    private TimeValue waitForCompletionTimeout;

    public WorkflowRequest(@Nullable String workflowId, @Nullable Template template) {
        this(workflowId, template, new String[]{"all"}, false, Collections.emptyMap(), false, TimeValue.MINUS_ONE);
    }

    public WorkflowRequest(@Nullable String workflowId, @Nullable Template template, Map<String, String> params) {
        this(workflowId, template, new String[]{"all"}, true, params, false, TimeValue.MINUS_ONE);
    }

    public WorkflowRequest(@Nullable String workflowId, @Nullable Template template, Map<String, String> params, TimeValue waitForCompletionTimeout) {
        this(workflowId, template, new String[]{"all"}, true, params, false, waitForCompletionTimeout);
    }

    public WorkflowRequest(@Nullable String workflowId, @Nullable Template template, String[] validation, boolean provisionOrUpdate, Map<String, String> params, boolean reprovision) {
        this(workflowId, template, validation, provisionOrUpdate, params, reprovision, TimeValue.MINUS_ONE);
    }

    public WorkflowRequest(@Nullable String workflowId, @Nullable Template template, String[] validation, boolean provisionOrUpdate, Map<String, String> params, boolean reprovision, TimeValue waitForCompletionTimeout) {
        this.workflowId = workflowId;
        this.template = template;
        this.validation = validation;
        this.provision = provisionOrUpdate && !params.containsKey("update_fields");
        boolean bl = this.updateFields = !this.provision && Boolean.parseBoolean(params.get("update_fields"));
        if (!this.provision && params.keySet().stream().anyMatch(k -> !"update_fields".equals(k) && !"wait_for_completion_timeout".equals(k))) {
            throw new IllegalArgumentException("Params may only be included when provisioning.");
        }
        this.params = this.updateFields ? Collections.emptyMap() : params;
        this.reprovision = reprovision;
        this.waitForCompletionTimeout = waitForCompletionTimeout;
    }

    public WorkflowRequest(StreamInput in) throws IOException {
        super(in);
        this.workflowId = in.readOptionalString();
        String templateJson = in.readOptionalString();
        this.template = templateJson == null ? null : Template.parse(templateJson);
        this.validation = in.readStringArray();
        boolean provisionOrUpdateOrReprovision = in.readBoolean();
        this.params = provisionOrUpdateOrReprovision ? in.readMap(StreamInput::readString, StreamInput::readString) : Collections.emptyMap();
        this.provision = provisionOrUpdateOrReprovision && !this.params.containsKey("update_fields") && !this.params.containsKey("reprovision");
        boolean bl = this.updateFields = !this.provision && Boolean.parseBoolean(this.params.get("update_fields"));
        if (this.updateFields) {
            this.params = Collections.emptyMap();
        }
        boolean bl2 = this.reprovision = !this.provision && Boolean.parseBoolean(this.params.get("reprovision"));
        if (in.getVersion().onOrAfter(CommonValue.VERSION_2_19_0)) {
            this.waitForCompletionTimeout = in.readOptionalTimeValue();
        }
    }

    @Nullable
    public String getWorkflowId() {
        return this.workflowId;
    }

    @Nullable
    public Template getTemplate() {
        return this.template;
    }

    public String[] getValidation() {
        return this.validation;
    }

    public boolean isProvision() {
        return this.provision;
    }

    public boolean isUpdateFields() {
        return this.updateFields;
    }

    public Map<String, String> getParams() {
        return Map.copyOf(this.params);
    }

    public boolean isReprovision() {
        return this.reprovision;
    }

    @Nullable
    public TimeValue getWaitForCompletionTimeout() {
        return this.waitForCompletionTimeout;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeOptionalString(this.workflowId);
        out.writeOptionalString(this.template == null ? null : this.template.toJson());
        out.writeStringArray(this.validation);
        out.writeBoolean(this.provision || this.updateFields || this.reprovision);
        if (this.provision) {
            out.writeMap(this.params, StreamOutput::writeString, StreamOutput::writeString);
        } else if (this.updateFields) {
            out.writeMap(Map.of("update_fields", "true"), StreamOutput::writeString, StreamOutput::writeString);
        } else if (this.reprovision) {
            out.writeMap(Map.of("reprovision", "true"), StreamOutput::writeString, StreamOutput::writeString);
        }
        if (out.getVersion().onOrAfter(CommonValue.VERSION_2_19_0)) {
            out.writeOptionalTimeValue(this.waitForCompletionTimeout);
        }
    }

    public ActionRequestValidationException validate() {
        return null;
    }

    public String index() {
        return ".plugins-flow-framework-templates";
    }

    public String id() {
        return this.workflowId;
    }

    public String type() {
        return "workflow";
    }
}

