/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.indexInsight;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.LatchedActionListener;
import org.opensearch.action.admin.indices.mapping.get.GetMappingsRequest;
import org.opensearch.cluster.metadata.MappingMetadata;
import org.opensearch.core.action.ActionListener;
import org.opensearch.ml.common.indexInsight.AbstractIndexInsightTask;
import org.opensearch.ml.common.indexInsight.IndexInsight;
import org.opensearch.ml.common.indexInsight.IndexInsightTask;
import org.opensearch.ml.common.indexInsight.IndexInsightTaskStatus;
import org.opensearch.ml.common.indexInsight.MLIndexInsightType;
import org.opensearch.ml.common.indexInsight.StatisticalDataTask;
import org.opensearch.ml.common.utils.StringUtils;
import org.opensearch.remote.metadata.client.SdkClient;
import org.opensearch.transport.client.Client;

public class FieldDescriptionTask
extends AbstractIndexInsightTask {
    @Generated
    private static final Logger log = LogManager.getLogger(FieldDescriptionTask.class);
    private static final int BATCH_SIZE = 50;

    public FieldDescriptionTask(String sourceIndex, Client client, SdkClient sdkClient) {
        super(MLIndexInsightType.FIELD_DESCRIPTION, sourceIndex, client, sdkClient);
    }

    @Override
    public void runTask(String tenantId, ActionListener<IndexInsight> listener) {
        try {
            this.getInsightContentFromContainer(MLIndexInsightType.STATISTICAL_DATA, tenantId, (ActionListener<Map<String, Object>>)ActionListener.wrap(statisticalContentMap -> FieldDescriptionTask.getAgentIdToRun(this.client, tenantId, (ActionListener<String>)ActionListener.wrap(agentId -> this.batchProcessFields((Map<String, Object>)statisticalContentMap, (String)agentId, tenantId, listener), arg_0 -> ((ActionListener)listener).onFailure(arg_0))), e -> this.handleError("Failed to get statistical content for index {}", (Exception)e, tenantId, listener)));
        }
        catch (Exception e2) {
            this.handleError("Failed to execute field description task for index {}", e2, tenantId, listener);
        }
    }

    private Map<String, Object> filterFieldDescriptions(Map<String, Object> patternFieldDescriptions, Map<String, Object> currentIndexFields) {
        LinkedHashMap<String, Object> filteredDescriptions = new LinkedHashMap<String, Object>();
        if (patternFieldDescriptions == null || currentIndexFields == null) {
            return filteredDescriptions;
        }
        currentIndexFields.keySet().stream().filter(patternFieldDescriptions::containsKey).forEach(fieldName -> filteredDescriptions.put((String)fieldName, patternFieldDescriptions.get(fieldName)));
        return filteredDescriptions;
    }

    @Override
    protected void handlePatternResult(Map<String, Object> patternSource, String tenantId, ActionListener<IndexInsight> listener) {
        try {
            String patternContent = (String)patternSource.get("content");
            Map patternFieldDescriptions = (Map)StringUtils.gson.fromJson(patternContent, Map.class);
            GetMappingsRequest getMappingsRequest = (GetMappingsRequest)new GetMappingsRequest().indices(new String[]{this.sourceIndex});
            this.client.admin().indices().getMappings(getMappingsRequest, ActionListener.wrap(getMappingsResponse -> {
                try {
                    Map mappings = getMappingsResponse.getMappings();
                    if (mappings.isEmpty()) {
                        this.beginGeneration(tenantId, listener);
                        return;
                    }
                    HashMap<String, String> currentFields = new HashMap<String, String>();
                    for (MappingMetadata mappingMetadata : mappings.values()) {
                        Map mappingSource = (Map)mappingMetadata.getSourceAsMap().get("properties");
                        if (mappingSource == null) continue;
                        FieldDescriptionTask.extractFieldNamesTypes(mappingSource, currentFields, "", false);
                    }
                    HashMap<String, Object> currentFieldsMap = new HashMap<String, Object>(currentFields);
                    Map<String, Object> filteredDescriptions = this.filterFieldDescriptions(patternFieldDescriptions, currentFieldsMap);
                    Long lastUpdateTime = (Long)patternSource.get("last_updated_time");
                    IndexInsight insight = IndexInsight.builder().index(this.sourceIndex).taskType(this.taskType).content(StringUtils.gson.toJson(filteredDescriptions)).status(IndexInsightTaskStatus.COMPLETED).lastUpdatedTime(Instant.ofEpochMilli(lastUpdateTime)).build();
                    listener.onResponse((Object)insight);
                }
                catch (Exception e) {
                    log.error("Failed to process current index mapping for index {}", (Object)this.sourceIndex, (Object)e);
                    listener.onFailure(e);
                }
            }, e -> {
                log.error("Failed to get current index mapping for index {}", (Object)this.sourceIndex, e);
                listener.onFailure(e);
            }));
        }
        catch (Exception e2) {
            log.error("Failed to filter field descriptions for index {}", (Object)this.sourceIndex, (Object)e2);
            listener.onFailure(e2);
        }
    }

    @Override
    public List<MLIndexInsightType> getPrerequisites() {
        return Collections.singletonList(MLIndexInsightType.STATISTICAL_DATA);
    }

    private void batchProcessFields(Map<String, Object> statisticalContentMap, String agentId, String tenantId, ActionListener<IndexInsight> listener) {
        Object obj = statisticalContentMap.get("important_column_and_distribution");
        if (!(obj instanceof Map)) {
            this.handleError("No mapping properties found for index: {}", new IllegalStateException("No data distribution found for index: " + this.sourceIndex), tenantId, listener);
            return;
        }
        Map mappingSource = (Map)obj;
        List<String> allFields = List.of(mappingSource.keySet().toArray(new String[0]));
        if (allFields.isEmpty()) {
            log.warn("No important fields found for index: {}", (Object)this.sourceIndex);
            this.saveResult("", tenantId, (ActionListener<IndexInsight>)ActionListener.wrap(insight -> {
                log.info("Empty field description completed for: {}", (Object)this.sourceIndex);
                listener.onResponse(insight);
            }, e -> this.handleError("Failed to save empty field description result for index {}", (Exception)e, tenantId, listener)));
            return;
        }
        List<List<String>> batches = this.createBatches(allFields, 50);
        CountDownLatch countDownLatch = new CountDownLatch(batches.size());
        ConcurrentHashMap resultsMap = new ConcurrentHashMap();
        AtomicBoolean hasErrors = new AtomicBoolean(false);
        ActionListener resultListener = ActionListener.wrap(batchResult -> {
            if (batchResult != null) {
                resultsMap.putAll(batchResult);
            }
        }, e -> {
            hasErrors.set(true);
            log.error("Batch processing failed for index {}: {}", (Object)this.sourceIndex, (Object)e.getMessage());
        });
        LatchedActionListener latchedActionListener = new LatchedActionListener(resultListener, countDownLatch);
        for (List<String> batch : batches) {
            this.processBatch(batch, statisticalContentMap, agentId, (ActionListener<Map<String, Object>>)latchedActionListener);
        }
        try {
            countDownLatch.await(60L, TimeUnit.SECONDS);
            if (!hasErrors.get()) {
                this.saveResult(StringUtils.gson.toJson(resultsMap), tenantId, (ActionListener<IndexInsight>)ActionListener.wrap(insight -> {
                    log.info("Field description completed for: {}", (Object)this.sourceIndex);
                    listener.onResponse(insight);
                }, e -> this.handleError("Failed to save field description result for index {}", (Exception)e, tenantId, listener)));
            } else {
                this.handleError("Batch processing failed for index {}", new Exception("Batch processing failed"), tenantId, listener);
            }
        }
        catch (InterruptedException e2) {
            log.error("Batch processing interrupted for index: {}", (Object)this.sourceIndex);
            this.handleError("Batch processing interrupted for index {}", e2, tenantId, listener);
        }
    }

    private List<List<String>> createBatches(List<String> fields, int batchSize) {
        ArrayList<List<String>> batches = new ArrayList<List<String>>();
        for (int i = 0; i < fields.size(); i += batchSize) {
            int end = Math.min(i + batchSize, fields.size());
            batches.add(fields.subList(i, end));
        }
        return batches;
    }

    private void processBatch(List<String> batchFields, Map<String, Object> statisticalContentMap, String agentId, ActionListener<Map<String, Object>> listener) {
        String prompt = this.generateBatchPrompt(batchFields, statisticalContentMap);
        FieldDescriptionTask.callLLMWithAgent(this.client, agentId, prompt, this.sourceIndex, (ActionListener<String>)ActionListener.wrap(response -> {
            try {
                log.info("Batch LLM call successful for {} fields in index {}", (Object)batchFields.size(), (Object)this.sourceIndex);
                Map<String, Object> batchResult = this.parseFieldDescription((String)response);
                listener.onResponse(batchResult);
            }
            catch (Exception e) {
                log.error("Error parsing response for batch in index {}: {}", (Object)this.sourceIndex, (Object)e.getMessage());
                listener.onFailure(e);
            }
        }, e -> listener.onFailure(e)));
    }

    private String generateBatchPrompt(List<String> batchFields, Map<String, Object> statisticalContentMap) {
        StringBuilder prompt = new StringBuilder();
        prompt.append("Please analyze the following OpenSearch index fields and provide descriptions:\\n\\n");
        prompt.append("Index Name: ").append(this.sourceIndex).append("\\n\\n");
        prompt.append("Fields to describe:\\n");
        for (String field : batchFields) {
            prompt.append("- ").append(field).append("\\n");
        }
        prompt.append("\\n");
        Map<String, Object> relevantStatisticalData = this.extractRelevantStatisticalData(statisticalContentMap, batchFields);
        if (!relevantStatisticalData.isEmpty()) {
            if (relevantStatisticalData.containsKey("important_column_and_distribution")) {
                prompt.append("Some Field Distribution:\\n").append(relevantStatisticalData.get("important_column_and_distribution")).append("\\n\\n");
            }
            if (relevantStatisticalData.containsKey("example_docs")) {
                prompt.append("Example Documents:\\n").append(relevantStatisticalData.get("example_docs")).append("\\n\\n");
            }
        }
        prompt.append("For each field listed above, provide a brief description of what it contains and its purpose. The description should not mention specific values from any example documents or include specific examples.\\n");
        prompt.append("For each field, provide description in the following format EXACTLY:\\n");
        prompt.append("field_name: description");
        return prompt.toString();
    }

    private Map<String, Object> extractRelevantStatisticalData(Map<String, Object> statisticalContentMap, List<String> batchFields) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        if (statisticalContentMap == null || statisticalContentMap.isEmpty() || batchFields.isEmpty()) {
            return result;
        }
        try {
            List exampleDocs;
            Map distribution = (Map)statisticalContentMap.get("important_column_and_distribution");
            LinkedHashMap relevantMapping = new LinkedHashMap();
            for (String field : batchFields) {
                if (distribution == null || !distribution.containsKey(field)) continue;
                relevantMapping.put(field, distribution.get(field));
            }
            if (!relevantMapping.isEmpty()) {
                result.put("important_column_and_distribution", relevantMapping);
            }
            if ((exampleDocs = (List)statisticalContentMap.get("example_docs")) != null && !exampleDocs.isEmpty()) {
                ArrayList filteredExampleDocs = new ArrayList();
                for (Map doc : exampleDocs) {
                    LinkedHashMap filteredDoc = new LinkedHashMap();
                    for (String field : batchFields) {
                        if (!doc.containsKey(field)) continue;
                        filteredDoc.put(field, doc.get(field));
                    }
                    filteredExampleDocs.add(filteredDoc);
                }
                result.put("example_docs", filteredExampleDocs);
            }
        }
        catch (Exception e) {
            log.warn("Failed to extract relevant statistical data for batch fields: {}", (Object)e.getMessage());
        }
        return result;
    }

    private Map<String, Object> parseFieldDescription(String modelResponse) {
        String[] lines;
        LinkedHashMap<String, Object> field2Desc = new LinkedHashMap<String, Object>();
        for (String line : lines = modelResponse.trim().split("\\n")) {
            String[] parts = (line = line.trim()).split(":", 2);
            if (parts.length != 2) continue;
            String name = parts[0].trim();
            String desc = parts[1].trim();
            if (desc.isEmpty()) continue;
            field2Desc.put(name, desc);
        }
        return field2Desc;
    }

    @Override
    public IndexInsightTask createPrerequisiteTask(MLIndexInsightType prerequisiteType) {
        if (prerequisiteType == MLIndexInsightType.STATISTICAL_DATA) {
            return new StatisticalDataTask(this.sourceIndex, this.client, this.sdkClient);
        }
        throw new IllegalStateException("Unsupported prerequisite type: " + String.valueOf((Object)prerequisiteType));
    }
}

