/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.transport;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.search.join.ScoreMode;
import org.opensearch.commons.authuser.User;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.threadpool.ThreadPool;

public interface SecureTransportAction {
    public static final Logger log = LogManager.getLogger(SecureTransportAction.class);

    default public User readUserFromThreadContext(ThreadPool threadPool) {
        String userStr = (String)threadPool.getThreadContext().getTransient("_opendistro_security_user_info");
        log.info("User and roles string from thread context: {}", (Object)userStr);
        return User.parse((String)userStr);
    }

    default public boolean doFilterForUser(User user, boolean filterByEnabled) {
        log.debug("Is filterByEnabled: {} ; Is admin user: {}", (Object)filterByEnabled, (Object)this.isAdmin(user));
        if (this.isAdmin(user)) {
            return false;
        }
        return filterByEnabled;
    }

    default public boolean isAdmin(User user) {
        if (user == null) {
            return false;
        }
        if (user.getRoles().size() == 0) {
            return false;
        }
        return user.getRoles().contains("all_access");
    }

    default public String validateUserBackendRoles(User user, boolean filterByEnabled) {
        if (filterByEnabled) {
            if (user == null) {
                return "Filter by user backend roles is enabled with security disabled.";
            }
            if (this.isAdmin(user)) {
                return "";
            }
            if (user.getBackendRoles().size() == 0) {
                return "User doesn't have backend roles configured. Contact administrator";
            }
        }
        return "";
    }

    default public boolean checkUserPermissionsWithResource(User requesterUser, User resourceUser, String resourceType, String resourceId, boolean filterByEnabled) {
        if (!this.doFilterForUser(requesterUser, filterByEnabled)) {
            return true;
        }
        List resourceBackendRoles = resourceUser.getBackendRoles();
        List requesterBackendRoles = requesterUser.getBackendRoles();
        return resourceBackendRoles != null && requesterBackendRoles != null && !this.isIntersectListsEmpty(resourceBackendRoles, requesterBackendRoles);
    }

    default public boolean isIntersectListsEmpty(List<String> a, List<String> b) {
        return a.stream().distinct().filter(b::contains).collect(Collectors.toSet()).size() == 0;
    }

    default public void addFilter(User user, SearchSourceBuilder searchSourceBuilder, String fieldName) {
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery().must(searchSourceBuilder.query());
        boolQueryBuilder.filter((QueryBuilder)QueryBuilders.nestedQuery((String)"detector", (QueryBuilder)QueryBuilders.termsQuery((String)fieldName, (Collection)user.getBackendRoles()), (ScoreMode)ScoreMode.Avg));
        searchSourceBuilder.query((QueryBuilder)boolQueryBuilder);
    }
}

