/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.action;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.opensearch.Version;
import org.opensearch.cluster.metadata.MappingMetadata;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.ParseField;
import org.opensearch.core.action.ActionResponse;
import org.opensearch.core.common.Strings;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;

public class GetIndexMappingsResponse
extends ActionResponse
implements ToXContentObject {
    private static final ParseField MAPPINGS = new ParseField("mappings", new String[0]);
    private final Map<String, MappingMetadata> mappings;

    public GetIndexMappingsResponse(Map<String, MappingMetadata> mappings) {
        this.mappings = mappings;
    }

    public GetIndexMappingsResponse(StreamInput in) throws IOException {
        super(in);
        int size = in.readVInt();
        HashMap<String, MappingMetadata> indexMapBuilder = new HashMap<String, MappingMetadata>();
        for (int i = 0; i < size; ++i) {
            String index = in.readString();
            if (in.getVersion().before(Version.V_2_0_0)) {
                int mappingCount = in.readVInt();
                if (mappingCount == 0) {
                    indexMapBuilder.put(index, MappingMetadata.EMPTY_MAPPINGS);
                    continue;
                }
                if (mappingCount == 1) {
                    String type = in.readString();
                    if (!"_doc".equals(type)) {
                        throw new IllegalStateException("Expected _doc but got [" + type + "]");
                    }
                    indexMapBuilder.put(index, new MappingMetadata(in));
                    continue;
                }
                throw new IllegalStateException("Expected 0 or 1 mappings but got: " + mappingCount);
            }
            boolean hasMapping = in.readBoolean();
            indexMapBuilder.put(index, hasMapping ? new MappingMetadata(in) : MappingMetadata.EMPTY_MAPPINGS);
        }
        this.mappings = Collections.unmodifiableMap(indexMapBuilder);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.mappings.size());
        for (Map.Entry<String, MappingMetadata> indexEntry : this.mappings.entrySet()) {
            out.writeString(indexEntry.getKey());
            if (out.getVersion().before(Version.V_2_0_0)) {
                out.writeVInt(indexEntry.getValue() == MappingMetadata.EMPTY_MAPPINGS ? 0 : 1);
                if (indexEntry.getValue() == MappingMetadata.EMPTY_MAPPINGS) continue;
                out.writeString("_doc");
                indexEntry.getValue().writeTo(out);
                continue;
            }
            out.writeOptionalWriteable((Writeable)indexEntry.getValue());
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        for (Map.Entry<String, MappingMetadata> indexEntry : this.getMappings().entrySet()) {
            builder.startObject(indexEntry.getKey());
            if (indexEntry.getValue() != null) {
                builder.field(MAPPINGS.getPreferredName(), indexEntry.getValue().sourceAsMap());
            } else {
                builder.startObject(MAPPINGS.getPreferredName()).endObject();
            }
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    public Map<String, MappingMetadata> mappings() {
        return this.mappings;
    }

    public Map<String, MappingMetadata> getMappings() {
        return this.mappings();
    }

    public String toString() {
        return Strings.toString((MediaType)XContentType.JSON, (ToXContent)this);
    }

    public int hashCode() {
        return this.mappings.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        GetIndexMappingsResponse other = (GetIndexMappingsResponse)((Object)obj);
        return this.mappings.equals(other.mappings);
    }
}

