/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.expression.function;

import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.data.type.ExprType;
import org.opensearch.sql.expression.Expression;
import org.opensearch.sql.expression.FunctionExpression;
import org.opensearch.sql.expression.NamedArgumentExpression;
import org.opensearch.sql.expression.env.Environment;
import org.opensearch.sql.expression.function.BuiltinFunctionName;
import org.opensearch.sql.expression.function.BuiltinFunctionRepository;
import org.opensearch.sql.expression.function.FunctionBuilder;
import org.opensearch.sql.expression.function.FunctionName;
import org.opensearch.sql.expression.function.FunctionResolver;
import org.opensearch.sql.expression.function.FunctionSignature;
import org.opensearch.sql.expression.function.RelevanceFunctionResolver;
import org.opensearch.sql.expression.function.SerializableFunction;

public final class OpenSearchFunctions {
    public static void register(BuiltinFunctionRepository repository) {
        repository.register(OpenSearchFunctions.match_bool_prefix());
        repository.register(OpenSearchFunctions.multi_match(BuiltinFunctionName.MULTI_MATCH));
        repository.register(OpenSearchFunctions.multi_match(BuiltinFunctionName.MULTIMATCH));
        repository.register(OpenSearchFunctions.multi_match(BuiltinFunctionName.MULTIMATCHQUERY));
        repository.register(OpenSearchFunctions.match(BuiltinFunctionName.MATCH));
        repository.register(OpenSearchFunctions.match(BuiltinFunctionName.MATCHQUERY));
        repository.register(OpenSearchFunctions.match(BuiltinFunctionName.MATCH_QUERY));
        repository.register(OpenSearchFunctions.simple_query_string());
        repository.register(OpenSearchFunctions.query());
        repository.register(OpenSearchFunctions.query_string());
        repository.register(OpenSearchFunctions.match_phrase(BuiltinFunctionName.MATCH_PHRASE));
        repository.register(OpenSearchFunctions.match_phrase(BuiltinFunctionName.MATCHPHRASE));
        repository.register(OpenSearchFunctions.match_phrase(BuiltinFunctionName.MATCHPHRASEQUERY));
        repository.register(OpenSearchFunctions.match_phrase_prefix());
        repository.register(OpenSearchFunctions.wildcard_query(BuiltinFunctionName.WILDCARD_QUERY));
        repository.register(OpenSearchFunctions.wildcard_query(BuiltinFunctionName.WILDCARDQUERY));
        repository.register(OpenSearchFunctions.score(BuiltinFunctionName.SCORE));
        repository.register(OpenSearchFunctions.score(BuiltinFunctionName.SCOREQUERY));
        repository.register(OpenSearchFunctions.score(BuiltinFunctionName.SCORE_QUERY));
        repository.register(OpenSearchFunctions.nested());
    }

    private static FunctionResolver match_bool_prefix() {
        FunctionName name = BuiltinFunctionName.MATCH_BOOL_PREFIX.getName();
        return new RelevanceFunctionResolver(name);
    }

    private static FunctionResolver match(BuiltinFunctionName match) {
        FunctionName funcName = match.getName();
        return new RelevanceFunctionResolver(funcName);
    }

    private static FunctionResolver match_phrase_prefix() {
        FunctionName funcName = BuiltinFunctionName.MATCH_PHRASE_PREFIX.getName();
        return new RelevanceFunctionResolver(funcName);
    }

    private static FunctionResolver match_phrase(BuiltinFunctionName matchPhrase) {
        FunctionName funcName = matchPhrase.getName();
        return new RelevanceFunctionResolver(funcName);
    }

    private static FunctionResolver multi_match(BuiltinFunctionName multiMatchName) {
        return new RelevanceFunctionResolver(multiMatchName.getName());
    }

    private static FunctionResolver simple_query_string() {
        FunctionName funcName = BuiltinFunctionName.SIMPLE_QUERY_STRING.getName();
        return new RelevanceFunctionResolver(funcName);
    }

    private static FunctionResolver query() {
        FunctionName funcName = BuiltinFunctionName.QUERY.getName();
        return new RelevanceFunctionResolver(funcName);
    }

    private static FunctionResolver query_string() {
        FunctionName funcName = BuiltinFunctionName.QUERY_STRING.getName();
        return new RelevanceFunctionResolver(funcName);
    }

    private static FunctionResolver wildcard_query(BuiltinFunctionName wildcardQuery) {
        FunctionName funcName = wildcardQuery.getName();
        return new RelevanceFunctionResolver(funcName);
    }

    private static FunctionResolver nested() {
        return new FunctionResolver(){

            @Override
            public Pair<FunctionSignature, FunctionBuilder> resolve(FunctionSignature unresolvedSignature) {
                return Pair.of((Object)unresolvedSignature, (functionProperties, arguments) -> new FunctionExpression(BuiltinFunctionName.NESTED.getName(), arguments){

                    @Override
                    public ExprValue valueOf(Environment<Expression, ExprValue> valueEnv) {
                        return valueEnv.resolve(this.getArguments().get(0));
                    }

                    @Override
                    public ExprType type() {
                        return this.getArguments().get(0).type();
                    }
                });
            }

            @Override
            public FunctionName getFunctionName() {
                return BuiltinFunctionName.NESTED.getName();
            }
        };
    }

    private static FunctionResolver score(BuiltinFunctionName score) {
        FunctionName funcName = score.getName();
        return new RelevanceFunctionResolver(funcName);
    }

    @Generated
    private OpenSearchFunctions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static class OpenSearchExecutableFunction
    extends FunctionExpression {
        private final FunctionName functionName;
        private final List<Expression> arguments;
        private final ExprType returnType;

        public OpenSearchExecutableFunction(FunctionName functionName, List<Expression> arguments, ExprType returnType) {
            super(functionName, arguments);
            this.functionName = functionName;
            this.arguments = arguments;
            this.returnType = returnType;
        }

        @Override
        public ExprValue valueOf(Environment<Expression, ExprValue> valueEnv) {
            throw new UnsupportedOperationException(String.format("OpenSearch defined function [%s] is only supported in Eval operation.", this.functionName));
        }

        @Override
        public ExprType type() {
            return this.returnType;
        }

        public static SerializableFunction<FunctionName, Pair<FunctionSignature, FunctionBuilder>> openSearchImpl(ExprType returnType, List<ExprType> args) {
            return functionName -> {
                FunctionSignature functionSignature = new FunctionSignature((FunctionName)functionName, args);
                FunctionBuilder functionBuilder = (functionProperties, arguments) -> new OpenSearchExecutableFunction((FunctionName)functionName, arguments, returnType);
                return Pair.of((Object)functionSignature, (Object)functionBuilder);
            };
        }
    }

    public static class OpenSearchFunction
    extends FunctionExpression {
        private final FunctionName functionName;
        private final List<Expression> arguments;
        private boolean isScoreTracked;

        public OpenSearchFunction(FunctionName functionName, List<Expression> arguments) {
            super(functionName, arguments);
            this.functionName = functionName;
            this.arguments = arguments;
            this.isScoreTracked = false;
        }

        @Override
        public ExprValue valueOf(Environment<Expression, ExprValue> valueEnv) {
            throw new UnsupportedOperationException(String.format("OpenSearch defined function [%s] is only supported in WHERE and HAVING clause.", this.functionName));
        }

        @Override
        public ExprType type() {
            return ExprCoreType.BOOLEAN;
        }

        @Override
        public String toString() {
            List args = this.arguments.stream().map(arg -> String.format("%s=%s", ((NamedArgumentExpression)arg).getArgName(), ((NamedArgumentExpression)arg).getValue().toString())).collect(Collectors.toList());
            return String.format("%s(%s)", this.functionName, String.join((CharSequence)", ", args));
        }

        @Generated
        public boolean isScoreTracked() {
            return this.isScoreTracked;
        }

        @Generated
        public void setScoreTracked(boolean isScoreTracked) {
            this.isScoreTracked = isScoreTracked;
        }
    }
}

