/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.ingest;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch.ingest.Processor;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class Pipeline
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, Pipeline> {
    @Nullable
    private final String description;
    @Nonnull
    private final Map<String, JsonData> meta;
    @Nonnull
    private final List<Processor> onFailure;
    @Nonnull
    private final List<Processor> processors;
    @Nullable
    private final Long version;
    public static final JsonpDeserializer<Pipeline> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Pipeline::setupPipelineDeserializer);

    private Pipeline(Builder builder) {
        this.description = builder.description;
        this.meta = ApiTypeHelper.unmodifiable(builder.meta);
        this.onFailure = ApiTypeHelper.unmodifiable(builder.onFailure);
        this.processors = ApiTypeHelper.unmodifiable(builder.processors);
        this.version = builder.version;
    }

    public static Pipeline of(Function<Builder, ObjectBuilder<Pipeline>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String description() {
        return this.description;
    }

    @Nonnull
    public final Map<String, JsonData> meta() {
        return this.meta;
    }

    @Nonnull
    public final List<Processor> onFailure() {
        return this.onFailure;
    }

    @Nonnull
    public final List<Processor> processors() {
        return this.processors;
    }

    @Nullable
    public final Long version() {
        return this.version;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.description != null) {
            generator.writeKey("description");
            generator.write(this.description);
        }
        if (ApiTypeHelper.isDefined(this.meta)) {
            generator.writeKey("_meta");
            generator.writeStartObject();
            for (Map.Entry entry : this.meta.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((JsonData)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.onFailure)) {
            generator.writeKey("on_failure");
            generator.writeStartArray();
            for (Processor processor : this.onFailure) {
                processor.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.processors)) {
            generator.writeKey("processors");
            generator.writeStartArray();
            for (Processor processor : this.processors) {
                processor.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.version != null) {
            generator.writeKey("version");
            generator.write(this.version.longValue());
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupPipelineDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::description, JsonpDeserializer.stringDeserializer(), "description");
        op.add(Builder::meta, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "_meta");
        op.add(Builder::onFailure, JsonpDeserializer.arrayDeserializer(Processor._DESERIALIZER), "on_failure");
        op.add(Builder::processors, JsonpDeserializer.arrayDeserializer(Processor._DESERIALIZER), "processors");
        op.add(Builder::version, JsonpDeserializer.longDeserializer(), "version");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.description);
        result = 31 * result + Objects.hashCode(this.meta);
        result = 31 * result + Objects.hashCode(this.onFailure);
        result = 31 * result + Objects.hashCode(this.processors);
        result = 31 * result + Objects.hashCode(this.version);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Pipeline other = (Pipeline)o;
        return Objects.equals(this.description, other.description) && Objects.equals(this.meta, other.meta) && Objects.equals(this.onFailure, other.onFailure) && Objects.equals(this.processors, other.processors) && Objects.equals(this.version, other.version);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, Pipeline> {
        @Nullable
        private String description;
        @Nullable
        private Map<String, JsonData> meta;
        @Nullable
        private List<Processor> onFailure;
        @Nullable
        private List<Processor> processors;
        @Nullable
        private Long version;

        public Builder() {
        }

        private Builder(Pipeline o) {
            this.description = o.description;
            this.meta = Builder._mapCopy(o.meta);
            this.onFailure = Builder._listCopy(o.onFailure);
            this.processors = Builder._listCopy(o.processors);
            this.version = o.version;
        }

        private Builder(Builder o) {
            this.description = o.description;
            this.meta = Builder._mapCopy(o.meta);
            this.onFailure = Builder._listCopy(o.onFailure);
            this.processors = Builder._listCopy(o.processors);
            this.version = o.version;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder description(@Nullable String value) {
            this.description = value;
            return this;
        }

        @Nonnull
        public final Builder meta(Map<String, JsonData> map) {
            this.meta = Builder._mapPutAll(this.meta, map);
            return this;
        }

        @Nonnull
        public final Builder meta(String key, JsonData value) {
            this.meta = Builder._mapPut(this.meta, key, value);
            return this;
        }

        @Nonnull
        public final Builder onFailure(List<Processor> list) {
            this.onFailure = Builder._listAddAll(this.onFailure, list);
            return this;
        }

        @Nonnull
        public final Builder onFailure(Processor value, Processor ... values) {
            this.onFailure = Builder._listAdd(this.onFailure, value, values);
            return this;
        }

        @Nonnull
        public final Builder onFailure(Function<Processor.Builder, ObjectBuilder<Processor>> fn) {
            return this.onFailure(fn.apply(new Processor.Builder()).build(), new Processor[0]);
        }

        @Nonnull
        public final Builder processors(List<Processor> list) {
            this.processors = Builder._listAddAll(this.processors, list);
            return this;
        }

        @Nonnull
        public final Builder processors(Processor value, Processor ... values) {
            this.processors = Builder._listAdd(this.processors, value, values);
            return this;
        }

        @Nonnull
        public final Builder processors(Function<Processor.Builder, ObjectBuilder<Processor>> fn) {
            return this.processors(fn.apply(new Processor.Builder()).build(), new Processor[0]);
        }

        @Nonnull
        public final Builder version(@Nullable Long value) {
            this.version = value;
            return this;
        }

        @Override
        @Nonnull
        public Pipeline build() {
            this._checkSingleUse();
            return new Pipeline(this);
        }
    }
}

