/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.util;

import java.io.File;
import java.io.Serializable;
import java.net.URI;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.ivy.core.settings.IvySettings;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkException;
import org.apache.spark.deploy.SparkSubmitUtils$;
import org.apache.spark.internal.Logging;
import org.apache.spark.util.IvyProperties;
import org.apache.spark.util.MutableURLClassLoader;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple5;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

public final class DependencyUtils$
implements Logging {
    public static final DependencyUtils$ MODULE$ = new DependencyUtils$();
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public IvyProperties getIvyProperties() {
        SeqOps seqOps;
        Seq seq = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{org.apache.spark.internal.config.package$.MODULE$.JAR_PACKAGES_EXCLUSIONS().key(), org.apache.spark.internal.config.package$.MODULE$.JAR_PACKAGES().key(), org.apache.spark.internal.config.package$.MODULE$.JAR_REPOSITORIES().key(), org.apache.spark.internal.config.package$.MODULE$.JAR_IVY_REPO_PATH().key(), org.apache.spark.internal.config.package$.MODULE$.JAR_IVY_SETTING_PATH().key()})).map((Function1 & Serializable)x$1 -> (String)scala.sys.package$.MODULE$.props().get(x$1).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        if (seq == null || SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Seq().unapplySeq((SeqOps)seq)) || new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) == null || SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 5) != 0) {
            throw new MatchError((Object)seq);
        }
        String packagesExclusions = (String)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
        String packages = (String)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
        String repositories = (String)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2);
        String ivyRepoPath = (String)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 3);
        String ivySettingsPath = (String)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 4);
        Tuple5 tuple5 = new Tuple5((Object)packagesExclusions, (Object)packages, (Object)repositories, (Object)ivyRepoPath, (Object)ivySettingsPath);
        Tuple5 tuple52 = tuple5;
        String packagesExclusions2 = (String)tuple52._1();
        String packages2 = (String)tuple52._2();
        String repositories2 = (String)tuple52._3();
        String ivyRepoPath2 = (String)tuple52._4();
        String ivySettingsPath2 = (String)tuple52._5();
        return new IvyProperties(packagesExclusions2, packages2, repositories2, ivyRepoPath2, ivySettingsPath2);
    }

    private boolean isInvalidQueryString(String[] tokens) {
        return tokens.length != 2 || StringUtils.isBlank((CharSequence)tokens[0]) || StringUtils.isBlank((CharSequence)tokens[1]);
    }

    private Tuple2<Object, String> parseQueryParams(URI uri) {
        Tuple2 tuple2;
        String uriQuery = uri.getQuery();
        if (uriQuery == null) {
            tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)"");
        } else {
            String[][] mapTokens = (String[][])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])uriQuery.split("&")), (Function1 & Serializable)x$3 -> x$3.split("="), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)));
            if (ArrayOps$.MODULE$.exists$extension(Predef$.MODULE$.refArrayOps((Object[])mapTokens), (Function1 & Serializable)tokens -> BoxesRunTime.boxToBoolean((boolean)DependencyUtils$.MODULE$.isInvalidQueryString(tokens)))) {
                throw new IllegalArgumentException(new StringBuilder(34).append("Invalid query string in Ivy URI ").append(uri.toString()).append(": ").append(uriQuery).toString());
            }
            Map groupedParams = ArrayOps$.MODULE$.groupBy$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])mapTokens), (Function1 & Serializable)kv -> new Tuple2((Object)kv[0], (Object)kv[1]), ClassTag$.MODULE$.apply(Tuple2.class))), (Function1 & Serializable)x$4 -> (String)x$4._1());
            Option transitiveParams = groupedParams.get((Object)"transitive");
            if (BoxesRunTime.unboxToInt((Object)transitiveParams.map((Function1 & Serializable)x$5 -> BoxesRunTime.boxToInteger((int)ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.refArrayOps((Object[])x$5)))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0)) > 1) {
                this.logWarning((Function0<String>)(Function0 & Serializable)() -> "It's best to specify `transitive` parameter in ivy URI query only once. If there are multiple `transitive` parameter, we will select the last one");
            }
            boolean transitive = BoxesRunTime.unboxToBoolean((Object)transitiveParams.flatMap((Function1 & Serializable)x$6 -> ArrayOps$.MODULE$.headOption$extension(Predef$.MODULE$.booleanArrayOps((boolean[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.takeRight$extension(Predef$.MODULE$.refArrayOps((Object[])x$6), 1)), (Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)DependencyUtils$.$anonfun$parseQueryParams$9(x$7)), (ClassTag)ClassTag$.MODULE$.Boolean())))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> true));
            String exclusionList = (String)groupedParams.get((Object)"exclude").map((Function1 & Serializable)params -> Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.flatMap$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])params), (Function1 & Serializable)x$8 -> (String)x$8._2(), ClassTag$.MODULE$.apply(String.class))), (Function1 & Serializable)excludeString -> {
                void var2_2;
                String[] excludes = excludeString.split(",");
                if (ArrayOps$.MODULE$.exists$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])excludes), (Function1 & Serializable)x$9 -> x$9.split(":"), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)))), (Function1 & Serializable)tokens -> BoxesRunTime.boxToBoolean((boolean)DependencyUtils$.MODULE$.isInvalidQueryString(tokens)))) {
                    throw new IllegalArgumentException(new StringBuilder(44).append(new StringBuilder(35).append("Invalid exclude string in Ivy URI ").append(uri.toString()).append(":").toString()).append(" expected 'org:module,org:module,..', found ").append((String)excludeString).toString());
                }
                return var2_2;
            }, (Function1 & Serializable)xs -> Predef$.MODULE$.wrapRefArray((Object[])xs), ClassTag$.MODULE$.apply(String.class))).mkString(",")).getOrElse((Function0 & Serializable)() -> "");
            Set validParams = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"transitive", "exclude"}));
            Seq invalidParams = ((IterableOnceOps)groupedParams.keys().filterNot((Function1 & Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)validParams.contains((Object)elem)))).toSeq();
            if (invalidParams.nonEmpty()) {
                this.logWarning((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(28).append("Invalid parameters `").append(((IterableOnceOps)invalidParams.sorted((Ordering)Ordering.String$.MODULE$)).mkString(",")).append("` found ").toString()).append(new StringBuilder(20).append("in Ivy URI query `").append(uriQuery).append("`.").toString()).toString());
            }
            tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)transitive), (Object)exclusionList);
        }
        return tuple2;
    }

    public Seq<String> resolveMavenDependencies(URI uri) {
        IvyProperties ivyProperties = this.getIvyProperties();
        String authority = uri.getAuthority();
        if (authority == null) {
            throw new IllegalArgumentException(new StringBuilder(43).append(new StringBuilder(34).append("Invalid Ivy URI authority in uri ").append(uri.toString()).append(":").toString()).append(" Expected 'org:module:version', found null.").toString());
        }
        if (authority.split(":").length != 3) {
            throw new IllegalArgumentException(new StringBuilder(0).append(new StringBuilder(34).append("Invalid Ivy URI authority in uri ").append(uri.toString()).append(":").toString()).append(new StringBuilder(39).append(" Expected 'org:module:version', found ").append(authority).append(".").toString()).toString());
        }
        Tuple2<Object, String> tuple2 = this.parseQueryParams(uri);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        boolean transitive = tuple2._1$mcZ$sp();
        String exclusionList = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)transitive), (Object)exclusionList);
        Tuple2 tuple23 = tuple22;
        boolean transitive2 = tuple23._1$mcZ$sp();
        String exclusionList2 = (String)tuple23._2();
        return this.resolveMavenDependencies(transitive2, exclusionList2, authority, ivyProperties.repositories(), ivyProperties.ivyRepoPath(), (Option<String>)Option$.MODULE$.apply((Object)ivyProperties.ivySettingsPath()));
    }

    public Seq<String> resolveMavenDependencies(boolean packagesTransitive, String packagesExclusions, String packages, String repositories, String ivyRepoPath, Option<String> ivySettingsPath) {
        IvySettings ivySettings;
        Nil$ exclusions = !StringUtils.isBlank((CharSequence)packagesExclusions) ? Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)packagesExclusions.split(",")) : package$.MODULE$.Nil();
        Option<String> option = ivySettingsPath;
        if (option instanceof Some) {
            Some some = (Some)option;
            String path = (String)some.value();
            ivySettings = SparkSubmitUtils$.MODULE$.loadIvySettings(path, (Option<String>)Option$.MODULE$.apply((Object)repositories), (Option<String>)Option$.MODULE$.apply((Object)ivyRepoPath));
        } else if (None$.MODULE$.equals(option)) {
            ivySettings = SparkSubmitUtils$.MODULE$.buildIvySettings((Option<String>)Option$.MODULE$.apply((Object)repositories), (Option<String>)Option$.MODULE$.apply((Object)ivyRepoPath), SparkSubmitUtils$.MODULE$.buildIvySettings$default$3());
        } else {
            throw new MatchError(option);
        }
        IvySettings ivySettings2 = ivySettings;
        String x$1 = packages;
        IvySettings x$2 = ivySettings2;
        boolean x$3 = packagesTransitive;
        Nil$ x$4 = exclusions;
        Option<IvySettings> x$5 = SparkSubmitUtils$.MODULE$.resolveMavenCoordinates$default$3();
        boolean x$6 = SparkSubmitUtils$.MODULE$.resolveMavenCoordinates$default$6();
        return SparkSubmitUtils$.MODULE$.resolveMavenCoordinates(x$1, x$2, x$5, x$3, (Seq<String>)x$4, x$6);
    }

    public String resolveAndDownloadJars(String jars, String userJar, SparkConf sparkConf, Configuration hadoopConf) {
        File targetDir = Utils$.MODULE$.createTempDir();
        String userJarName = (String)ArrayOps$.MODULE$.last$extension(Predef$.MODULE$.refArrayOps((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(userJar), File.separatorChar)));
        return (String)Option$.MODULE$.apply((Object)jars).map((Function1 & Serializable)x$11 -> Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.filterNot$extension(Predef$.MODULE$.refArrayOps((Object[])MODULE$.resolveGlobPaths((String)x$11, hadoopConf).split(",")), (Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)x$12.contains(userJarName)))).mkString(",")).filterNot((Function1 & Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)DependencyUtils$.$anonfun$resolveAndDownloadJars$3(x$13))).map((Function1 & Serializable)x$14 -> MODULE$.downloadFileList((String)x$14, targetDir, sparkConf, hadoopConf)).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public void addJarsToClassPath(String jars, MutableURLClassLoader loader) {
        block0: {
            if (jars == null) break block0;
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])jars.split(",")), (Function1 & Serializable)jar -> {
                DependencyUtils$.MODULE$.addJarToClasspath(jar, loader);
                return BoxedUnit.UNIT;
            });
        }
    }

    public String downloadFileList(String fileList, File targetDir, SparkConf sparkConf, Configuration hadoopConf) {
        Predef$.MODULE$.require(fileList != null, (Function0 & Serializable)() -> "fileList cannot be null.");
        return ((IterableOnceOps)Utils$.MODULE$.stringToSeq(fileList).map((Function1 & Serializable)x$15 -> MODULE$.downloadFile((String)x$15, targetDir, sparkConf, hadoopConf))).mkString(",");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String downloadFile(String path, File targetDir, SparkConf sparkConf, Configuration hadoopConf) {
        URI uri;
        block13: {
            Predef$.MODULE$.require(path != null, (Function0 & Serializable)() -> "path cannot be null.");
            uri = Utils$.MODULE$.resolveURI(path);
            String string = uri.getScheme();
            switch (string == null ? 0 : string.hashCode()) {
                case 101730: {
                    if ("ftp".equals(string)) {
                        break;
                    }
                    break block13;
                }
                case 3143036: {
                    if ("file".equals(string)) {
                        return path;
                    }
                    break block13;
                }
                case 3213448: {
                    if ("http".equals(string)) {
                        break;
                    }
                    break block13;
                }
                case 99617003: {
                    if ("https".equals(string)) {
                        break;
                    }
                    break block13;
                }
                case 103145323: {
                    if ("local".equals(string)) {
                        return path;
                    }
                    break block13;
                }
                default: {
                    break block13;
                }
            }
            if (Utils$.MODULE$.isTesting()) {
                File file = new File(uri.getPath());
                return new File(targetDir, file.getName()).toURI().toString();
            }
        }
        String fname = new Path(uri).getName();
        File localFile = Utils$.MODULE$.doFetchFile(uri.toString(), targetDir, fname, sparkConf, hadoopConf);
        return localFile.toURI().toString();
    }

    public String resolveGlobPaths(String paths, Configuration hadoopConf) {
        Predef$.MODULE$.require(paths != null, (Function0 & Serializable)() -> "paths cannot be null.");
        return ((IterableOnceOps)Utils$.MODULE$.stringToSeq(paths).flatMap((Function1 & Serializable)path -> {
            Tuple2<URI, Option<String>> tuple2 = MODULE$.splitOnFragment((String)path);
            if (tuple2 == null) throw new MatchError(tuple2);
            URI base = (URI)tuple2._1();
            Option fragment = (Option)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)base, (Object)fragment);
            Tuple2 tuple23 = tuple22;
            URI base2 = (URI)tuple23._1();
            Option fragment2 = (Option)tuple23._2();
            Tuple2 tuple24 = new Tuple2((Object)MODULE$.resolveGlobPath(base2, hadoopConf), (Object)fragment2);
            if (tuple24 != null) {
                String[] resolved = (String[])tuple24._1();
                Option option = (Option)tuple24._2();
                if (option instanceof Some && resolved.length > 1) {
                    throw new SparkException(new StringBuilder(41).append(base2.toString()).append(" resolves ambiguously to multiple files: ").append(Predef$.MODULE$.wrapRefArray((Object[])resolved).mkString(",")).toString());
                }
            }
            if (tuple24 != null) {
                String[] resolved = (String[])tuple24._1();
                Option option = (Option)tuple24._2();
                if (option instanceof Some) {
                    Some some = (Some)option;
                    String namedAs = (String)some.value();
                    return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])resolved), (Function1 & Serializable)x$17 -> new StringBuilder(1).append((String)x$17).append("#").append(namedAs).toString(), ClassTag$.MODULE$.apply(String.class)));
                }
            }
            if (tuple24 == null) throw new MatchError((Object)tuple24);
            String[] resolved = (String[])tuple24._1();
            return Predef$.MODULE$.wrapRefArray((Object[])resolved);
        })).mkString(",");
    }

    public void addJarToClasspath(String localJar, MutableURLClassLoader loader) {
        block9: {
            URI uri;
            block8: {
                uri = Utils$.MODULE$.resolveURI(localJar);
                String string = uri.getScheme();
                switch (string == null ? 0 : string.hashCode()) {
                    case 3143036: {
                        if ("file".equals(string)) {
                            break;
                        }
                        break block8;
                    }
                    case 103145323: {
                        if ("local".equals(string)) {
                            break;
                        }
                        break block8;
                    }
                    default: {
                        break block8;
                    }
                }
                File file = new File(uri.getPath());
                if (file.exists()) {
                    loader.addURL(file.toURI().toURL());
                } else {
                    this.logWarning((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(36).append("Local jar ").append(file).append(" does not exist, skipping.").toString());
                }
                break block9;
            }
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(17).append("Skip remote jar ").append(uri).append(".").toString());
        }
    }

    public String mergeFileLists(Seq<String> lists) {
        Seq merged = (Seq)((IterableOps)lists.filterNot((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)DependencyUtils$.$anonfun$mergeFileLists$1(x$1)))).flatMap((Function1 & Serializable)str -> Utils$.MODULE$.stringToSeq((String)str));
        return merged.nonEmpty() ? merged.mkString(",") : null;
    }

    private Tuple2<URI, Option<String>> splitOnFragment(String path) {
        URI uri = Utils$.MODULE$.resolveURI(path);
        URI withoutFragment = new URI(uri.getScheme(), uri.getSchemeSpecificPart(), null);
        return new Tuple2((Object)withoutFragment, (Object)Option$.MODULE$.apply((Object)uri.getFragment()));
    }

    private String[] resolveGlobPath(URI uri, Configuration hadoopConf) {
        String[] stringArray;
        block11: {
            block10: {
                String string = uri.getScheme();
                switch (string == null ? 0 : string.hashCode()) {
                    case 101730: {
                        if ("ftp".equals(string)) {
                            break;
                        }
                        break block10;
                    }
                    case 3213448: {
                        if ("http".equals(string)) {
                            break;
                        }
                        break block10;
                    }
                    case 99617003: {
                        if ("https".equals(string)) {
                            break;
                        }
                        break block10;
                    }
                    case 103145323: {
                        if ("local".equals(string)) {
                            break;
                        }
                        break block10;
                    }
                    default: {
                        break block10;
                    }
                }
                stringArray = (String[])((Object[])new String[]{uri.toString()});
                break block11;
            }
            FileSystem fs = FileSystem.get((URI)uri, (Configuration)hadoopConf);
            stringArray = (String[])Option$.MODULE$.apply((Object)fs.globStatus(new Path(uri))).map((Function1 & Serializable)status -> (String[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])status), (Function1 & Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)x$18.isFile()))), (Function1 & Serializable)x$19 -> x$19.getPath().toUri().toString(), ClassTag$.MODULE$.apply(String.class))).getOrElse((Function0 & Serializable)() -> (String[])((Object[])new String[]{uri.toString()}));
        }
        return stringArray;
    }

    public static final /* synthetic */ boolean $anonfun$parseQueryParams$9(Tuple2 x$7) {
        return ((String)x$7._2()).equalsIgnoreCase("true");
    }

    public static final /* synthetic */ boolean $anonfun$resolveAndDownloadJars$3(String x$13) {
        String string = x$13;
        String string2 = "";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$mergeFileLists$1(CharSequence x$1) {
        return StringUtils.isBlank((CharSequence)x$1);
    }

    private DependencyUtils$() {
    }
}

