/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema.output;

import com.networknt.schema.ExecutionContext;
import com.networknt.schema.JsonNodePath;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.ValidationContext;
import com.networknt.schema.ValidationMessage;
import com.networknt.schema.output.OutputUnit;
import com.networknt.schema.output.OutputUnitData;
import com.networknt.schema.output.OutputUnitKey;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class HierarchicalOutputUnitFormatter {
    public static OutputUnit format(JsonSchema jsonSchema, Set<ValidationMessage> validationMessages, ExecutionContext executionContext, ValidationContext validationContext) {
        String schemaLocation;
        String instanceLocation;
        OutputUnit unit;
        OutputUnitKey key;
        OutputUnit root = new OutputUnit();
        root.setValid(validationMessages.isEmpty());
        root.setInstanceLocation(validationContext.getConfig().getPathType().getRoot());
        root.setEvaluationPath(validationContext.getConfig().getPathType().getRoot());
        root.setSchemaLocation(jsonSchema.getSchemaLocation().toString());
        OutputUnitData data = OutputUnitData.from(validationMessages, executionContext);
        Map<OutputUnitKey, Boolean> valid = data.getValid();
        Map<OutputUnitKey, Map<String, Object>> errors = data.getErrors();
        Map<OutputUnitKey, Map<String, Object>> annotations = data.getAnnotations();
        Map<OutputUnitKey, Map<String, Object>> droppedAnnotations = data.getDroppedAnnotations();
        LinkedHashMap index = new LinkedHashMap();
        LinkedHashMap<JsonNodePath, OutputUnit> r = new LinkedHashMap<JsonNodePath, OutputUnit>();
        r.put(new JsonNodePath(validationContext.getConfig().getPathType()), root);
        index.put(new JsonNodePath(validationContext.getConfig().getPathType()), r);
        LinkedHashMap keys = new LinkedHashMap();
        errors.keySet().stream().forEach(k -> keys.computeIfAbsent(k.getEvaluationPath(), a -> new LinkedHashSet()).add(k.getInstanceLocation()));
        annotations.keySet().stream().forEach(k -> keys.computeIfAbsent(k.getEvaluationPath(), a -> new LinkedHashSet()).add(k.getInstanceLocation()));
        droppedAnnotations.keySet().stream().forEach(k -> keys.computeIfAbsent(k.getEvaluationPath(), a -> new LinkedHashSet()).add(k.getInstanceLocation()));
        errors.keySet().stream().forEach(k -> HierarchicalOutputUnitFormatter.buildIndex(k, index, keys, root));
        annotations.keySet().stream().forEach(k -> HierarchicalOutputUnitFormatter.buildIndex(k, index, keys, root));
        droppedAnnotations.keySet().stream().forEach(k -> HierarchicalOutputUnitFormatter.buildIndex(k, index, keys, root));
        for (Map.Entry<OutputUnitKey, Map<String, Object>> error : errors.entrySet()) {
            key = error.getKey();
            unit = (OutputUnit)((Map)index.get(key.getEvaluationPath())).get(key.getInstanceLocation());
            unit.setInstanceLocation(key.getInstanceLocation().toString());
            unit.setSchemaLocation(key.getSchemaLocation().toString());
            unit.setValid(false);
            unit.setErrors(error.getValue());
        }
        for (Map.Entry<OutputUnitKey, Map<String, Object>> annotation : annotations.entrySet()) {
            key = annotation.getKey();
            unit = (OutputUnit)((Map)index.get(key.getEvaluationPath())).get(key.getInstanceLocation());
            instanceLocation = key.getInstanceLocation().toString();
            schemaLocation = key.getSchemaLocation().toString();
            if (unit.getInstanceLocation() != null && !unit.getInstanceLocation().equals(instanceLocation)) {
                throw new IllegalArgumentException();
            }
            if (unit.getSchemaLocation() != null && !unit.getSchemaLocation().equals(schemaLocation)) {
                throw new IllegalArgumentException();
            }
            unit.setInstanceLocation(instanceLocation);
            unit.setSchemaLocation(schemaLocation);
            unit.setAnnotations(annotation.getValue());
            unit.setValid(valid.get(key));
        }
        for (Map.Entry<OutputUnitKey, Map<String, Object>> droppedAnnotation : droppedAnnotations.entrySet()) {
            key = droppedAnnotation.getKey();
            unit = (OutputUnit)((Map)index.get(key.getEvaluationPath())).get(key.getInstanceLocation());
            instanceLocation = key.getInstanceLocation().toString();
            schemaLocation = key.getSchemaLocation().toString();
            if (unit.getInstanceLocation() != null && !unit.getInstanceLocation().equals(instanceLocation)) {
                throw new IllegalArgumentException();
            }
            if (unit.getSchemaLocation() != null && !unit.getSchemaLocation().equals(schemaLocation)) {
                throw new IllegalArgumentException();
            }
            unit.setInstanceLocation(instanceLocation);
            unit.setSchemaLocation(schemaLocation);
            unit.setDroppedAnnotations(droppedAnnotation.getValue());
            unit.setValid(valid.get(key));
        }
        return root;
    }

    protected static void buildIndex(OutputUnitKey key, Map<JsonNodePath, Map<JsonNodePath, OutputUnit>> index, Map<JsonNodePath, Set<JsonNodePath>> keys, OutputUnit root) {
        if (index.containsKey(key.getEvaluationPath())) {
            return;
        }
        ArrayDeque<JsonNodePath> stack = new ArrayDeque<JsonNodePath>();
        for (JsonNodePath path = key.getEvaluationPath(); path != null && path.getElement(-1) != null; path = path.getParent()) {
            stack.push(path);
        }
        OutputUnit parent = root;
        block1: while (!stack.isEmpty()) {
            Map<JsonNodePath, OutputUnit> result;
            JsonNodePath current = (JsonNodePath)stack.pop();
            if (!index.containsKey(current) && keys.containsKey(current)) {
                for (JsonNodePath instanceLocation : keys.get(current)) {
                    OutputUnit child = new OutputUnit();
                    child.setValid(true);
                    child.setEvaluationPath(current.toString());
                    child.setInstanceLocation(instanceLocation.toString());
                    index.computeIfAbsent(current, n -> new LinkedHashMap()).put(instanceLocation, child);
                    if (parent.getDetails() == null) {
                        parent.setDetails(new ArrayList<OutputUnit>());
                    }
                    parent.getDetails().add(child);
                }
            }
            if ((result = index.get(current)) == null) continue;
            for (Map.Entry<JsonNodePath, OutputUnit> entry : result.entrySet()) {
                if (!key.getInstanceLocation().startsWith(entry.getKey())) continue;
                parent = entry.getValue();
                continue block1;
            }
        }
    }
}

