/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.action.mcpserver;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchException;
import org.opensearch.action.FailedNodeException;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.nodes.TransportNodesAction;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.ml.action.mcpserver.McpAsyncServerHolder;
import org.opensearch.ml.action.mcpserver.McpToolsHelper;
import org.opensearch.ml.common.transport.mcpserver.requests.McpToolBaseInput;
import org.opensearch.ml.common.transport.mcpserver.requests.update.MLMcpToolsUpdateNodeRequest;
import org.opensearch.ml.common.transport.mcpserver.requests.update.MLMcpToolsUpdateNodesRequest;
import org.opensearch.ml.common.transport.mcpserver.requests.update.McpToolUpdateInput;
import org.opensearch.ml.common.transport.mcpserver.responses.update.MLMcpToolsUpdateNodeResponse;
import org.opensearch.ml.common.transport.mcpserver.responses.update.MLMcpToolsUpdateNodesResponse;
import org.opensearch.ml.rest.mcpserver.ToolFactoryWrapper;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportService;
import org.opensearch.transport.client.Client;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class TransportMcpToolsUpdateOnNodesAction
extends TransportNodesAction<MLMcpToolsUpdateNodesRequest, MLMcpToolsUpdateNodesResponse, MLMcpToolsUpdateNodeRequest, MLMcpToolsUpdateNodeResponse> {
    @Generated
    private static final Logger log = LogManager.getLogger(TransportMcpToolsUpdateOnNodesAction.class);
    TransportService transportService;
    ClusterService clusterService;
    ThreadPool threadPool;
    Client client;
    NamedXContentRegistry xContentRegistry;
    ToolFactoryWrapper toolFactoryWrapper;
    McpToolsHelper mcpToolsHelper;

    @Inject
    public TransportMcpToolsUpdateOnNodesAction(TransportService transportService, ActionFilters actionFilters, ClusterService clusterService, ThreadPool threadPool, Client client, NamedXContentRegistry xContentRegistry, ToolFactoryWrapper toolFactoryWrapper, McpToolsHelper mcpToolsHelper) {
        super("cluster:admin/opensearch/ml/mcp_tools/update_on_nodes", threadPool, clusterService, transportService, actionFilters, MLMcpToolsUpdateNodesRequest::new, MLMcpToolsUpdateNodeRequest::new, "management", MLMcpToolsUpdateNodeResponse.class);
        this.transportService = transportService;
        this.clusterService = clusterService;
        this.threadPool = threadPool;
        this.client = client;
        this.xContentRegistry = xContentRegistry;
        this.toolFactoryWrapper = toolFactoryWrapper;
        this.mcpToolsHelper = mcpToolsHelper;
    }

    protected MLMcpToolsUpdateNodesResponse newResponse(MLMcpToolsUpdateNodesRequest nodesRequest, List<MLMcpToolsUpdateNodeResponse> responses, List<FailedNodeException> failures) {
        return new MLMcpToolsUpdateNodesResponse(this.clusterService.getClusterName(), responses, failures);
    }

    protected MLMcpToolsUpdateNodeRequest newNodeRequest(MLMcpToolsUpdateNodesRequest request) {
        return new MLMcpToolsUpdateNodeRequest(request.getMcpTools());
    }

    protected MLMcpToolsUpdateNodeResponse newNodeResponse(StreamInput in) throws IOException {
        return new MLMcpToolsUpdateNodeResponse(in);
    }

    protected MLMcpToolsUpdateNodeResponse nodeOperation(MLMcpToolsUpdateNodeRequest request) {
        return this.updateToolsOnNode(request.getMcpTools());
    }

    private MLMcpToolsUpdateNodeResponse updateToolsOnNode(List<McpToolUpdateInput> mcpTools) {
        AtomicReference exception = new AtomicReference();
        Flux.fromStream(mcpTools.stream()).flatMap(tool -> {
            McpAsyncServerHolder.IN_MEMORY_MCP_TOOLS.remove(tool.getName());
            McpAsyncServerHolder.getMcpAsyncServerInstance().removeTool(tool.getName()).onErrorResume(e -> Mono.empty()).subscribe();
            return McpAsyncServerHolder.getMcpAsyncServerInstance().addTool(this.mcpToolsHelper.createToolSpecification((McpToolBaseInput)tool)).doOnSuccess(x -> McpAsyncServerHolder.IN_MEMORY_MCP_TOOLS.put(tool.getName(), tool.getVersion()));
        }).doOnError(e -> {
            log.error("Failed to Update tools: {} in MCP server memory on node: {}", mcpTools.stream().map(McpToolBaseInput::getName).toList(), (Object)this.clusterService.localNode().getId());
            exception.set(e);
        }).doOnComplete(() -> log.debug("Successfully Update tools on node: {}", (Object)this.clusterService.localNode().getId())).subscribe();
        if (exception.get() != null) {
            String errorMsg = ((Throwable)exception.get()).getMessage();
            throw new FailedNodeException(this.clusterService.localNode().getId(), errorMsg, (Throwable)new OpenSearchException(errorMsg, new Object[0]));
        }
        return new MLMcpToolsUpdateNodeResponse(this.clusterService.localNode(), Boolean.valueOf(true));
    }
}

