/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.searchrelevance.transport.searchConfiguration;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.searchrelevance.dao.SearchConfigurationDao;
import org.opensearch.searchrelevance.exception.SearchRelevanceException;
import org.opensearch.searchrelevance.transport.OpenSearchDocRequest;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

public class GetSearchConfigurationTransportAction
extends HandledTransportAction<OpenSearchDocRequest, SearchResponse> {
    private static final Logger LOGGER = LogManager.getLogger(GetSearchConfigurationTransportAction.class);
    private final ClusterService clusterService;
    private final SearchConfigurationDao searchConfigurationDao;

    @Inject
    public GetSearchConfigurationTransportAction(ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, SearchConfigurationDao searchConfigurationDao) {
        super("cluster:admin/opensearch/search_relevance/search_configuration/get", transportService, actionFilters, OpenSearchDocRequest::new);
        this.clusterService = clusterService;
        this.searchConfigurationDao = searchConfigurationDao;
    }

    protected void doExecute(Task task, OpenSearchDocRequest request, ActionListener<SearchResponse> listener) {
        try {
            if (request.getId() != null) {
                this.searchConfigurationDao.getSearchConfiguration(request.getId(), listener);
            } else {
                this.searchConfigurationDao.listSearchConfiguration(request.getSearchSourceBuilder(), listener);
            }
        }
        catch (Exception e) {
            listener.onFailure((Exception)((Object)new SearchRelevanceException("Failed to get/list SearchConfiguration", e, RestStatus.INTERNAL_SERVER_ERROR)));
        }
    }
}

