/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.searchrelevance.rest;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ExceptionsHelper;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;
import org.opensearch.searchrelevance.common.MLConstants;
import org.opensearch.searchrelevance.exception.SearchRelevanceException;
import org.opensearch.searchrelevance.model.JudgmentType;
import org.opensearch.searchrelevance.settings.SearchRelevanceSettingsAccessor;
import org.opensearch.searchrelevance.transport.judgment.PutImportJudgmentRequest;
import org.opensearch.searchrelevance.transport.judgment.PutJudgmentAction;
import org.opensearch.searchrelevance.transport.judgment.PutJudgmentRequest;
import org.opensearch.searchrelevance.transport.judgment.PutLlmJudgmentRequest;
import org.opensearch.searchrelevance.transport.judgment.PutUbiJudgmentRequest;
import org.opensearch.searchrelevance.utils.DateValidationUtil;
import org.opensearch.searchrelevance.utils.ParserUtils;
import org.opensearch.searchrelevance.utils.TextValidationUtil;
import org.opensearch.transport.client.node.NodeClient;

public class RestPutJudgmentAction
extends BaseRestHandler {
    private static final Logger LOGGER = LogManager.getLogger(RestPutJudgmentAction.class);
    private static final String PUT_JUDGMENT_ACTION = "put_judgment_action";
    private SearchRelevanceSettingsAccessor settingsAccessor;

    public String getName() {
        return PUT_JUDGMENT_ACTION;
    }

    public List<RestHandler.Route> routes() {
        return Collections.singletonList(new RestHandler.Route(RestRequest.Method.PUT, "/_plugins/_search_relevance/judgments"));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        PutJudgmentRequest createRequest;
        JudgmentType type;
        TextValidationUtil.ValidationResult descriptionValidation;
        if (!this.settingsAccessor.isWorkbenchEnabled()) {
            return channel -> channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.FORBIDDEN, "Search Relevance Workbench is disabled"));
        }
        XContentParser parser = request.contentParser();
        Map source = parser.map();
        String name = (String)source.get("name");
        TextValidationUtil.ValidationResult nameValidation = TextValidationUtil.validateName(name);
        if (!nameValidation.isValid()) {
            return channel -> channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.BAD_REQUEST, "Invalid name: " + nameValidation.getErrorMessage()));
        }
        String description = (String)source.get("description");
        if (description != null && !(descriptionValidation = TextValidationUtil.validateDescription(description)).isValid()) {
            return channel -> channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.BAD_REQUEST, "Invalid description: " + descriptionValidation.getErrorMessage()));
        }
        String typeString = (String)source.get("type");
        try {
            type = JudgmentType.valueOf(typeString);
        }
        catch (IllegalArgumentException | NullPointerException e) {
            throw new IllegalArgumentException("Invalid or missing judgment type", e);
        }
        switch (type) {
            case LLM_JUDGMENT: {
                String modelId = (String)source.get("modelId");
                if (modelId == null) {
                    throw new SearchRelevanceException("modelId is required for LLM_JUDGMENT", RestStatus.BAD_REQUEST);
                }
                String querySetId = (String)source.get("querySetId");
                List<String> searchConfigurationList = ParserUtils.convertObjToList(source, "searchConfigurationList");
                int size = (Integer)source.get("size");
                boolean ignoreFailure = Optional.ofNullable((Boolean)source.get("ignoreFailure")).orElse(Boolean.FALSE);
                int tokenLimit = MLConstants.validateTokenLimit(source);
                List<String> contextFields = ParserUtils.convertObjToList(source, "contextFields");
                createRequest = new PutLlmJudgmentRequest(type, name, description, modelId, querySetId, searchConfigurationList, size, tokenLimit, contextFields, ignoreFailure);
                break;
            }
            case UBI_JUDGMENT: {
                String clickModel = (String)source.get("clickModel");
                int maxRank = (Integer)source.get("maxRank");
                String startDate = source.getOrDefault("startDate", "");
                String endDate = source.getOrDefault("endDate", "");
                DateValidationUtil.DateValidationResult validStart = DateValidationUtil.validateDate(startDate);
                DateValidationUtil.DateValidationResult validEnd = DateValidationUtil.validateDate(endDate);
                if (!validStart.isValid()) {
                    return channel -> channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.BAD_REQUEST, "Invalid start date format: " + validStart.getErrorMessage()));
                }
                if (!validEnd.isValid()) {
                    return channel -> channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.BAD_REQUEST, "Invalid end date format: " + validEnd.getErrorMessage()));
                }
                createRequest = new PutUbiJudgmentRequest(type, name, description, clickModel, maxRank, startDate, endDate);
                break;
            }
            case IMPORT_JUDGMENT: {
                List judgmentRatings = (List)source.get("judgmentRatings");
                createRequest = new PutImportJudgmentRequest(type, name, description, judgmentRatings);
                break;
            }
            default: {
                throw new SearchRelevanceException("Unsupported experiment type: " + String.valueOf((Object)type), RestStatus.BAD_REQUEST);
            }
        }
        return channel -> client.execute((ActionType)PutJudgmentAction.INSTANCE, (ActionRequest)createRequest, (ActionListener)new ActionListener<IndexResponse>(){

            public void onResponse(IndexResponse response) {
                try {
                    XContentBuilder builder = channel.newBuilder();
                    builder.startObject();
                    builder.field("judgment_id", response.getId());
                    builder.endObject();
                    channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.OK, builder));
                }
                catch (IOException e) {
                    this.onFailure(e);
                }
            }

            public void onFailure(Exception e) {
                try {
                    channel.sendResponse((RestResponse)new BytesRestResponse(channel, ExceptionsHelper.status((Throwable)e), e));
                }
                catch (IOException ex) {
                    LOGGER.error("Failed to send error response", (Throwable)ex);
                }
            }
        });
    }

    @Generated
    public RestPutJudgmentAction(SearchRelevanceSettingsAccessor settingsAccessor) {
        this.settingsAccessor = settingsAccessor;
    }
}

