/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.searchrelevance.executors;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.core.action.ActionListener;
import org.opensearch.searchrelevance.model.JudgmentBatchStatus;
import org.opensearch.searchrelevance.model.SearchConfiguration;

public class JudgmentTaskContext {
    @Generated
    private static final Logger log = LogManager.getLogger(JudgmentTaskContext.class);
    private final String queryTextWithReference;
    private final String modelId;
    private final List<String> contextFields;
    private final List<SearchConfiguration> searchConfigurations;
    private final boolean ignoreFailure;
    private final ConcurrentMap<String, String> docIdToScore;
    private final AtomicInteger pendingSearchTasks;
    private final AtomicInteger pendingCacheTasks;
    private final AtomicInteger successfulTasks;
    private final AtomicInteger failedTasks;
    private final AtomicBoolean hasTerminated;
    private final List<Future<?>> pendingTasks;
    private volatile boolean cancelled;
    private ActionListener<Map<String, String>> completionListener;

    public JudgmentTaskContext(String queryTextWithReference, String modelId, List<String> contextFields, List<SearchConfiguration> searchConfigurations, boolean ignoreFailure, ActionListener<Map<String, String>> completionListener) {
        this.queryTextWithReference = queryTextWithReference;
        this.modelId = modelId;
        this.contextFields = contextFields;
        this.searchConfigurations = searchConfigurations;
        this.ignoreFailure = ignoreFailure;
        this.completionListener = completionListener;
        this.docIdToScore = new ConcurrentHashMap<String, String>();
        this.pendingSearchTasks = new AtomicInteger(searchConfigurations.size());
        this.pendingCacheTasks = new AtomicInteger(0);
        this.successfulTasks = new AtomicInteger(0);
        this.failedTasks = new AtomicInteger(0);
        this.hasTerminated = new AtomicBoolean(false);
        this.pendingTasks = new CopyOnWriteArrayList();
        this.cancelled = false;
        log.info("JudgmentTaskContext initialized for query: {} with {} search configurations", (Object)queryTextWithReference, (Object)searchConfigurations.size());
    }

    public void setPendingCacheTasks(int count) {
        this.pendingCacheTasks.set(count);
    }

    public void completeSearchTask(boolean success) {
        if (this.hasTerminated.get()) {
            return;
        }
        if (success) {
            this.successfulTasks.incrementAndGet();
        } else {
            this.failedTasks.incrementAndGet();
            log.warn("Search task failed for query: {} (ignoreFailure={})", (Object)this.queryTextWithReference, (Object)this.ignoreFailure);
        }
        if (this.pendingSearchTasks.decrementAndGet() == 0) {
            log.debug("All search tasks completed for query: {}", (Object)this.queryTextWithReference);
        }
    }

    public void completeCacheTask(boolean success) {
        if (this.hasTerminated.get()) {
            return;
        }
        if (success) {
            this.successfulTasks.incrementAndGet();
        } else {
            this.failedTasks.incrementAndGet();
            log.warn("Cache task failed for query: {} (ignoreFailure={})", (Object)this.queryTextWithReference, (Object)this.ignoreFailure);
        }
        if (this.pendingCacheTasks.decrementAndGet() == 0) {
            log.debug("All cache tasks completed for query: {}", (Object)this.queryTextWithReference);
        }
    }

    public boolean isAllTasksCompleted() {
        return this.hasTerminated.get() || this.pendingSearchTasks.get() == 0 && this.pendingCacheTasks.get() == 0;
    }

    public void completeJudgment() {
        if (this.hasTerminated.get()) {
            return;
        }
        JudgmentBatchStatus status = this.determineStatus();
        log.info("Judgment completed for query: {} with {} ratings (success: {}, failed: {}, status: {})", (Object)this.queryTextWithReference, (Object)this.docIdToScore.size(), (Object)this.successfulTasks.get(), (Object)this.failedTasks.get(), (Object)status);
        if (this.completionListener != null) {
            this.completionListener.onResponse(this.docIdToScore);
        }
    }

    private JudgmentBatchStatus determineStatus() {
        if (this.hasTerminated.get() && !this.ignoreFailure) {
            return JudgmentBatchStatus.TERMINATED;
        }
        int completedTasks = this.successfulTasks.get() + this.failedTasks.get();
        if (completedTasks == 0) {
            return JudgmentBatchStatus.SUCCESS;
        }
        if (this.failedTasks.get() == completedTasks) {
            return JudgmentBatchStatus.ALL_FAILED;
        }
        if (this.failedTasks.get() > 0) {
            return JudgmentBatchStatus.PARTIAL_SUCCESS;
        }
        return JudgmentBatchStatus.SUCCESS;
    }

    public JudgmentBatchStatus getStatus() {
        return this.determineStatus();
    }

    public void failJudgment(Exception e) {
        if (this.hasTerminated.getAndSet(true)) {
            return;
        }
        log.error("Judgment failed for query: {} (ignoreFailure={})", (Object)this.queryTextWithReference, (Object)this.ignoreFailure, (Object)e);
        if (this.completionListener != null) {
            this.completionListener.onFailure(e);
        }
    }

    @Generated
    public String getQueryTextWithReference() {
        return this.queryTextWithReference;
    }

    @Generated
    public String getModelId() {
        return this.modelId;
    }

    @Generated
    public List<String> getContextFields() {
        return this.contextFields;
    }

    @Generated
    public List<SearchConfiguration> getSearchConfigurations() {
        return this.searchConfigurations;
    }

    @Generated
    public boolean isIgnoreFailure() {
        return this.ignoreFailure;
    }

    @Generated
    public ConcurrentMap<String, String> getDocIdToScore() {
        return this.docIdToScore;
    }

    @Generated
    public AtomicInteger getPendingSearchTasks() {
        return this.pendingSearchTasks;
    }

    @Generated
    public AtomicInteger getPendingCacheTasks() {
        return this.pendingCacheTasks;
    }

    @Generated
    public AtomicInteger getSuccessfulTasks() {
        return this.successfulTasks;
    }

    @Generated
    public AtomicInteger getFailedTasks() {
        return this.failedTasks;
    }

    @Generated
    public AtomicBoolean getHasTerminated() {
        return this.hasTerminated;
    }

    @Generated
    public List<Future<?>> getPendingTasks() {
        return this.pendingTasks;
    }

    @Generated
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Generated
    public ActionListener<Map<String, String>> getCompletionListener() {
        return this.completionListener;
    }
}

