/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.pipeline;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.UnicodeUtil;
import org.opensearch.ExceptionsHelper;
import org.opensearch.OpenSearchParseException;
import org.opensearch.ResourceNotFoundException;
import org.opensearch.action.search.DeleteSearchPipelineRequest;
import org.opensearch.action.search.PutSearchPipelineRequest;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.support.clustermanager.AcknowledgedResponse;
import org.opensearch.cluster.AckedClusterStateUpdateTask;
import org.opensearch.cluster.ClusterChangedEvent;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.ClusterStateApplier;
import org.opensearch.cluster.ack.AckedRequest;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.metadata.Metadata;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.cluster.service.ClusterManagerTask;
import org.opensearch.cluster.service.ClusterManagerTaskThrottler;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.metrics.OperationMetrics;
import org.opensearch.common.regex.Regex;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.io.stream.NamedWriteableRegistry;
import org.opensearch.core.index.Index;
import org.opensearch.core.service.ReportingService;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.env.Environment;
import org.opensearch.gateway.GatewayService;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.index.IndexSettings;
import org.opensearch.index.analysis.AnalysisRegistry;
import org.opensearch.ingest.ConfigurationUtils;
import org.opensearch.plugins.SearchPipelinePlugin;
import org.opensearch.script.ScriptService;
import org.opensearch.search.pipeline.Pipeline;
import org.opensearch.search.pipeline.PipelineConfiguration;
import org.opensearch.search.pipeline.PipelineProcessingContext;
import org.opensearch.search.pipeline.PipelineWithMetrics;
import org.opensearch.search.pipeline.PipelinedRequest;
import org.opensearch.search.pipeline.Processor;
import org.opensearch.search.pipeline.ProcessorInfo;
import org.opensearch.search.pipeline.SearchPhaseResultsProcessor;
import org.opensearch.search.pipeline.SearchPipelineInfo;
import org.opensearch.search.pipeline.SearchPipelineMetadata;
import org.opensearch.search.pipeline.SearchPipelineProcessingException;
import org.opensearch.search.pipeline.SearchPipelineStats;
import org.opensearch.search.pipeline.SearchRequestProcessor;
import org.opensearch.search.pipeline.SearchResponseProcessor;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.client.Client;

public class SearchPipelineService
implements ClusterStateApplier,
ReportingService<SearchPipelineInfo> {
    public static final String SEARCH_PIPELINE_ORIGIN = "search_pipeline";
    public static final String AD_HOC_PIPELINE_ID = "_ad_hoc_pipeline";
    public static final String NOOP_PIPELINE_ID = "_none";
    private static final int MAX_PIPELINE_ID_BYTES = 512;
    private static final Logger logger = LogManager.getLogger(SearchPipelineService.class);
    private final ClusterService clusterService;
    private final ScriptService scriptService;
    private final Map<String, Processor.Factory<SearchRequestProcessor>> requestProcessorFactories;
    private final Map<String, Processor.Factory<SearchResponseProcessor>> responseProcessorFactories;
    private final Map<String, Processor.Factory<SearchPhaseResultsProcessor>> phaseInjectorProcessorFactories;
    private volatile Map<String, PipelineHolder> pipelines = Collections.emptyMap();
    private final ThreadPool threadPool;
    private final List<Consumer<ClusterState>> searchPipelineClusterStateListeners = new CopyOnWriteArrayList<Consumer<ClusterState>>();
    private final ClusterManagerTaskThrottler.ThrottlingKey putPipelineTaskKey;
    private final ClusterManagerTaskThrottler.ThrottlingKey deletePipelineTaskKey;
    private final NamedWriteableRegistry namedWriteableRegistry;
    private volatile ClusterState state;
    private final OperationMetrics totalRequestProcessingMetrics = new OperationMetrics();
    private final OperationMetrics totalResponseProcessingMetrics = new OperationMetrics();

    public SearchPipelineService(ClusterService clusterService, ThreadPool threadPool, Environment env, ScriptService scriptService, AnalysisRegistry analysisRegistry, NamedXContentRegistry namedXContentRegistry, NamedWriteableRegistry namedWriteableRegistry, List<SearchPipelinePlugin> searchPipelinePlugins, Client client) {
        this.clusterService = clusterService;
        this.scriptService = scriptService;
        this.threadPool = threadPool;
        this.namedWriteableRegistry = namedWriteableRegistry;
        SearchPipelinePlugin.Parameters parameters = new SearchPipelinePlugin.Parameters(env, scriptService, analysisRegistry, threadPool.getThreadContext(), threadPool::relativeTimeInMillis, (delay, command) -> threadPool.schedule((Runnable)command, TimeValue.timeValueMillis((long)delay), "generic"), this, client, threadPool.generic()::execute, namedXContentRegistry);
        this.requestProcessorFactories = SearchPipelineService.processorFactories(searchPipelinePlugins, p -> p.getRequestProcessors(parameters));
        this.responseProcessorFactories = SearchPipelineService.processorFactories(searchPipelinePlugins, p -> p.getResponseProcessors(parameters));
        this.phaseInjectorProcessorFactories = SearchPipelineService.processorFactories(searchPipelinePlugins, p -> p.getSearchPhaseResultsProcessors(parameters));
        this.putPipelineTaskKey = clusterService.registerClusterManagerTask(ClusterManagerTask.PUT_SEARCH_PIPELINE, true);
        this.deletePipelineTaskKey = clusterService.registerClusterManagerTask(ClusterManagerTask.DELETE_SEARCH_PIPELINE, true);
    }

    private static <T extends Processor> Map<String, Processor.Factory<T>> processorFactories(List<SearchPipelinePlugin> searchPipelinePlugins, Function<SearchPipelinePlugin, Map<String, Processor.Factory<T>>> processorLoader) {
        HashMap<String, Processor.Factory<T>> processorFactories = new HashMap<String, Processor.Factory<T>>();
        for (SearchPipelinePlugin searchPipelinePlugin : searchPipelinePlugins) {
            Map<String, Processor.Factory<T>> newProcessors = processorLoader.apply(searchPipelinePlugin);
            for (Map.Entry<String, Processor.Factory<T>> entry : newProcessors.entrySet()) {
                if (processorFactories.put(entry.getKey(), entry.getValue()) == null) continue;
                throw new IllegalArgumentException("Search processor [" + entry.getKey() + "] is already registered");
            }
        }
        return Collections.unmodifiableMap(processorFactories);
    }

    @Override
    public void applyClusterState(ClusterChangedEvent event) {
        this.state = event.state();
        if (this.state.blocks().hasGlobalBlock(GatewayService.STATE_NOT_RECOVERED_BLOCK)) {
            return;
        }
        this.searchPipelineClusterStateListeners.forEach(consumer -> consumer.accept(this.state));
        SearchPipelineMetadata newSearchPipelineMetadata = (SearchPipelineMetadata)this.state.getMetadata().custom(SEARCH_PIPELINE_ORIGIN);
        if (newSearchPipelineMetadata == null) {
            return;
        }
        try {
            this.innerUpdatePipelines(newSearchPipelineMetadata);
        }
        catch (OpenSearchParseException e) {
            logger.warn("failed to update search pipelines", (Throwable)e);
        }
    }

    void innerUpdatePipelines(SearchPipelineMetadata newSearchPipelineMetadata) {
        Map<String, PipelineHolder> existingPipelines = this.pipelines;
        HashMap<String, PipelineHolder> newPipelines = null;
        ArrayList<OpenSearchParseException> exceptions = null;
        for (PipelineConfiguration pipelineConfiguration : newSearchPipelineMetadata.getPipelines().values()) {
            PipelineHolder previous = existingPipelines.get(pipelineConfiguration.getId());
            if (previous != null && previous.configuration.equals(pipelineConfiguration)) continue;
            if (newPipelines == null) {
                newPipelines = new HashMap<String, PipelineHolder>(existingPipelines);
            }
            try {
                PipelineWithMetrics newPipeline = PipelineWithMetrics.create(pipelineConfiguration.getId(), pipelineConfiguration.getConfigAsMap(), this.requestProcessorFactories, this.responseProcessorFactories, this.phaseInjectorProcessorFactories, this.namedWriteableRegistry, this.totalRequestProcessingMetrics, this.totalResponseProcessingMetrics, new Processor.PipelineContext(Processor.PipelineSource.UPDATE_PIPELINE));
                newPipelines.put(pipelineConfiguration.getId(), new PipelineHolder(pipelineConfiguration, newPipeline));
                if (previous == null) continue;
                newPipeline.copyMetrics(previous.pipeline);
            }
            catch (Exception e) {
                OpenSearchParseException parseException = new OpenSearchParseException("Error updating pipeline with id [" + pipelineConfiguration.getId() + "]", (Throwable)e, new Object[0]);
                if (exceptions == null) {
                    exceptions = new ArrayList<OpenSearchParseException>();
                }
                exceptions.add(parseException);
            }
        }
        for (Map.Entry entry : existingPipelines.entrySet()) {
            if (newSearchPipelineMetadata.getPipelines().get(entry.getKey()) != null) continue;
            if (newPipelines == null) {
                newPipelines = new HashMap<String, PipelineHolder>(existingPipelines);
            }
            newPipelines.remove(entry.getKey());
        }
        if (newPipelines != null) {
            this.pipelines = Collections.unmodifiableMap(newPipelines);
            if (exceptions != null) {
                ExceptionsHelper.rethrowAndSuppress(exceptions);
            }
        }
    }

    public void putPipeline(Map<DiscoveryNode, SearchPipelineInfo> searchPipelineInfos, final PutSearchPipelineRequest request, ActionListener<AcknowledgedResponse> listener) throws Exception {
        this.validatePipeline(searchPipelineInfos, request);
        this.clusterService.submitStateUpdateTask("put-search-pipeline-" + request.getId(), new AckedClusterStateUpdateTask<AcknowledgedResponse>(this, (AckedRequest)request, listener){
            final /* synthetic */ SearchPipelineService this$0;
            {
                this.this$0 = this$0;
                super(request2, listener);
            }

            @Override
            public ClusterState execute(ClusterState currentState) {
                return SearchPipelineService.innerPut(request, currentState);
            }

            @Override
            public ClusterManagerTaskThrottler.ThrottlingKey getClusterManagerThrottlingKey() {
                return this.this$0.putPipelineTaskKey;
            }

            @Override
            protected AcknowledgedResponse newResponse(boolean acknowledged) {
                return new AcknowledgedResponse(acknowledged);
            }
        });
    }

    static ClusterState innerPut(PutSearchPipelineRequest request, ClusterState currentState) {
        SearchPipelineMetadata currentSearchPipelineMetadata = (SearchPipelineMetadata)currentState.metadata().custom(SEARCH_PIPELINE_ORIGIN);
        HashMap<String, PipelineConfiguration> pipelines = currentSearchPipelineMetadata != null ? new HashMap<String, PipelineConfiguration>(currentSearchPipelineMetadata.getPipelines()) : new HashMap<String, PipelineConfiguration>();
        pipelines.put(request.getId(), new PipelineConfiguration(request.getId(), request.getSource(), request.getMediaType()));
        ClusterState.Builder newState = ClusterState.builder(currentState);
        newState.metadata(Metadata.builder(currentState.getMetadata()).putCustom(SEARCH_PIPELINE_ORIGIN, new SearchPipelineMetadata(pipelines)).build());
        return newState.build();
    }

    void validatePipeline(Map<DiscoveryNode, SearchPipelineInfo> searchPipelineInfos, PutSearchPipelineRequest request) throws Exception {
        if (searchPipelineInfos.isEmpty()) {
            throw new IllegalStateException("Search pipeline info is empty");
        }
        int pipelineIdLength = UnicodeUtil.calcUTF16toUTF8Length((CharSequence)request.getId(), (int)0, (int)request.getId().length());
        if (pipelineIdLength > 512) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Search Pipeline id [%s] exceeds maximum length of %d UTF-8 bytes (actual: %d bytes)", request.getId(), 512, pipelineIdLength));
        }
        Map pipelineConfig = (Map)XContentHelper.convertToMap(request.getSource(), false, request.getMediaType()).v2();
        PipelineWithMetrics pipeline = PipelineWithMetrics.create(request.getId(), pipelineConfig, this.requestProcessorFactories, this.responseProcessorFactories, this.phaseInjectorProcessorFactories, this.namedWriteableRegistry, new OperationMetrics(), new OperationMetrics(), new Processor.PipelineContext(Processor.PipelineSource.VALIDATE_PIPELINE));
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        this.validateProcessors(searchPipelineInfos, exceptions, "request_processors", pipeline.getSearchRequestProcessors());
        this.validateProcessors(searchPipelineInfos, exceptions, "response_processors", pipeline.getSearchResponseProcessors());
        this.validateProcessors(searchPipelineInfos, exceptions, "phase_results_processors", pipeline.getSearchPhaseResultsProcessors());
        ExceptionsHelper.rethrowAndSuppress(exceptions);
    }

    private void validateProcessors(Map<DiscoveryNode, SearchPipelineInfo> searchPipelineInfos, List<Exception> exceptions, String processorKey, List<? extends Processor> processors) {
        for (Processor processor : processors) {
            for (Map.Entry<DiscoveryNode, SearchPipelineInfo> entry : searchPipelineInfos.entrySet()) {
                String type = processor.getType();
                if (entry.getValue().containsProcessor(processorKey, type)) continue;
                String message = "Processor type [" + processor.getType() + "] is not installed on node [" + String.valueOf(entry.getKey()) + "]";
                exceptions.add((Exception)((Object)ConfigurationUtils.newConfigurationException(processor.getType(), processor.getTag(), null, message)));
            }
        }
    }

    public void deletePipeline(final DeleteSearchPipelineRequest request, ActionListener<AcknowledgedResponse> listener) throws Exception {
        this.clusterService.submitStateUpdateTask("delete-search-pipeline-" + request.getId(), new AckedClusterStateUpdateTask<AcknowledgedResponse>(this, (AckedRequest)request, listener){
            final /* synthetic */ SearchPipelineService this$0;
            {
                this.this$0 = this$0;
                super(request2, listener);
            }

            @Override
            public ClusterState execute(ClusterState currentState) {
                return SearchPipelineService.innerDelete(request, currentState);
            }

            @Override
            public ClusterManagerTaskThrottler.ThrottlingKey getClusterManagerThrottlingKey() {
                return this.this$0.deletePipelineTaskKey;
            }

            @Override
            protected AcknowledgedResponse newResponse(boolean acknowledged) {
                return new AcknowledgedResponse(acknowledged);
            }
        });
    }

    static ClusterState innerDelete(DeleteSearchPipelineRequest request, ClusterState currentState) {
        SearchPipelineMetadata currentMetadata = (SearchPipelineMetadata)currentState.metadata().custom(SEARCH_PIPELINE_ORIGIN);
        if (currentMetadata == null) {
            return currentState;
        }
        Map<String, PipelineConfiguration> pipelines = currentMetadata.getPipelines();
        HashSet<String> toRemove = new HashSet<String>();
        for (String string : pipelines.keySet()) {
            if (!Regex.simpleMatch(request.getId(), string)) continue;
            toRemove.add(string);
        }
        if (toRemove.isEmpty()) {
            if (Regex.isMatchAllPattern(request.getId())) {
                return currentState;
            }
            throw new ResourceNotFoundException("pipeline [{}] is missing", request.getId());
        }
        HashMap<String, PipelineConfiguration> newPipelines = new HashMap<String, PipelineConfiguration>(pipelines);
        for (String key : toRemove) {
            newPipelines.remove(key);
        }
        ClusterState.Builder builder = ClusterState.builder(currentState);
        builder.metadata(Metadata.builder(currentState.getMetadata()).putCustom(SEARCH_PIPELINE_ORIGIN, new SearchPipelineMetadata(newPipelines)));
        return builder.build();
    }

    public PipelinedRequest resolvePipeline(SearchRequest searchRequest, IndexNameExpressionResolver indexNameExpressionResolver) {
        Pipeline pipeline = Pipeline.NO_OP_PIPELINE;
        if (searchRequest.source() != null && searchRequest.source().searchPipelineSource() != null) {
            if (searchRequest.pipeline() != null) {
                throw new IllegalArgumentException("Both named and inline search pipeline were specified. Please only specify one or the other.");
            }
            try {
                pipeline = PipelineWithMetrics.create(AD_HOC_PIPELINE_ID, searchRequest.source().searchPipelineSource(), this.requestProcessorFactories, this.responseProcessorFactories, this.phaseInjectorProcessorFactories, this.namedWriteableRegistry, this.totalRequestProcessingMetrics, this.totalResponseProcessingMetrics, new Processor.PipelineContext(Processor.PipelineSource.SEARCH_REQUEST));
            }
            catch (Exception e) {
                throw new SearchPipelineProcessingException(e);
            }
        }
        String pipelineId = NOOP_PIPELINE_ID;
        if (searchRequest.pipeline() != null) {
            pipelineId = searchRequest.pipeline();
        } else if (this.state != null && searchRequest.indices() != null && searchRequest.indices().length != 0) {
            try {
                Index[] concreteIndices;
                for (Index index : concreteIndices = indexNameExpressionResolver.concreteIndices(this.state, searchRequest)) {
                    Settings indexSettings;
                    IndexMetadata indexMetadata = this.state.metadata().index(index);
                    if (indexMetadata == null || !IndexSettings.DEFAULT_SEARCH_PIPELINE.exists(indexSettings = indexMetadata.getSettings())) continue;
                    String currentPipelineId = IndexSettings.DEFAULT_SEARCH_PIPELINE.get(indexSettings);
                    if (NOOP_PIPELINE_ID.equals(pipelineId)) {
                        pipelineId = currentPipelineId;
                        continue;
                    }
                    if (pipelineId.equals(currentPipelineId)) continue;
                    pipelineId = NOOP_PIPELINE_ID;
                    break;
                }
            }
            catch (IndexNotFoundException e) {
                logger.debug("Default pipeline not applied for {}", (Object)searchRequest.indices());
            }
        }
        if (!NOOP_PIPELINE_ID.equals(pipelineId)) {
            PipelineHolder pipelineHolder = this.pipelines.get(pipelineId);
            if (pipelineHolder == null) {
                throw new IllegalArgumentException("Pipeline " + pipelineId + " is not defined");
            }
            pipeline = pipelineHolder.pipeline;
        }
        if (searchRequest.source() != null && searchRequest.source().verbosePipeline().booleanValue() && pipeline.equals(Pipeline.NO_OP_PIPELINE)) {
            throw new IllegalArgumentException("The 'verbose pipeline' option requires a search pipeline to be defined.");
        }
        PipelineProcessingContext requestContext = new PipelineProcessingContext();
        return new PipelinedRequest(pipeline, searchRequest, requestContext);
    }

    Map<String, Processor.Factory<SearchRequestProcessor>> getRequestProcessorFactories() {
        return this.requestProcessorFactories;
    }

    Map<String, Processor.Factory<SearchResponseProcessor>> getResponseProcessorFactories() {
        return this.responseProcessorFactories;
    }

    Map<String, Processor.Factory<SearchPhaseResultsProcessor>> getSearchPhaseResultsProcessorFactories() {
        return this.phaseInjectorProcessorFactories;
    }

    public SearchPipelineInfo info() {
        List requestProcessorInfoList = this.requestProcessorFactories.keySet().stream().map(ProcessorInfo::new).collect(Collectors.toList());
        List responseProcessorInfoList = this.responseProcessorFactories.keySet().stream().map(ProcessorInfo::new).collect(Collectors.toList());
        List phaseProcessorInfoList = this.phaseInjectorProcessorFactories.keySet().stream().map(ProcessorInfo::new).collect(Collectors.toList());
        return new SearchPipelineInfo(Map.of("request_processors", requestProcessorInfoList, "response_processors", responseProcessorInfoList, "phase_results_processors", phaseProcessorInfoList));
    }

    public SearchPipelineStats stats() {
        SearchPipelineStats.Builder builder = new SearchPipelineStats.Builder();
        builder.withTotalStats(this.totalRequestProcessingMetrics, this.totalResponseProcessingMetrics);
        for (PipelineHolder pipelineHolder : this.pipelines.values()) {
            PipelineWithMetrics pipeline = pipelineHolder.pipeline;
            pipeline.populateStats(builder);
        }
        return builder.build();
    }

    public static List<PipelineConfiguration> getPipelines(ClusterState clusterState, String ... ids) {
        SearchPipelineMetadata metadata = (SearchPipelineMetadata)clusterState.getMetadata().custom(SEARCH_PIPELINE_ORIGIN);
        return SearchPipelineService.innerGetPipelines(metadata, ids);
    }

    static List<PipelineConfiguration> innerGetPipelines(SearchPipelineMetadata metadata, String ... ids) {
        if (metadata == null) {
            return Collections.emptyList();
        }
        if (ids.length == 0) {
            return new ArrayList<PipelineConfiguration>(metadata.getPipelines().values());
        }
        ArrayList<PipelineConfiguration> result = new ArrayList<PipelineConfiguration>(ids.length);
        for (String id : ids) {
            if (Regex.isSimpleMatchPattern(id)) {
                for (Map.Entry<String, PipelineConfiguration> entry : metadata.getPipelines().entrySet()) {
                    if (!Regex.simpleMatch(id, entry.getKey())) continue;
                    result.add(entry.getValue());
                }
                continue;
            }
            PipelineConfiguration pipeline = metadata.getPipelines().get(id);
            if (pipeline == null) continue;
            result.add(pipeline);
        }
        return result;
    }

    public ClusterService getClusterService() {
        return this.clusterService;
    }

    Map<String, PipelineHolder> getPipelines() {
        return this.pipelines;
    }

    static class PipelineHolder {
        final PipelineConfiguration configuration;
        final PipelineWithMetrics pipeline;

        PipelineHolder(PipelineConfiguration configuration, PipelineWithMetrics pipeline) {
            this.configuration = Objects.requireNonNull(configuration);
            this.pipeline = Objects.requireNonNull(pipeline);
        }
    }
}

