/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.codec;

import java.util.Map;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.codecs.lucene101.Lucene101Codec;
import org.opensearch.common.Nullable;
import org.opensearch.common.collect.MapBuilder;
import org.opensearch.index.IndexSettings;
import org.opensearch.index.codec.PerFieldMappingPostingFormatCodec;
import org.opensearch.index.codec.composite.CompositeCodecFactory;
import org.opensearch.index.mapper.MapperService;

public class CodecService {
    private final Map<String, Codec> codecs;
    public static final String DEFAULT_CODEC = "default";
    public static final String LZ4 = "lz4";
    public static final String BEST_COMPRESSION_CODEC = "best_compression";
    public static final String ZLIB = "zlib";
    public static final String LUCENE_DEFAULT_CODEC = "lucene_default";
    private final CompositeCodecFactory compositeCodecFactory = new CompositeCodecFactory();

    public CodecService(@Nullable MapperService mapperService, IndexSettings indexSettings, Logger logger) {
        MapBuilder codecs = MapBuilder.newMapBuilder();
        assert (null != indexSettings);
        if (mapperService == null) {
            codecs.put((Object)DEFAULT_CODEC, (Object)new Lucene101Codec());
            codecs.put((Object)LZ4, (Object)new Lucene101Codec());
            codecs.put((Object)BEST_COMPRESSION_CODEC, (Object)new Lucene101Codec(Lucene101Codec.Mode.BEST_COMPRESSION));
            codecs.put((Object)ZLIB, (Object)new Lucene101Codec(Lucene101Codec.Mode.BEST_COMPRESSION));
        } else if (mapperService.isCompositeIndexPresent()) {
            codecs.putAll(this.compositeCodecFactory.getCompositeIndexCodecs(mapperService, logger));
        } else {
            codecs.put((Object)DEFAULT_CODEC, (Object)new PerFieldMappingPostingFormatCodec(Lucene101Codec.Mode.BEST_SPEED, mapperService, logger));
            codecs.put((Object)LZ4, (Object)new PerFieldMappingPostingFormatCodec(Lucene101Codec.Mode.BEST_SPEED, mapperService, logger));
            codecs.put((Object)BEST_COMPRESSION_CODEC, (Object)new PerFieldMappingPostingFormatCodec(Lucene101Codec.Mode.BEST_COMPRESSION, mapperService, logger));
            codecs.put((Object)ZLIB, (Object)new PerFieldMappingPostingFormatCodec(Lucene101Codec.Mode.BEST_COMPRESSION, mapperService, logger));
        }
        codecs.put((Object)LUCENE_DEFAULT_CODEC, (Object)Codec.getDefault());
        for (String codec : Codec.availableCodecs()) {
            codecs.put((Object)codec, (Object)Codec.forName((String)codec));
        }
        this.codecs = codecs.immutableMap();
    }

    public final Codec defaultCodec() {
        return this.codecs.get(DEFAULT_CODEC);
    }

    public Codec codec(String name) {
        Codec codec = this.codecs.get(name);
        if (codec == null) {
            throw new IllegalArgumentException("failed to find codec [" + name + "]");
        }
        return codec;
    }

    public String[] availableCodecs() {
        return this.codecs.keySet().toArray(new String[0]);
    }
}

