/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.materialproviders.model;

import java.util.Objects;
import software.amazon.cryptography.primitives.model.ECDSASignatureAlgorithm;

public class ECDSA {
    private final ECDSASignatureAlgorithm curve;

    protected ECDSA(BuilderImpl builder) {
        this.curve = builder.curve();
    }

    public ECDSASignatureAlgorithm curve() {
        return this.curve;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected ECDSASignatureAlgorithm curve;

        protected BuilderImpl() {
        }

        protected BuilderImpl(ECDSA model) {
            this.curve = model.curve();
        }

        @Override
        public Builder curve(ECDSASignatureAlgorithm curve) {
            this.curve = curve;
            return this;
        }

        @Override
        public ECDSASignatureAlgorithm curve() {
            return this.curve;
        }

        @Override
        public ECDSA build() {
            if (Objects.isNull((Object)this.curve())) {
                throw new IllegalArgumentException("Missing value for required field `curve`");
            }
            return new ECDSA(this);
        }
    }

    public static interface Builder {
        public Builder curve(ECDSASignatureAlgorithm var1);

        public ECDSASignatureAlgorithm curve();

        public ECDSA build();
    }
}

