/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.editor.contentassist.antlr;

import java.util.Iterator;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;

public class LeafNodeFinder {
    private final int offset;
    private final boolean leading;

    public LeafNodeFinder(int offset, boolean leading) {
        this.offset = offset;
        this.leading = leading;
    }

    public ILeafNode searchIn(INode node) {
        if (node instanceof ICompositeNode) {
            return this.caseCompositeNode((ICompositeNode)node);
        }
        return this.caseLeafNode((ILeafNode)node);
    }

    public ILeafNode caseCompositeNode(ICompositeNode object) {
        if (this.matchesSearchCriteria((INode)object)) {
            return this.searchInChildren(object);
        }
        return null;
    }

    protected boolean matchesSearchCriteria(INode object) {
        if (this.leading ? object.getTotalOffset() < this.offset && object.getTotalLength() + object.getTotalOffset() >= this.offset : object.getTotalOffset() <= this.offset && object.getTotalLength() + object.getTotalOffset() > this.offset) {
            return true;
        }
        return object.getTotalOffset() == this.offset && object.getTotalLength() == 0;
    }

    protected ILeafNode searchInChildren(ICompositeNode object) {
        Iterator leafNodes = object.getLeafNodes().iterator();
        ILeafNode result = null;
        while (leafNodes.hasNext()) {
            result = (ILeafNode)leafNodes.next();
            if (this.matchesSearchCriteria((INode)result)) break;
        }
        while (leafNodes.hasNext()) {
            ILeafNode next = (ILeafNode)leafNodes.next();
            if (!this.matchesSearchCriteria((INode)next)) break;
            result = next;
        }
        return result;
    }

    public ILeafNode caseLeafNode(ILeafNode object) {
        if (this.matchesSearchCriteria((INode)object)) {
            return object;
        }
        return null;
    }
}

