/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.model.message.control;

import java.net.URL;
import org.jupnp.model.action.ActionInvocation;
import org.jupnp.model.action.RemoteActionInvocation;
import org.jupnp.model.message.StreamRequestMessage;
import org.jupnp.model.message.UpnpRequest;
import org.jupnp.model.message.control.ActionRequestMessage;
import org.jupnp.model.message.header.ContentTypeHeader;
import org.jupnp.model.message.header.SoapActionHeader;
import org.jupnp.model.message.header.UpnpHeader;
import org.jupnp.model.message.header.UserAgentHeader;
import org.jupnp.model.meta.Action;
import org.jupnp.model.meta.QueryStateVariableAction;
import org.jupnp.model.meta.Service;
import org.jupnp.model.types.SoapActionType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutgoingActionRequestMessage
extends StreamRequestMessage
implements ActionRequestMessage {
    private final Logger logger = LoggerFactory.getLogger(OutgoingActionRequestMessage.class);
    private final String actionNamespace;

    public OutgoingActionRequestMessage(ActionInvocation actionInvocation, URL controlURL) {
        this(actionInvocation.getAction(), new UpnpRequest(UpnpRequest.Method.POST, controlURL));
        if (actionInvocation instanceof RemoteActionInvocation) {
            RemoteActionInvocation remoteActionInvocation = (RemoteActionInvocation)actionInvocation;
            if (remoteActionInvocation.getRemoteClientInfo() != null && remoteActionInvocation.getRemoteClientInfo().getRequestUserAgent() != null) {
                this.getHeaders().add(UpnpHeader.Type.USER_AGENT, new UserAgentHeader(remoteActionInvocation.getRemoteClientInfo().getRequestUserAgent()));
            }
        } else if (actionInvocation.getClientInfo() != null) {
            this.getHeaders().putAll(actionInvocation.getClientInfo().getRequestHeaders());
        }
    }

    public OutgoingActionRequestMessage(Action action, UpnpRequest operation) {
        super(operation);
        SoapActionHeader soapActionHeader;
        this.getHeaders().add(UpnpHeader.Type.CONTENT_TYPE, new ContentTypeHeader(ContentTypeHeader.DEFAULT_CONTENT_TYPE_UTF8));
        if (action instanceof QueryStateVariableAction) {
            this.logger.trace("Adding magic control SOAP action header for state variable query action");
            soapActionHeader = new SoapActionHeader(new SoapActionType("schemas-upnp-org", "control-1-0", null, action.getName()));
        } else {
            soapActionHeader = new SoapActionHeader(new SoapActionType(((Service)action.getService()).getServiceType(), action.getName()));
        }
        this.actionNamespace = ((SoapActionType)soapActionHeader.getValue()).getTypeString();
        if (!((UpnpRequest)this.getOperation()).getMethod().equals((Object)UpnpRequest.Method.POST)) {
            throw new IllegalArgumentException("Can't send action with request method: " + String.valueOf((Object)((UpnpRequest)this.getOperation()).getMethod()));
        }
        this.getHeaders().add(UpnpHeader.Type.SOAPACTION, soapActionHeader);
        this.logger.trace("Added SOAP action header: {}", (Object)soapActionHeader);
    }

    @Override
    public String getActionNamespace() {
        return this.actionNamespace;
    }
}

