/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.internal.i18n;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.openhab.core.common.osgi.ResourceBundleClassLoader;
import org.openhab.core.i18n.LocaleProvider;
import org.osgi.framework.Bundle;

public class LanguageResourceBundleManager {
    protected static final String RESOURCE_DIRECTORY = "/OH-INF/i18n";
    private static final String RESOURCE_FILE_PATTERN = "*.properties";
    private LocaleProvider localeProvider;
    private Bundle bundle;
    private ClassLoader resourceClassLoader;
    private List<String> resourceNames;

    public LanguageResourceBundleManager(LocaleProvider localeProvider, Bundle bundle) {
        if (bundle == null) {
            throw new IllegalArgumentException("The Bundle must not be null!");
        }
        this.localeProvider = localeProvider;
        this.bundle = bundle;
        this.resourceClassLoader = new ResourceBundleClassLoader(bundle, RESOURCE_DIRECTORY, RESOURCE_FILE_PATTERN);
        this.resourceNames = this.determineResourceNames();
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    public void clearCache() {
        ResourceBundle.clearCache(this.resourceClassLoader);
    }

    public boolean containsResource(String resource) {
        if (resource != null) {
            return this.resourceNames.contains(resource);
        }
        return false;
    }

    public boolean containsResources() {
        return !this.resourceNames.isEmpty();
    }

    private List<String> determineResourceNames() {
        ArrayList<String> resourceNames = new ArrayList<String>();
        Enumeration resourceFiles = this.bundle.findEntries(RESOURCE_DIRECTORY, RESOURCE_FILE_PATTERN, true);
        if (resourceFiles != null) {
            while (resourceFiles.hasMoreElements()) {
                URL resourceURL = (URL)resourceFiles.nextElement();
                String resourcePath = resourceURL.getFile();
                File resourceFile = new File(resourcePath);
                String resourceFileName = resourceFile.getName();
                String baseName = resourceFileName.replaceFirst("[._]+.*", "");
                if (resourceNames.contains(baseName)) continue;
                resourceNames.add(baseName);
            }
        }
        return resourceNames;
    }

    public String getText(String resource, String key, Locale locale) {
        if (key != null && !key.isEmpty()) {
            Locale effectiveLocale;
            Locale locale2 = effectiveLocale = locale != null ? locale : this.localeProvider.getLocale();
            if (resource != null) {
                return this.getTranslatedText(resource, key, effectiveLocale);
            }
            for (String resourceName : this.resourceNames) {
                String text = this.getTranslatedText(resourceName, key, effectiveLocale);
                if (text == null) continue;
                return text;
            }
        }
        return null;
    }

    public String getText(String key, Locale locale) {
        return this.getText(null, key, locale);
    }

    private String getTranslatedText(String resourceName, String key, Locale locale) {
        try {
            ResourceBundle resourceBundle = ResourceBundle.getBundle(resourceName, locale, this.resourceClassLoader, ResourceBundle.Control.getNoFallbackControl(ResourceBundle.Control.FORMAT_PROPERTIES));
            return resourceBundle.getString(key);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

