/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.nodes.input;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.regex.tregex.nodes.input.InputReadNodeGen;
import com.oracle.truffle.regex.tregex.string.Encodings;

@GenerateUncached
@GenerateInline
@ImportStatic(value={Encodings.class})
public abstract class InputReadNode
extends Node {
    public abstract int execute(Node var1, TruffleString var2, int var3, Encodings.Encoding var4);

    @Specialization(guards={"encoding != UTF_16", "encoding != UTF_32", "encoding != UTF_16_RAW"})
    static int doTStringUTF8(TruffleString input, int index, Encodings.Encoding encoding, @Cached(inline=false) TruffleString.ReadByteNode readRawNode) {
        return readRawNode.execute((AbstractTruffleString)input, index, encoding.getTStringEncoding());
    }

    @Specialization(guards={"encoding == UTF_16 || encoding == UTF_16_RAW"})
    static int doTStringUTF16(TruffleString input, int index, Encodings.Encoding encoding, @Cached(inline=false) TruffleString.ReadCharUTF16Node readRawNode) {
        return readRawNode.execute((AbstractTruffleString)input, index);
    }

    @Specialization(guards={"encoding == UTF_32"})
    static int doTStringUTF32(TruffleString input, int index, Encodings.Encoding encoding, @Cached(inline=false) TruffleString.CodePointAtIndexNode readRawNode) {
        return readRawNode.execute((AbstractTruffleString)input, index, TruffleString.Encoding.UTF_32);
    }

    @NeverDefault
    public static InputReadNode create() {
        return InputReadNodeGen.create();
    }
}

