/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javaee.project.api;

import java.util.ArrayList;
import java.util.Collection;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.whitelist.WhiteListQuery;
import org.netbeans.api.whitelist.index.WhiteListIndex;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.InstanceRemovedException;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.javaee.project.api.Bundle;
import org.netbeans.modules.javaee.project.api.JavaEEProjectSettings;
import org.netbeans.spi.project.SubprojectProvider;
import org.netbeans.spi.whitelist.WhiteListQueryImplementation;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.RequestProcessor;

public abstract class WhiteListUpdater {
    private static final RequestProcessor rp = new RequestProcessor();
    protected Project project;
    private String lastWhiteList;

    public WhiteListUpdater(Project project) {
        this.project = project;
        this.addSettingListener();
    }

    protected abstract void addSettingListener();

    protected void updateWhitelist(final String oldWhiteListId, final String newWhiteListId) {
        rp.post(new Runnable(){

            @Override
            public void run() {
                WhiteListUpdater.this.updateWhitelist(WhiteListUpdater.this.project, oldWhiteListId, newWhiteListId);
            }
        });
    }

    private void updateWhitelist(Project p, String oldWhiteListId, String newWhiteListId) {
        ArrayList<Project> projs = new ArrayList<Project>();
        projs.add(p);
        projs.addAll(((SubprojectProvider)p.getLookup().lookup(SubprojectProvider.class)).getSubprojects());
        for (Project pp : projs) {
            if (oldWhiteListId != null) {
                WhiteListQuery.enableWhiteListInProject((Project)pp, (String)oldWhiteListId, (boolean)false);
            }
            if (newWhiteListId == null) continue;
            WhiteListQuery.enableWhiteListInProject((Project)pp, (String)newWhiteListId, (boolean)true);
        }
    }

    public void checkWhiteLists() {
        String newWhiteList = this.getServerWhiteList();
        if (newWhiteList == null && this.lastWhiteList == null || newWhiteList != null && this.lastWhiteList != null && newWhiteList.equals(this.lastWhiteList)) {
            return;
        }
        this.updateWhitelist(this.lastWhiteList, newWhiteList);
        this.lastWhiteList = newWhiteList;
    }

    protected String getServerWhiteList() {
        String servInstID = JavaEEProjectSettings.getServerInstanceID(this.project);
        if (servInstID != null) {
            try {
                J2eePlatform platform = Deployment.getDefault().getServerInstance(servInstID).getJ2eePlatform();
                WhiteListQueryImplementation.UserSelectable sw = (WhiteListQueryImplementation.UserSelectable)platform.getLookup().lookup(WhiteListQueryImplementation.UserSelectable.class);
                if (sw != null) {
                    return sw.getId();
                }
            }
            catch (InstanceRemovedException instanceRemovedException) {
                // empty catch block
            }
        }
        return null;
    }

    public static boolean isWhitelistViolated(Project p) {
        SourceGroup[] sgs = ProjectUtils.getSources((Project)p).getSourceGroups("java");
        if (sgs.length == 0) {
            return false;
        }
        Collection problems = WhiteListIndex.getDefault().getWhiteListViolations(sgs[0].getRootFolder(), null, new String[]{"oracle"});
        return problems.size() > 0 && DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)Bundle.MSG_WhitelistViolations(), Bundle.MSG_Dialog_Title(), 0)) != NotifyDescriptor.YES_OPTION;
    }
}

