/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsf.testrunner.ui.api;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.gsf.testrunner.api.TestCreatorProvider;
import org.netbeans.modules.gsf.testrunner.ui.CommonTestsCfgOfCreate;
import org.netbeans.modules.parsing.api.indexing.IndexingManager;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.RequestProcessor;

public final class TestCreatorPanelDisplayer {
    private static final TestCreatorPanelDisplayer INSTANCE = new TestCreatorPanelDisplayer();
    private static final RequestProcessor RP = new RequestProcessor(TestCreatorPanelDisplayer.class);

    private TestCreatorPanelDisplayer() {
    }

    public static TestCreatorPanelDisplayer getDefault() {
        return INSTANCE;
    }

    public void displayPanel(FileObject[] activatedFOs, Object location, String testingFramework) {
        CommonTestsCfgOfCreate cfg = new CommonTestsCfgOfCreate(activatedFOs);
        boolean isJ2MEProject = this.isJ2MEProject(activatedFOs);
        cfg.createCfgPanel(false, isJ2MEProject);
        ArrayList<String> testingFrameworks = new ArrayList<String>();
        Collection providers = Lookup.getDefault().lookupResult(TestCreatorProvider.class).allItems();
        if (!isJ2MEProject) {
            for (Lookup.Item provider : providers) {
                if (!((TestCreatorProvider)provider.getInstance()).enable(activatedFOs)) continue;
                testingFrameworks.add(provider.getDisplayName());
            }
        }
        if (testingFrameworks.isEmpty()) {
            return;
        }
        cfg.addTestingFrameworks(testingFrameworks);
        cfg.setPreselectedLocation(location);
        cfg.setPreselectedFramework(testingFramework);
        if (!cfg.configure()) {
            return;
        }
        String selected = cfg.getSelectedTestingFramework();
        for (final Lookup.Item provider : providers) {
            if (!provider.getDisplayName().equals(selected)) continue;
            final TestCreatorProvider.Context context = new TestCreatorProvider.Context(activatedFOs);
            context.setSingleClass(cfg.isSingleClass());
            context.setTargetFolder(cfg.getTargetFolder());
            context.setTestClassName(cfg.getTestClassName());
            context.setIntegrationTests(cfg.isIntegrationTests());
            context.setConfigurationPanelProperties(cfg.getConfigurationPanelProperties());
            final Collection<? extends SourceGroup> createdSourceRoots = cfg.getCreatedSourceRoots();
            RP.execute(new Runnable(){

                @Override
                public void run() {
                    for (SourceGroup sg : createdSourceRoots) {
                        IndexingManager.getDefault().refreshIndexAndWait(sg.getRootFolder().toURL(), null);
                    }
                    Mutex.EVENT.readAccess(new Runnable(){

                        @Override
                        public void run() {
                            ((TestCreatorProvider)provider.getInstance()).createTests(context);
                        }
                    });
                }
            });
            cfg = null;
            break;
        }
    }

    private boolean isJ2MEProject(FileObject[] activatedFOs) {
        Project p;
        FileObject fileObject = activatedFOs[0];
        if (fileObject != null && (p = FileOwnerQuery.getOwner((FileObject)fileObject)) != null) {
            return p.getLookup().lookup(TestCreatorPanelDisplayerProjectServiceProvider.class) != null;
        }
        return false;
    }

    private void saveAll(Node[] activatedNodes) {
        for (Node node : activatedNodes) {
            SaveCookie saveCookie = (SaveCookie)node.getLookup().lookup(SaveCookie.class);
            if (saveCookie == null) continue;
            try {
                saveCookie.save();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    public static class TestCreatorPanelDisplayerProjectServiceProvider {
        public TestCreatorPanelDisplayerProjectServiceProvider(Project p) {
        }
    }
}

