/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seplatform.platformdefinition;

import java.io.IOException;
import java.util.Map;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.modules.java.j2seplatform.platformdefinition.PlatformConvertor;
import org.netbeans.modules.java.j2seplatform.wizard.NewJ2SEPlatform;
import org.netbeans.spi.java.platform.JavaPlatformFactory;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileObject;
import org.openide.util.Parameters;

public class J2SEPlatformFactory
implements JavaPlatformFactory {
    private static volatile J2SEPlatformFactory instance;

    private J2SEPlatformFactory() {
    }

    @NonNull
    public JavaPlatform create(@NonNull FileObject installFolder, @NonNull String name, boolean persistent) throws IOException {
        Parameters.notNull((CharSequence)"installFolder", (Object)installFolder);
        Parameters.notNull((CharSequence)"name", (Object)name);
        J2SEPlatformFactory.assertValidPlatformName(name);
        return this.createImpl(installFolder, name, persistent);
    }

    @NonNull
    public JavaPlatform create(@NonNull FileObject installFolder) throws IOException {
        Parameters.notNull((CharSequence)"installFolder", (Object)installFolder);
        return this.createImpl(installFolder, null, true);
    }

    private JavaPlatform createImpl(@NonNull FileObject installFolder, @NullAllowed String name, boolean persistent) throws IOException {
        NewJ2SEPlatform plat = NewJ2SEPlatform.create(installFolder);
        plat.run();
        if (!plat.isValid()) {
            throw new IOException("Invalid J2SE platform in " + installFolder);
        }
        if (name != null) {
            installFolder.setAttribute("J2SEPlatform.displayName", (Object)name);
        } else {
            Object attr = installFolder.getAttribute("J2SEPlatform.displayName");
            name = attr instanceof String ? (String)attr : J2SEPlatformFactory.createPlatformDisplayName(plat);
        }
        String antName = J2SEPlatformFactory.createPlatformAntName(name);
        plat.setDisplayName(name);
        plat.setAntName(antName);
        return persistent ? PlatformConvertor.create(plat) : plat;
    }

    private static void assertValidPlatformName(@NonNull String platformName) {
        for (JavaPlatform jp : JavaPlatformManager.getDefault().getInstalledPlatforms()) {
            if (!platformName.equals(jp.getDisplayName())) continue;
            throw new IllegalArgumentException(platformName);
        }
    }

    @NonNull
    private static String createPlatformDisplayName(@NonNull JavaPlatform plat) {
        Map m = plat.getSystemProperties();
        String vmVersion = (String)m.get("java.specification.version");
        StringBuilder displayName = new StringBuilder("JDK ");
        if (vmVersion != null) {
            displayName.append(vmVersion);
        }
        return displayName.toString();
    }

    @NonNull
    private static String createPlatformAntName(@NonNull String displayName) {
        assert (displayName != null && displayName.length() > 0);
        String antName = PropertyUtils.getUsablePropertyName((String)displayName);
        if (J2SEPlatformFactory.platformExists(antName)) {
            String baseName = antName;
            int index = 1;
            antName = baseName + Integer.toString(index);
            while (J2SEPlatformFactory.platformExists(antName)) {
                antName = baseName + Integer.toString(++index);
            }
        }
        return antName;
    }

    private static boolean platformExists(@NonNull String antName) {
        assert (antName != null && antName.length() > 0);
        for (JavaPlatform p : JavaPlatformManager.getDefault().getInstalledPlatforms()) {
            String otherName = (String)p.getProperties().get("platform.ant.name");
            if (!antName.equals(otherName)) continue;
            return true;
        }
        return false;
    }

    @NonNull
    public static J2SEPlatformFactory getInstance() {
        J2SEPlatformFactory res = instance;
        if (res == null) {
            res = instance = new J2SEPlatformFactory();
        }
        return res;
    }

    public static final class Provider
    implements JavaPlatformFactory.Provider {
        @CheckForNull
        public JavaPlatformFactory forType(@NonNull String platformType) {
            if ("j2se".equals(platformType)) {
                return J2SEPlatformFactory.getInstance();
            }
            return null;
        }
    }
}

