/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.keymanagement;

import com.oracle.bmc.keymanagement.KmsVault;
import com.oracle.bmc.keymanagement.model.VaultReplicaSummary;
import com.oracle.bmc.keymanagement.model.VaultSummary;
import com.oracle.bmc.keymanagement.requests.ListVaultReplicasRequest;
import com.oracle.bmc.keymanagement.requests.ListVaultsRequest;
import com.oracle.bmc.keymanagement.responses.ListVaultReplicasResponse;
import com.oracle.bmc.keymanagement.responses.ListVaultsResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class KmsVaultPaginators {
    private final KmsVault client;

    public KmsVaultPaginators(KmsVault client) {
        this.client = client;
    }

    public Iterable<ListVaultReplicasResponse> listVaultReplicasResponseIterator(final ListVaultReplicasRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListVaultReplicasRequest.Builder>(){

            @Override
            public ListVaultReplicasRequest.Builder get() {
                return ListVaultReplicasRequest.builder().copy(request);
            }
        }, (Function)new Function<ListVaultReplicasResponse, String>(){

            @Override
            public String apply(ListVaultReplicasResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListVaultReplicasRequest.Builder>, ListVaultReplicasRequest>(){

            @Override
            public ListVaultReplicasRequest apply(RequestBuilderAndToken<ListVaultReplicasRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListVaultReplicasRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListVaultReplicasRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListVaultReplicasRequest, ListVaultReplicasResponse>(){

            @Override
            public ListVaultReplicasResponse apply(ListVaultReplicasRequest request) {
                return KmsVaultPaginators.this.client.listVaultReplicas(request);
            }
        });
    }

    public Iterable<VaultReplicaSummary> listVaultReplicasRecordIterator(final ListVaultReplicasRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListVaultReplicasRequest.Builder>(){

            @Override
            public ListVaultReplicasRequest.Builder get() {
                return ListVaultReplicasRequest.builder().copy(request);
            }
        }, (Function)new Function<ListVaultReplicasResponse, String>(){

            @Override
            public String apply(ListVaultReplicasResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListVaultReplicasRequest.Builder>, ListVaultReplicasRequest>(){

            @Override
            public ListVaultReplicasRequest apply(RequestBuilderAndToken<ListVaultReplicasRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListVaultReplicasRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListVaultReplicasRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListVaultReplicasRequest, ListVaultReplicasResponse>(){

            @Override
            public ListVaultReplicasResponse apply(ListVaultReplicasRequest request) {
                return KmsVaultPaginators.this.client.listVaultReplicas(request);
            }
        }, (Function)new Function<ListVaultReplicasResponse, List<VaultReplicaSummary>>(){

            @Override
            public List<VaultReplicaSummary> apply(ListVaultReplicasResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListVaultsResponse> listVaultsResponseIterator(final ListVaultsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListVaultsRequest.Builder>(){

            @Override
            public ListVaultsRequest.Builder get() {
                return ListVaultsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListVaultsResponse, String>(){

            @Override
            public String apply(ListVaultsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListVaultsRequest.Builder>, ListVaultsRequest>(){

            @Override
            public ListVaultsRequest apply(RequestBuilderAndToken<ListVaultsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListVaultsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListVaultsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListVaultsRequest, ListVaultsResponse>(){

            @Override
            public ListVaultsResponse apply(ListVaultsRequest request) {
                return KmsVaultPaginators.this.client.listVaults(request);
            }
        });
    }

    public Iterable<VaultSummary> listVaultsRecordIterator(final ListVaultsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListVaultsRequest.Builder>(){

            @Override
            public ListVaultsRequest.Builder get() {
                return ListVaultsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListVaultsResponse, String>(){

            @Override
            public String apply(ListVaultsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListVaultsRequest.Builder>, ListVaultsRequest>(){

            @Override
            public ListVaultsRequest apply(RequestBuilderAndToken<ListVaultsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListVaultsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListVaultsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListVaultsRequest, ListVaultsResponse>(){

            @Override
            public ListVaultsResponse apply(ListVaultsRequest request) {
                return KmsVaultPaginators.this.client.listVaults(request);
            }
        }, (Function)new Function<ListVaultsResponse, List<VaultSummary>>(){

            @Override
            public List<VaultSummary> apply(ListVaultsResponse response) {
                return response.getItems();
            }
        });
    }
}

