/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.js.parser.ir;

import com.oracle.js.parser.ir.BreakableNode;
import com.oracle.js.parser.ir.CatchNode;
import com.oracle.js.parser.ir.Flags;
import com.oracle.js.parser.ir.Label;
import com.oracle.js.parser.ir.LexicalContext;
import com.oracle.js.parser.ir.LexicalContextNode;
import com.oracle.js.parser.ir.Node;
import com.oracle.js.parser.ir.Statement;
import com.oracle.js.parser.ir.Symbol;
import com.oracle.js.parser.ir.Terminal;
import com.oracle.js.parser.ir.visitor.NodeVisitor;
import com.oracle.js.parser.ir.visitor.TranslatorNodeVisitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class Block
extends Node
implements BreakableNode,
Terminal,
Flags<Block> {
    protected final List<Statement> statements;
    protected final Map<String, Symbol> symbols;
    private int blockScopedOrRedeclaredSymbols;
    private int declaredNames;
    private final Label entryLabel;
    private final Label breakLabel;
    protected final int flags;
    public static final int NEEDS_SCOPE = 1;
    public static final int IS_TERMINAL = 4;
    public static final int IS_GLOBAL_SCOPE = 8;
    public static final int IS_SYNTHETIC = 16;
    public static final int IS_BODY = 32;
    public static final int IS_PARAMETER_BLOCK = 64;
    public static final int IS_SWITCH_BLOCK = 128;

    public Block(long token, int finish, int flags, Statement ... statements) {
        super(token, finish);
        assert (this.start <= finish);
        this.statements = Arrays.asList(statements);
        this.symbols = new LinkedHashMap<String, Symbol>();
        this.entryLabel = new Label("block_entry");
        this.breakLabel = new Label("block_break");
        int len = statements.length;
        int terminalFlags = len > 0 && statements[len - 1].hasTerminalFlags() ? 4 : 0;
        this.flags = terminalFlags | flags;
    }

    public Block(long token, int finish, List<Statement> statements) {
        this(token, finish, 16, statements);
    }

    public Block(long token, int finish, int flags, List<Statement> statements) {
        this(token, finish, flags, statements.toArray(new Statement[0]));
    }

    private Block(Block block, int finish, List<Statement> statements, int flags, Map<String, Symbol> symbols) {
        super(block, finish);
        this.statements = statements;
        this.flags = flags;
        this.symbols = new LinkedHashMap<String, Symbol>(symbols);
        this.entryLabel = new Label(block.entryLabel);
        this.breakLabel = new Label(block.breakLabel);
        this.declaredNames = block.declaredNames;
        this.blockScopedOrRedeclaredSymbols = block.blockScopedOrRedeclaredSymbols;
    }

    public boolean isGlobalScope() {
        return this.getFlag(8);
    }

    @Override
    public Node accept(LexicalContext lc, NodeVisitor<? extends LexicalContext> visitor) {
        if (visitor.enterBlock(this)) {
            return visitor.leaveBlock(this.setStatements(lc, Node.accept(visitor, this.statements)));
        }
        return this;
    }

    @Override
    public <R> R accept(LexicalContext lc, TranslatorNodeVisitor<? extends LexicalContext, R> visitor) {
        return visitor.enterBlock(this);
    }

    public List<Symbol> getSymbols() {
        return Collections.unmodifiableList(new ArrayList<Symbol>(this.symbols.values()));
    }

    public Symbol getExistingSymbol(String name) {
        return this.symbols.get(name);
    }

    public boolean isCatchBlock() {
        return this.statements.size() == 1 && this.statements.get(0) instanceof CatchNode;
    }

    @Override
    public void toString(StringBuilder sb, boolean printType) {
        for (Node node : this.statements) {
            node.toString(sb, printType);
            sb.append(';');
        }
    }

    @Override
    public int getFlags() {
        return this.flags;
    }

    @Override
    public boolean isTerminal() {
        return this.getFlag(4);
    }

    public Label getEntryLabel() {
        return this.entryLabel;
    }

    @Override
    public Label getBreakLabel() {
        return this.breakLabel;
    }

    public List<Statement> getStatements() {
        return Collections.unmodifiableList(this.statements);
    }

    public int getStatementCount() {
        return this.statements.size();
    }

    public int getFirstStatementLineNumber() {
        if (this.statements == null || this.statements.isEmpty()) {
            return -1;
        }
        return this.statements.get(0).getLineNumber();
    }

    public Statement getFirstStatement() {
        return this.statements.isEmpty() ? null : this.statements.get(0);
    }

    public Statement getLastStatement() {
        return this.statements.isEmpty() ? null : this.statements.get(this.statements.size() - 1);
    }

    public Block setStatements(LexicalContext lc, List<Statement> statements) {
        if (this.statements == statements) {
            return this;
        }
        int lastFinish = 0;
        if (!statements.isEmpty()) {
            lastFinish = statements.get(statements.size() - 1).getFinish();
        }
        return Node.replaceInLexicalContext(lc, this, new Block(this, Math.max(this.finish, lastFinish), statements, this.flags, this.symbols));
    }

    public void putSymbol(LexicalContext lc, Symbol symbol) {
        this.symbols.put(symbol.getName(), symbol);
        if (symbol.isBlockScoped() || symbol.isVarRedeclaredHere()) {
            ++this.blockScopedOrRedeclaredSymbols;
        }
        if (symbol.isBlockScoped() || symbol.isVarDeclaredHere()) {
            ++this.declaredNames;
        }
    }

    public boolean needsScope() {
        return (this.flags & 1) == 1;
    }

    public boolean isSynthetic() {
        return (this.flags & 0x10) == 16;
    }

    @Override
    public Block setFlags(LexicalContext lc, int flags) {
        if (this.flags == flags) {
            return this;
        }
        return Node.replaceInLexicalContext(lc, this, new Block(this, this.finish, this.statements, flags, this.symbols));
    }

    @Override
    public Block setFlag(LexicalContext lc, int flag) {
        return this.setFlags(lc, this.flags | flag);
    }

    @Override
    public boolean getFlag(int flag) {
        return (this.flags & flag) == flag;
    }

    @Override
    public boolean isBreakableWithoutLabel() {
        return false;
    }

    @Override
    public List<Label> getLabels() {
        return Collections.unmodifiableList(Arrays.asList(this.entryLabel, this.breakLabel));
    }

    @Override
    public Node accept(NodeVisitor<? extends LexicalContext> visitor) {
        return LexicalContextNode.Acceptor.accept((LexicalContextNode)this, visitor);
    }

    @Override
    public <R> R accept(TranslatorNodeVisitor<? extends LexicalContext, R> visitor) {
        return LexicalContextNode.Acceptor.accept((LexicalContextNode)this, visitor);
    }

    public Map<String, Symbol> getSymbolMap() {
        return this.symbols;
    }

    public boolean hasBlockScopedOrRedeclaredSymbols() {
        return this.blockScopedOrRedeclaredSymbols != 0;
    }

    public boolean hasDeclarations() {
        return this.declaredNames != 0;
    }

    public boolean isFunctionBody() {
        return this.getFlag(32);
    }

    public boolean isParameterBlock() {
        return this.getFlag(64);
    }

    public boolean isSwitchBlock() {
        return this.getFlag(128);
    }
}

