/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbcore.ejb.wizard.entity;

import java.awt.Component;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.ejbcore.ejb.wizard.entity.EntityEJBWizardPanel;
import org.netbeans.modules.j2ee.ejbcore.naming.EJBNameOptions;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class EntityEJBWizardDescriptor
implements WizardDescriptor.FinishablePanel,
ChangeListener {
    private EntityEJBWizardPanel wizardPanel;
    private final List<ChangeListener> changeListeners = new ArrayList<ChangeListener>();
    private WizardDescriptor wizardDescriptor;
    private final EJBNameOptions ejbNames = new EJBNameOptions();

    public void addChangeListener(ChangeListener changeListener) {
        this.changeListeners.add(changeListener);
    }

    public Component getComponent() {
        if (this.wizardPanel == null) {
            this.wizardPanel = new EntityEJBWizardPanel(this);
        }
        return this.wizardPanel;
    }

    public HelpCtx getHelp() {
        return new HelpCtx(EntityEJBWizardDescriptor.class);
    }

    public boolean isValid() {
        String errorMessage;
        if (this.wizardDescriptor == null) {
            return true;
        }
        Project project = Templates.getProject((WizardDescriptor)this.wizardDescriptor);
        J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
        String j2eeVersion = j2eeModuleProvider.getJ2eeModule().getModuleVersion();
        if ("3.0".equals(j2eeVersion)) {
            this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(EntityEJBWizardDescriptor.class, (String)"MSG_DisabledForEJB3"));
            return false;
        }
        boolean isLocal = this.wizardPanel.isLocal();
        boolean isRemote = this.wizardPanel.isRemote();
        if (!isLocal && !isRemote) {
            this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(EntityEJBWizardDescriptor.class, (String)"ERR_RemoteOrLocal_MustBeSelected"));
            return false;
        }
        if (this.wizardPanel.getPrimaryKeyClassName().trim().equals("")) {
            this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(EntityEJBWizardDescriptor.class, (String)"ERR_PrimaryKeyNotEmpty"));
            return false;
        }
        FileObject targetFolder = (FileObject)this.wizardDescriptor.getProperty("MultiTargetChooserPanel.TARGET_FOLDER");
        if (targetFolder != null) {
            String targetName = (String)this.wizardDescriptor.getProperty("MultiTargetChooserPanel.TARGET_NAME");
            ArrayList<String> proposedNames = new ArrayList<String>();
            proposedNames.add(this.ejbNames.getEntityEjbClassPrefix() + targetName + this.ejbNames.getEntityEjbClassSuffix());
            if (isLocal) {
                proposedNames.add(this.ejbNames.getEntityLocalPrefix() + targetName + this.ejbNames.getEntityLocalSuffix());
                proposedNames.add(this.ejbNames.getEntityLocalHomePrefix() + targetName + this.ejbNames.getEntityLocalHomeSuffix());
            }
            if (isRemote) {
                proposedNames.add(this.ejbNames.getEntityRemotePrefix() + targetName + this.ejbNames.getEntityRemoteSuffix());
                proposedNames.add(this.ejbNames.getEntityRemoteHomePrefix() + targetName + this.ejbNames.getEntityRemoteHomeSuffix());
            }
            for (String name : proposedNames) {
                if (targetFolder.getFileObject(name + ".java") == null) continue;
                this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(EntityEJBWizardDescriptor.class, (String)"ERR_FileAlreadyExists", (Object)(name + ".java")));
                return false;
            }
        }
        if ((errorMessage = (String)this.wizardDescriptor.getProperty("WizardPanel_errorMessage")) == null || errorMessage.trim().equals("")) {
            this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)" ");
        }
        return true;
    }

    public void readSettings(Object settings) {
        this.wizardDescriptor = (WizardDescriptor)settings;
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeListeners.remove(changeListener);
    }

    public void storeSettings(Object settings) {
    }

    public boolean isCMP() {
        return this.wizardPanel.isCMP();
    }

    public boolean hasRemote() {
        return this.wizardPanel.isRemote();
    }

    public boolean hasLocal() {
        return this.wizardPanel.isLocal();
    }

    public String getPrimaryKeyClassName() {
        return this.wizardPanel.getPrimaryKeyClassName();
    }

    public boolean isFinishPanel() {
        return this.isValid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireChangeEvent() {
        Iterator<ChangeListener> iterator;
        List<ChangeListener> list = this.changeListeners;
        synchronized (list) {
            iterator = new HashSet<ChangeListener>(this.changeListeners).iterator();
        }
        ChangeEvent changeEvent = new ChangeEvent(this);
        while (iterator.hasNext()) {
            iterator.next().stateChanged(changeEvent);
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.fireChangeEvent();
    }
}

