/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.jaxws.actions;

import java.awt.Image;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.maven.jaxws.WSUtils;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlOperation;
import org.netbeans.modules.websvc.project.api.WebService;
import org.netbeans.modules.websvc.project.api.WebServiceData;
import org.netbeans.modules.websvc.spi.support.DefaultClientSelectionPanel;
import org.netbeans.spi.project.ui.LogicalViewProvider;
import org.openide.filesystems.FileObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;

public class ClientExplorerPanel
extends DefaultClientSelectionPanel {
    private Project[] sourceProjects = OpenProjects.getDefault().getOpenProjects();
    private Children rootChildren = new Children.Array();
    private Node explorerClientRoot = new AbstractNode(this.rootChildren);
    private List<Node> projectNodeList = new ArrayList<Node>();

    public ClientExplorerPanel(FileObject targetSource) {
        super(targetSource);
    }

    public void addNotify() {
        super.addNotify();
        this.getTreeView().expandAll();
    }

    protected Node getRootContext() {
        for (int i = 0; i < this.sourceProjects.length; ++i) {
            LogicalViewProvider logicalProvider;
            Project targetProject = FileOwnerQuery.getOwner((FileObject)this.getTargetFile());
            if (targetProject == null || !WSUtils.isProjectReferenceable(this.sourceProjects[i], targetProject) || (logicalProvider = (LogicalViewProvider)this.sourceProjects[i].getLookup().lookup(LogicalViewProvider.class)) == null) continue;
            Node rootNode = logicalProvider.createLogicalView();
            Node[] servicesNodes = this.getClientNodes(this.sourceProjects[i]);
            if (servicesNodes.length <= 0) continue;
            Children.Array children = new Children.Array();
            children.add(servicesNodes);
            if (children.getNodesCount() <= 0) continue;
            this.projectNodeList.add((Node)new ProjectNode((Children)children, rootNode));
        }
        Node[] projectNodes = new Node[this.projectNodeList.size()];
        this.projectNodeList.toArray(projectNodes);
        this.rootChildren.add(projectNodes);
        return this.explorerClientRoot;
    }

    protected boolean isClientNode(Node node) {
        return node.getLookup().lookup(WsdlOperation.class) != null;
    }

    private Node[] getClientNodes(Project project) {
        WebServiceData wsData = WebServiceData.getWebServiceData((Project)project);
        if (wsData != null) {
            ArrayList<Node> nodes = new ArrayList<Node>();
            for (WebService ws : wsData.getServiceConsumers()) {
                nodes.add(ws.createNode());
            }
            return nodes.toArray(new Node[0]);
        }
        return new Node[0];
    }

    private static class ProjectNode
    extends AbstractNode {
        private Node rootNode;

        ProjectNode(Children children, Node rootNode) {
            super(children);
            this.rootNode = rootNode;
            this.setName(rootNode.getDisplayName());
        }

        public Image getIcon(int type) {
            return this.rootNode.getIcon(type);
        }

        public Image getOpenedIcon(int type) {
            return this.rootNode.getOpenedIcon(type);
        }
    }
}

