/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mylyn.util;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.mylyn.wikitext.core.parser.MarkupParser;
import org.eclipse.mylyn.wikitext.core.parser.markup.MarkupLanguage;
import org.eclipse.mylyn.wikitext.core.util.ServiceLocator;
import org.netbeans.modules.mylyn.util.WikiPanel;
import org.netbeans.modules.mylyn.util.wiki.WikiEditPanel;
import org.openide.util.Lookup;

public class WikiUtils {
    private static final Logger LOG = Logger.getLogger("org.netbeans.mylym.utils.WikiUtils");

    private WikiUtils() {
    }

    public static WikiPanel getWikiPanel(String wikiLanguage, boolean editing, boolean switchable) {
        return new WikiEditPanel(wikiLanguage, editing, switchable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getHtmlFormatText(String wikiFormatText, String language) {
        MarkupLanguage markupLanguage;
        block8: {
            if (language == null || language.isEmpty()) {
                LOG.log(Level.FINE, "Wiki language name is empty");
                return null;
            }
            ClassLoader originalContextCL = null;
            try {
                originalContextCL = WikiUtils.setupContextClassLoader();
                markupLanguage = ServiceLocator.getInstance().getMarkupLanguage(language);
            }
            catch (IllegalArgumentException ex) {
                String msg = ex.getMessage();
                if (msg.startsWith("Cannot load markup language")) {
                    LOG.log(Level.INFO, null, ex);
                    markupLanguage = null;
                    break block8;
                }
                throw ex;
            }
            finally {
                WikiUtils.restoreContextClassLoader(originalContextCL);
            }
        }
        if (markupLanguage == null) {
            LOG.log(Level.FINE, "Markup language for name {0} not found", language);
            return null;
        }
        MarkupParser parser = new MarkupParser(markupLanguage);
        String dirtyHtml = parser.parseToHtml(wikiFormatText);
        return WikiUtils.cleanHtmlTags(dirtyHtml);
    }

    private static String cleanHtmlTags(String html) {
        html = html.replaceFirst("<\\?xml.*?>", "");
        html = html.replaceAll("<html.*?>", "<html>");
        boolean remove = (html = html.replaceAll("<head>.*</head>", "")).contains("<body><p>");
        if (remove) {
            html = html.replaceFirst("<body><p>", "<body>");
            html = html.replaceFirst("</p>", "");
        }
        return html;
    }

    private static ClassLoader setupContextClassLoader() {
        ClassLoader currentContextCL;
        ClassLoader systemCL = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
        if (systemCL != null && (currentContextCL = Thread.currentThread().getContextClassLoader()) != null && currentContextCL != systemCL) {
            Thread.currentThread().setContextClassLoader(systemCL);
            return currentContextCL;
        }
        return null;
    }

    private static void restoreContextClassLoader(ClassLoader originalContextCL) {
        if (originalContextCL != null) {
            Thread.currentThread().setContextClassLoader(originalContextCL);
        }
    }
}

