/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.core.sync;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.internal.tasks.core.ITasksCoreConstants;
import org.eclipse.mylyn.internal.tasks.core.data.TaskDataManager;
import org.eclipse.mylyn.internal.tasks.core.sync.Messages;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.RepositoryResponse;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.AbstractTaskAttachmentHandler;
import org.eclipse.mylyn.tasks.core.data.AbstractTaskAttachmentSource;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.sync.SubmitJob;

public class SubmitTaskAttachmentJob
extends SubmitJob {
    private final TaskAttribute attachmentAttribute;
    private final String comment;
    private final AbstractRepositoryConnector connector;
    private IStatus errorStatus;
    private final AbstractTaskAttachmentSource source;
    private final ITask task;
    private final TaskRepository taskRepository;
    private final TaskDataManager taskDataManager;

    public SubmitTaskAttachmentJob(TaskDataManager taskDataManager, AbstractRepositoryConnector connector, TaskRepository taskRepository, ITask task, AbstractTaskAttachmentSource source, String comment, TaskAttribute attachmentAttribute) {
        super("Submitting Attachment");
        this.taskDataManager = taskDataManager;
        this.connector = connector;
        this.taskRepository = taskRepository;
        this.task = task;
        this.source = source;
        this.comment = comment;
        this.attachmentAttribute = attachmentAttribute;
        this.setRule(new ITasksCoreConstants.MutexSchedulingRule());
    }

    @Override
    public RepositoryResponse getResponse() {
        return null;
    }

    @Override
    public IStatus getStatus() {
        return this.errorStatus;
    }

    @Override
    public ITask getTask() {
        return this.task;
    }

    public IStatus run(IProgressMonitor monitor) {
        block8: {
            AbstractTaskAttachmentHandler attachmentHandler = this.connector.getTaskAttachmentHandler();
            if (attachmentHandler == null) {
                this.errorStatus = new Status(4, "org.eclipse.mylyn.tasks.core", "The task repository does not support attachments.");
                return Status.OK_STATUS;
            }
            try {
                monitor.beginTask(Messages.SubmitTaskAttachmentJob_Submitting_attachment, 2 * (1 + this.getSubmitJobListeners().length) * 100);
                monitor.subTask(Messages.SubmitTaskAttachmentJob_Sending_data);
                attachmentHandler.postContent(this.taskRepository, this.task, this.source, this.comment, this.attachmentAttribute, this.subMonitorFor(monitor, 100));
                this.fireTaskSubmitted(monitor);
                monitor.subTask(Messages.SubmitTaskAttachmentJob_Updating_task);
                TaskData updatedTaskData = this.connector.getTaskData(this.taskRepository, this.task.getTaskId(), this.subMonitorFor(monitor, 100));
                this.taskDataManager.putUpdatedTaskData(this.task, updatedTaskData, true);
                this.fireTaskSynchronized(monitor);
            }
            catch (CoreException e) {
                this.errorStatus = e.getStatus();
                monitor.done();
                break block8;
            }
            catch (OperationCanceledException operationCanceledException) {
                try {
                    this.errorStatus = Status.CANCEL_STATUS;
                    break block8;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    monitor.done();
                }
            }
            monitor.done();
        }
        this.fireDone();
        return this.errorStatus == Status.CANCEL_STATUS ? Status.CANCEL_STATUS : Status.OK_STATUS;
    }
}

