/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.core.model.EncryptionInTransitType;
import com.oracle.bmc.core.model.MultipathDevice;
import com.oracle.bmc.core.model.VolumeAttachment;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="attachmentType")
@JsonFilter(value="explicitlySetFilter")
public final class IScsiVolumeAttachment
extends VolumeAttachment {
    @JsonProperty(value="chapSecret")
    private final String chapSecret;
    @JsonProperty(value="chapUsername")
    private final String chapUsername;
    @JsonProperty(value="ipv4")
    private final String ipv4;
    @JsonProperty(value="iqn")
    private final String iqn;
    @JsonProperty(value="port")
    private final Integer port;
    @JsonProperty(value="multipathDevices")
    private final List<MultipathDevice> multipathDevices;
    @JsonProperty(value="encryptionInTransitType")
    private final EncryptionInTransitType encryptionInTransitType;
    @JsonProperty(value="isAgentAutoIscsiLoginEnabled")
    private final Boolean isAgentAutoIscsiLoginEnabled;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public IScsiVolumeAttachment(String availabilityDomain, String compartmentId, String device, String displayName, String id, String instanceId, Boolean isReadOnly, Boolean isShareable, VolumeAttachment.LifecycleState lifecycleState, Date timeCreated, String volumeId, Boolean isPvEncryptionInTransitEnabled, Boolean isMultipath, VolumeAttachment.IscsiLoginState iscsiLoginState, String chapSecret, String chapUsername, String ipv4, String iqn, Integer port, List<MultipathDevice> multipathDevices, EncryptionInTransitType encryptionInTransitType, Boolean isAgentAutoIscsiLoginEnabled) {
        super(availabilityDomain, compartmentId, device, displayName, id, instanceId, isReadOnly, isShareable, lifecycleState, timeCreated, volumeId, isPvEncryptionInTransitEnabled, isMultipath, iscsiLoginState);
        this.chapSecret = chapSecret;
        this.chapUsername = chapUsername;
        this.ipv4 = ipv4;
        this.iqn = iqn;
        this.port = port;
        this.multipathDevices = multipathDevices;
        this.encryptionInTransitType = encryptionInTransitType;
        this.isAgentAutoIscsiLoginEnabled = isAgentAutoIscsiLoginEnabled;
    }

    public String getChapSecret() {
        return this.chapSecret;
    }

    public String getChapUsername() {
        return this.chapUsername;
    }

    public String getIpv4() {
        return this.ipv4;
    }

    public String getIqn() {
        return this.iqn;
    }

    public Integer getPort() {
        return this.port;
    }

    public List<MultipathDevice> getMultipathDevices() {
        return this.multipathDevices;
    }

    public EncryptionInTransitType getEncryptionInTransitType() {
        return this.encryptionInTransitType;
    }

    public Boolean getIsAgentAutoIscsiLoginEnabled() {
        return this.isAgentAutoIscsiLoginEnabled;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("IScsiVolumeAttachment(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", chapSecret=").append(String.valueOf(this.chapSecret));
        sb.append(", chapUsername=").append(String.valueOf(this.chapUsername));
        sb.append(", ipv4=").append(String.valueOf(this.ipv4));
        sb.append(", iqn=").append(String.valueOf(this.iqn));
        sb.append(", port=").append(String.valueOf(this.port));
        sb.append(", multipathDevices=").append(String.valueOf(this.multipathDevices));
        sb.append(", encryptionInTransitType=").append(String.valueOf((Object)this.encryptionInTransitType));
        sb.append(", isAgentAutoIscsiLoginEnabled=").append(String.valueOf(this.isAgentAutoIscsiLoginEnabled));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IScsiVolumeAttachment)) {
            return false;
        }
        IScsiVolumeAttachment other = (IScsiVolumeAttachment)((Object)o);
        return Objects.equals(this.chapSecret, other.chapSecret) && Objects.equals(this.chapUsername, other.chapUsername) && Objects.equals(this.ipv4, other.ipv4) && Objects.equals(this.iqn, other.iqn) && Objects.equals(this.port, other.port) && Objects.equals(this.multipathDevices, other.multipathDevices) && Objects.equals((Object)this.encryptionInTransitType, (Object)other.encryptionInTransitType) && Objects.equals(this.isAgentAutoIscsiLoginEnabled, other.isAgentAutoIscsiLoginEnabled) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.chapSecret == null ? 43 : this.chapSecret.hashCode());
        result = result * 59 + (this.chapUsername == null ? 43 : this.chapUsername.hashCode());
        result = result * 59 + (this.ipv4 == null ? 43 : this.ipv4.hashCode());
        result = result * 59 + (this.iqn == null ? 43 : this.iqn.hashCode());
        result = result * 59 + (this.port == null ? 43 : this.port.hashCode());
        result = result * 59 + (this.multipathDevices == null ? 43 : this.multipathDevices.hashCode());
        result = result * 59 + (this.encryptionInTransitType == null ? 43 : this.encryptionInTransitType.hashCode());
        result = result * 59 + (this.isAgentAutoIscsiLoginEnabled == null ? 43 : this.isAgentAutoIscsiLoginEnabled.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="availabilityDomain")
        private String availabilityDomain;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="device")
        private String device;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="instanceId")
        private String instanceId;
        @JsonProperty(value="isReadOnly")
        private Boolean isReadOnly;
        @JsonProperty(value="isShareable")
        private Boolean isShareable;
        @JsonProperty(value="lifecycleState")
        private VolumeAttachment.LifecycleState lifecycleState;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="volumeId")
        private String volumeId;
        @JsonProperty(value="isPvEncryptionInTransitEnabled")
        private Boolean isPvEncryptionInTransitEnabled;
        @JsonProperty(value="isMultipath")
        private Boolean isMultipath;
        @JsonProperty(value="iscsiLoginState")
        private VolumeAttachment.IscsiLoginState iscsiLoginState;
        @JsonProperty(value="chapSecret")
        private String chapSecret;
        @JsonProperty(value="chapUsername")
        private String chapUsername;
        @JsonProperty(value="ipv4")
        private String ipv4;
        @JsonProperty(value="iqn")
        private String iqn;
        @JsonProperty(value="port")
        private Integer port;
        @JsonProperty(value="multipathDevices")
        private List<MultipathDevice> multipathDevices;
        @JsonProperty(value="encryptionInTransitType")
        private EncryptionInTransitType encryptionInTransitType;
        @JsonProperty(value="isAgentAutoIscsiLoginEnabled")
        private Boolean isAgentAutoIscsiLoginEnabled;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder availabilityDomain(String availabilityDomain) {
            this.availabilityDomain = availabilityDomain;
            this.__explicitlySet__.add("availabilityDomain");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder device(String device) {
            this.device = device;
            this.__explicitlySet__.add("device");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            this.__explicitlySet__.add("instanceId");
            return this;
        }

        public Builder isReadOnly(Boolean isReadOnly) {
            this.isReadOnly = isReadOnly;
            this.__explicitlySet__.add("isReadOnly");
            return this;
        }

        public Builder isShareable(Boolean isShareable) {
            this.isShareable = isShareable;
            this.__explicitlySet__.add("isShareable");
            return this;
        }

        public Builder lifecycleState(VolumeAttachment.LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder volumeId(String volumeId) {
            this.volumeId = volumeId;
            this.__explicitlySet__.add("volumeId");
            return this;
        }

        public Builder isPvEncryptionInTransitEnabled(Boolean isPvEncryptionInTransitEnabled) {
            this.isPvEncryptionInTransitEnabled = isPvEncryptionInTransitEnabled;
            this.__explicitlySet__.add("isPvEncryptionInTransitEnabled");
            return this;
        }

        public Builder isMultipath(Boolean isMultipath) {
            this.isMultipath = isMultipath;
            this.__explicitlySet__.add("isMultipath");
            return this;
        }

        public Builder iscsiLoginState(VolumeAttachment.IscsiLoginState iscsiLoginState) {
            this.iscsiLoginState = iscsiLoginState;
            this.__explicitlySet__.add("iscsiLoginState");
            return this;
        }

        public Builder chapSecret(String chapSecret) {
            this.chapSecret = chapSecret;
            this.__explicitlySet__.add("chapSecret");
            return this;
        }

        public Builder chapUsername(String chapUsername) {
            this.chapUsername = chapUsername;
            this.__explicitlySet__.add("chapUsername");
            return this;
        }

        public Builder ipv4(String ipv4) {
            this.ipv4 = ipv4;
            this.__explicitlySet__.add("ipv4");
            return this;
        }

        public Builder iqn(String iqn) {
            this.iqn = iqn;
            this.__explicitlySet__.add("iqn");
            return this;
        }

        public Builder port(Integer port) {
            this.port = port;
            this.__explicitlySet__.add("port");
            return this;
        }

        public Builder multipathDevices(List<MultipathDevice> multipathDevices) {
            this.multipathDevices = multipathDevices;
            this.__explicitlySet__.add("multipathDevices");
            return this;
        }

        public Builder encryptionInTransitType(EncryptionInTransitType encryptionInTransitType) {
            this.encryptionInTransitType = encryptionInTransitType;
            this.__explicitlySet__.add("encryptionInTransitType");
            return this;
        }

        public Builder isAgentAutoIscsiLoginEnabled(Boolean isAgentAutoIscsiLoginEnabled) {
            this.isAgentAutoIscsiLoginEnabled = isAgentAutoIscsiLoginEnabled;
            this.__explicitlySet__.add("isAgentAutoIscsiLoginEnabled");
            return this;
        }

        public IScsiVolumeAttachment build() {
            IScsiVolumeAttachment model = new IScsiVolumeAttachment(this.availabilityDomain, this.compartmentId, this.device, this.displayName, this.id, this.instanceId, this.isReadOnly, this.isShareable, this.lifecycleState, this.timeCreated, this.volumeId, this.isPvEncryptionInTransitEnabled, this.isMultipath, this.iscsiLoginState, this.chapSecret, this.chapUsername, this.ipv4, this.iqn, this.port, this.multipathDevices, this.encryptionInTransitType, this.isAgentAutoIscsiLoginEnabled);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(IScsiVolumeAttachment model) {
            if (model.wasPropertyExplicitlySet("availabilityDomain")) {
                this.availabilityDomain(model.getAvailabilityDomain());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("device")) {
                this.device(model.getDevice());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("instanceId")) {
                this.instanceId(model.getInstanceId());
            }
            if (model.wasPropertyExplicitlySet("isReadOnly")) {
                this.isReadOnly(model.getIsReadOnly());
            }
            if (model.wasPropertyExplicitlySet("isShareable")) {
                this.isShareable(model.getIsShareable());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("volumeId")) {
                this.volumeId(model.getVolumeId());
            }
            if (model.wasPropertyExplicitlySet("isPvEncryptionInTransitEnabled")) {
                this.isPvEncryptionInTransitEnabled(model.getIsPvEncryptionInTransitEnabled());
            }
            if (model.wasPropertyExplicitlySet("isMultipath")) {
                this.isMultipath(model.getIsMultipath());
            }
            if (model.wasPropertyExplicitlySet("iscsiLoginState")) {
                this.iscsiLoginState(model.getIscsiLoginState());
            }
            if (model.wasPropertyExplicitlySet("chapSecret")) {
                this.chapSecret(model.getChapSecret());
            }
            if (model.wasPropertyExplicitlySet("chapUsername")) {
                this.chapUsername(model.getChapUsername());
            }
            if (model.wasPropertyExplicitlySet("ipv4")) {
                this.ipv4(model.getIpv4());
            }
            if (model.wasPropertyExplicitlySet("iqn")) {
                this.iqn(model.getIqn());
            }
            if (model.wasPropertyExplicitlySet("port")) {
                this.port(model.getPort());
            }
            if (model.wasPropertyExplicitlySet("multipathDevices")) {
                this.multipathDevices(model.getMultipathDevices());
            }
            if (model.wasPropertyExplicitlySet("encryptionInTransitType")) {
                this.encryptionInTransitType(model.getEncryptionInTransitType());
            }
            if (model.wasPropertyExplicitlySet("isAgentAutoIscsiLoginEnabled")) {
                this.isAgentAutoIscsiLoginEnabled(model.getIsAgentAutoIscsiLoginEnabled());
            }
            return this;
        }
    }
}

