/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.objectstorage.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.objectstorage.model.CopyObjectDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class CopyObjectRequest
extends BmcRequest<CopyObjectDetails> {
    private String namespaceName;
    private String bucketName;
    private CopyObjectDetails copyObjectDetails;
    private String opcClientRequestId;
    private String opcSseCustomerAlgorithm;
    private String opcSseCustomerKey;
    private String opcSseCustomerKeySha256;
    private String opcSourceSseCustomerAlgorithm;
    private String opcSourceSseCustomerKey;
    private String opcSourceSseCustomerKeySha256;
    private String opcSseKmsKeyId;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public CopyObjectDetails getCopyObjectDetails() {
        return this.copyObjectDetails;
    }

    public String getOpcClientRequestId() {
        return this.opcClientRequestId;
    }

    public String getOpcSseCustomerAlgorithm() {
        return this.opcSseCustomerAlgorithm;
    }

    public String getOpcSseCustomerKey() {
        return this.opcSseCustomerKey;
    }

    public String getOpcSseCustomerKeySha256() {
        return this.opcSseCustomerKeySha256;
    }

    public String getOpcSourceSseCustomerAlgorithm() {
        return this.opcSourceSseCustomerAlgorithm;
    }

    public String getOpcSourceSseCustomerKey() {
        return this.opcSourceSseCustomerKey;
    }

    public String getOpcSourceSseCustomerKeySha256() {
        return this.opcSourceSseCustomerKeySha256;
    }

    public String getOpcSseKmsKeyId() {
        return this.opcSseKmsKeyId;
    }

    @InternalSdk
    public CopyObjectDetails getBody$() {
        return this.copyObjectDetails;
    }

    public Builder toBuilder() {
        return new Builder().namespaceName(this.namespaceName).bucketName(this.bucketName).copyObjectDetails(this.copyObjectDetails).opcClientRequestId(this.opcClientRequestId).opcSseCustomerAlgorithm(this.opcSseCustomerAlgorithm).opcSseCustomerKey(this.opcSseCustomerKey).opcSseCustomerKeySha256(this.opcSseCustomerKeySha256).opcSourceSseCustomerAlgorithm(this.opcSourceSseCustomerAlgorithm).opcSourceSseCustomerKey(this.opcSourceSseCustomerKey).opcSourceSseCustomerKeySha256(this.opcSourceSseCustomerKeySha256).opcSseKmsKeyId(this.opcSseKmsKeyId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",namespaceName=").append(String.valueOf(this.namespaceName));
        sb.append(",bucketName=").append(String.valueOf(this.bucketName));
        sb.append(",copyObjectDetails=").append(String.valueOf((Object)this.copyObjectDetails));
        sb.append(",opcClientRequestId=").append(String.valueOf(this.opcClientRequestId));
        sb.append(",opcSseCustomerAlgorithm=").append(String.valueOf(this.opcSseCustomerAlgorithm));
        sb.append(",opcSseCustomerKey=").append(String.valueOf(this.opcSseCustomerKey));
        sb.append(",opcSseCustomerKeySha256=").append(String.valueOf(this.opcSseCustomerKeySha256));
        sb.append(",opcSourceSseCustomerAlgorithm=").append(String.valueOf(this.opcSourceSseCustomerAlgorithm));
        sb.append(",opcSourceSseCustomerKey=").append(String.valueOf(this.opcSourceSseCustomerKey));
        sb.append(",opcSourceSseCustomerKeySha256=").append(String.valueOf(this.opcSourceSseCustomerKeySha256));
        sb.append(",opcSseKmsKeyId=").append(String.valueOf(this.opcSseKmsKeyId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CopyObjectRequest)) {
            return false;
        }
        CopyObjectRequest other = (CopyObjectRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.namespaceName, other.namespaceName) && Objects.equals(this.bucketName, other.bucketName) && Objects.equals((Object)this.copyObjectDetails, (Object)other.copyObjectDetails) && Objects.equals(this.opcClientRequestId, other.opcClientRequestId) && Objects.equals(this.opcSseCustomerAlgorithm, other.opcSseCustomerAlgorithm) && Objects.equals(this.opcSseCustomerKey, other.opcSseCustomerKey) && Objects.equals(this.opcSseCustomerKeySha256, other.opcSseCustomerKeySha256) && Objects.equals(this.opcSourceSseCustomerAlgorithm, other.opcSourceSseCustomerAlgorithm) && Objects.equals(this.opcSourceSseCustomerKey, other.opcSourceSseCustomerKey) && Objects.equals(this.opcSourceSseCustomerKeySha256, other.opcSourceSseCustomerKeySha256) && Objects.equals(this.opcSseKmsKeyId, other.opcSseKmsKeyId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.namespaceName == null ? 43 : this.namespaceName.hashCode());
        result = result * 59 + (this.bucketName == null ? 43 : this.bucketName.hashCode());
        result = result * 59 + (this.copyObjectDetails == null ? 43 : this.copyObjectDetails.hashCode());
        result = result * 59 + (this.opcClientRequestId == null ? 43 : this.opcClientRequestId.hashCode());
        result = result * 59 + (this.opcSseCustomerAlgorithm == null ? 43 : this.opcSseCustomerAlgorithm.hashCode());
        result = result * 59 + (this.opcSseCustomerKey == null ? 43 : this.opcSseCustomerKey.hashCode());
        result = result * 59 + (this.opcSseCustomerKeySha256 == null ? 43 : this.opcSseCustomerKeySha256.hashCode());
        result = result * 59 + (this.opcSourceSseCustomerAlgorithm == null ? 43 : this.opcSourceSseCustomerAlgorithm.hashCode());
        result = result * 59 + (this.opcSourceSseCustomerKey == null ? 43 : this.opcSourceSseCustomerKey.hashCode());
        result = result * 59 + (this.opcSourceSseCustomerKeySha256 == null ? 43 : this.opcSourceSseCustomerKeySha256.hashCode());
        result = result * 59 + (this.opcSseKmsKeyId == null ? 43 : this.opcSseKmsKeyId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<CopyObjectRequest, CopyObjectDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String namespaceName = null;
        private String bucketName = null;
        private CopyObjectDetails copyObjectDetails = null;
        private String opcClientRequestId = null;
        private String opcSseCustomerAlgorithm = null;
        private String opcSseCustomerKey = null;
        private String opcSseCustomerKeySha256 = null;
        private String opcSourceSseCustomerAlgorithm = null;
        private String opcSourceSseCustomerKey = null;
        private String opcSourceSseCustomerKeySha256 = null;
        private String opcSseKmsKeyId = null;

        public Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public Builder copyObjectDetails(CopyObjectDetails copyObjectDetails) {
            this.copyObjectDetails = copyObjectDetails;
            return this;
        }

        public Builder opcClientRequestId(String opcClientRequestId) {
            this.opcClientRequestId = opcClientRequestId;
            return this;
        }

        public Builder opcSseCustomerAlgorithm(String opcSseCustomerAlgorithm) {
            this.opcSseCustomerAlgorithm = opcSseCustomerAlgorithm;
            return this;
        }

        public Builder opcSseCustomerKey(String opcSseCustomerKey) {
            this.opcSseCustomerKey = opcSseCustomerKey;
            return this;
        }

        public Builder opcSseCustomerKeySha256(String opcSseCustomerKeySha256) {
            this.opcSseCustomerKeySha256 = opcSseCustomerKeySha256;
            return this;
        }

        public Builder opcSourceSseCustomerAlgorithm(String opcSourceSseCustomerAlgorithm) {
            this.opcSourceSseCustomerAlgorithm = opcSourceSseCustomerAlgorithm;
            return this;
        }

        public Builder opcSourceSseCustomerKey(String opcSourceSseCustomerKey) {
            this.opcSourceSseCustomerKey = opcSourceSseCustomerKey;
            return this;
        }

        public Builder opcSourceSseCustomerKeySha256(String opcSourceSseCustomerKeySha256) {
            this.opcSourceSseCustomerKeySha256 = opcSourceSseCustomerKeySha256;
            return this;
        }

        public Builder opcSseKmsKeyId(String opcSseKmsKeyId) {
            this.opcSseKmsKeyId = opcSseKmsKeyId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CopyObjectRequest o) {
            this.namespaceName(o.getNamespaceName());
            this.bucketName(o.getBucketName());
            this.copyObjectDetails(o.getCopyObjectDetails());
            this.opcClientRequestId(o.getOpcClientRequestId());
            this.opcSseCustomerAlgorithm(o.getOpcSseCustomerAlgorithm());
            this.opcSseCustomerKey(o.getOpcSseCustomerKey());
            this.opcSseCustomerKeySha256(o.getOpcSseCustomerKeySha256());
            this.opcSourceSseCustomerAlgorithm(o.getOpcSourceSseCustomerAlgorithm());
            this.opcSourceSseCustomerKey(o.getOpcSourceSseCustomerKey());
            this.opcSourceSseCustomerKeySha256(o.getOpcSourceSseCustomerKeySha256());
            this.opcSseKmsKeyId(o.getOpcSseKmsKeyId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CopyObjectRequest build() {
            CopyObjectRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(CopyObjectDetails body) {
            this.copyObjectDetails(body);
            return this;
        }

        public CopyObjectRequest buildWithoutInvocationCallback() {
            CopyObjectRequest request = new CopyObjectRequest();
            request.namespaceName = this.namespaceName;
            request.bucketName = this.bucketName;
            request.copyObjectDetails = this.copyObjectDetails;
            request.opcClientRequestId = this.opcClientRequestId;
            request.opcSseCustomerAlgorithm = this.opcSseCustomerAlgorithm;
            request.opcSseCustomerKey = this.opcSseCustomerKey;
            request.opcSseCustomerKeySha256 = this.opcSseCustomerKeySha256;
            request.opcSourceSseCustomerAlgorithm = this.opcSourceSseCustomerAlgorithm;
            request.opcSourceSseCustomerKey = this.opcSourceSseCustomerKey;
            request.opcSourceSseCustomerKeySha256 = this.opcSourceSseCustomerKeySha256;
            request.opcSseKmsKeyId = this.opcSseKmsKeyId;
            return request;
        }
    }
}

