/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.ui.scope;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.modules.refactoring.api.Scope;
import org.netbeans.modules.refactoring.java.api.ui.JavaScopeBuilder;
import org.netbeans.modules.refactoring.java.ui.scope.Bundle;
import org.netbeans.modules.refactoring.spi.ui.ScopeProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbPreferences;

public final class CustomScopeProvider
extends ScopeProvider.CustomScopeProvider {
    private static final String PREF_SCOPE = "FindUsages-Scope";
    private Scope customScope;

    public boolean initialize(Lookup context, AtomicBoolean cancel) {
        return true;
    }

    public void setScope(Scope value) {
        this.customScope = value != null ? Scope.create((Collection)value.getSourceRoots(), (Collection)value.getFolders(), (Collection)value.getFiles()) : null;
    }

    public boolean showCustomizer() {
        Scope nue = JavaScopeBuilder.open(Bundle.TTL_CustomScope(), this.customScope);
        if (nue != null) {
            this.customScope = nue;
            this.storeScope(this.customScope);
        }
        return nue != null;
    }

    public Scope getScope() {
        if (this.customScope == null) {
            this.customScope = this.readScope();
        }
        return this.customScope;
    }

    private void storeScope(Scope customScope) {
        try {
            this.storeFileList(customScope.getSourceRoots(), "sourceRoot");
            this.storeFileList(customScope.getFolders(), "folder");
            this.storeFileList(customScope.getFiles(), "file");
        }
        catch (BackingStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private Scope readScope() {
        try {
            if (NbPreferences.forModule(JavaScopeBuilder.class).nodeExists(PREF_SCOPE)) {
                return Scope.create(this.loadFileList("sourceRoot", FileObject.class), this.loadFileList("folder", NonRecursiveFolder.class), this.loadFileList("file", FileObject.class));
            }
        }
        catch (BackingStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return null;
    }

    private <T> List<T> loadFileList(String basekey, Class<T> type) throws BackingStoreException {
        Preferences pref = NbPreferences.forModule(JavaScopeBuilder.class).node(PREF_SCOPE).node(basekey);
        LinkedList<Object> toRet = new LinkedList<Object>();
        for (String key : pref.keys()) {
            String url = pref.get(key, null);
            if (url == null || url.isEmpty()) continue;
            try {
                final FileObject f = URLMapper.findFileObject((URL)new URL(url));
                if (f == null || !f.isValid()) continue;
                if (type.isAssignableFrom(FileObject.class)) {
                    toRet.add(f);
                    continue;
                }
                toRet.add(new NonRecursiveFolder(){

                    public FileObject getFolder() {
                        return f;
                    }
                });
            }
            catch (MalformedURLException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return toRet;
    }

    private void storeFileList(Set files, String basekey) throws BackingStoreException {
        Preferences pref = NbPreferences.forModule(ScopeProvider.CustomScopeProvider.class).node(PREF_SCOPE).node(basekey);
        assert (files != null);
        pref.clear();
        int count = 0;
        for (Object next : files) {
            if (next instanceof FileObject) {
                pref.put(basekey + count++, ((FileObject)next).toURL().toExternalForm());
                continue;
            }
            pref.put(basekey + count++, ((NonRecursiveFolder)next).getFolder().toURL().toExternalForm());
        }
        pref.flush();
    }
}

